/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tpc;

import com.hazelcast.cluster.Address;
import com.hazelcast.config.AdvancedNetworkConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.EndpointConfig;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.ServerSocketEndpointConfig;
import com.hazelcast.config.tpc.TpcSocketConfig;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.instance.impl.EnterpriseNodeExtension;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.tpc.ClientMessageDecoder;
import com.hazelcast.internal.tpc.ClientMessageEncoder;
import com.hazelcast.internal.tpc.TpcServerBootstrap;
import com.hazelcast.internal.tpcengine.Reactor;
import com.hazelcast.internal.tpcengine.TpcEngine;
import com.hazelcast.internal.tpcengine.TpcEngineBuilder;
import com.hazelcast.internal.tpcengine.net.AcceptRequest;
import com.hazelcast.internal.tpcengine.net.AsyncServerSocket;
import com.hazelcast.internal.tpcengine.net.AsyncSocket;
import com.hazelcast.internal.tpcengine.net.AsyncSocketBuilder;
import com.hazelcast.internal.tpcengine.net.AsyncSocketOptions;
import com.hazelcast.internal.tpcengine.net.AsyncSocketReader;
import com.hazelcast.internal.tpcengine.nio.NioReactorBuilder;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ssl.SSLEngineFactory;
import com.hazelcast.spi.impl.operationexecutor.impl.OperationExecutorImpl;
import com.hazelcast.spi.impl.operationexecutor.impl.TpcOperationScheduler;
import com.hazelcast.spi.impl.operationexecutor.impl.TpcPartitionOperationThread;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class EnterpriseTpcServerBootstrap
implements TpcServerBootstrap {
    private static final int TERMINATE_TIMEOUT_SECONDS = 5;
    private final ILogger logger;
    private final Address thisAddress;
    private final Node node;
    private TpcEngine tpcEngine;
    private final boolean tcpNoDelay = true;
    private final boolean enabled;
    private final Map<Reactor, Supplier<? extends AsyncSocketReader>> readHandlerSuppliers = new HashMap<Reactor, Supplier<? extends AsyncSocketReader>>();
    private final List<AsyncServerSocket> serverSockets = new ArrayList<AsyncServerSocket>();
    private final Config config;
    private volatile List<Integer> clientPorts;

    public EnterpriseTpcServerBootstrap(Node node) {
        this.node = node;
        this.logger = node.getLogger(EnterpriseTpcServerBootstrap.class);
        this.config = node.getConfig();
        this.enabled = TpcServerBootstrap.loadTpcEnabled(this.config);
        this.logger.info("TPC: " + (this.enabled ? "enabled" : "disabled"));
        this.thisAddress = node.getThisAddress();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public TpcEngine getTpcEngine() {
        return this.tpcEngine;
    }

    @Override
    public List<Integer> getClientPorts() {
        return this.clientPorts;
    }

    private TpcEngine newTpcEngine() {
        TpcEngineBuilder tpcEngineBuilder = new TpcEngineBuilder();
        NioReactorBuilder reactorBuilder = new NioReactorBuilder();
        reactorBuilder.setThreadFactory(new ThreadFactory(){
            int index;

            @Override
            public Thread newThread(Runnable eventloopRunnable) {
                OperationExecutorImpl operationExecutor = (OperationExecutorImpl)EnterpriseTpcServerBootstrap.this.node.nodeEngine.getOperationService().getOperationExecutor();
                TpcPartitionOperationThread operationThread = (TpcPartitionOperationThread)operationExecutor.getPartitionThreads()[this.index++];
                operationThread.setEventloopTask(eventloopRunnable);
                return operationThread;
            }
        });
        reactorBuilder.setSchedulerSupplier(TpcOperationScheduler::new);
        tpcEngineBuilder.setReactorBuilder(reactorBuilder);
        tpcEngineBuilder.setReactorCount(this.loadEventloopCount());
        return tpcEngineBuilder.build();
    }

    @Override
    public int eventloopCount() {
        return this.loadEventloopCount();
    }

    private int loadEventloopCount() {
        int coresCount;
        int allowedCount = ((EnterpriseNodeExtension)this.node.getNodeExtension()).getLicense().getAllowedTpcCores();
        String coresCountString = this.node.getProperties().getString(TPC_EVENTLOOP_COUNT);
        int n = coresCount = coresCountString == null ? this.config.getTpcConfig().getEventloopCount() : Integer.parseInt(coresCountString);
        if (coresCount > allowedCount) {
            this.logger.warning(String.format("User requested %d TPC cores via config, but the License provides only %d TPC cores. %d TPC cores will be used.", coresCount, allowedCount, allowedCount));
            coresCount = allowedCount;
        }
        return coresCount;
    }

    @Override
    public void start() {
        if (!this.enabled) {
            return;
        }
        this.logger.info("Starting TpcServerBootstrap");
        this.tpcEngine = this.newTpcEngine();
        OperationExecutorImpl operationExecutor = (OperationExecutorImpl)this.node.nodeEngine.getOperationService().getOperationExecutor();
        for (int k = 0; k < operationExecutor.getPartitionThreadCount(); ++k) {
            Reactor reactor = this.tpcEngine.reactor(k);
            TpcPartitionOperationThread partitionThread = (TpcPartitionOperationThread)operationExecutor.getPartitionThreads()[k];
            partitionThread.getQueue().setReactor(reactor);
        }
        this.tpcEngine.start();
        this.startServerSockets();
        this.clientPorts = this.serverSockets.stream().map(AsyncServerSocket::getLocalPort).collect(Collectors.toList());
    }

    private void startServerSockets() {
        TpcSocketConfig clientSocketConfig = this.getClientSocketConfig();
        SSLConfig clientSslConfig = this.getClientEndpointTlsConfig();
        boolean sslEnabled = clientSslConfig != null && clientSslConfig.isEnabled();
        SSLEngineFactory sslEngineFactory = sslEnabled ? this.node.getNodeExtension().createSslEngineFactory(clientSslConfig) : null;
        String[] range = clientSocketConfig.getPortRange().split("-");
        int port = Integer.parseInt(range[0]);
        int limit = Integer.parseInt(range[1]);
        for (int k = 0; k < this.tpcEngine.reactorCount(); ++k) {
            Reactor reactor = this.tpcEngine.reactor(k);
            Supplier<AsyncSocketReader> readHandlerSupplier = () -> new ClientMessageDecoder(this.node.clientEngine, this.node.getProperties());
            this.readHandlerSuppliers.put(reactor, readHandlerSupplier);
            boolean success = false;
            while (!success) {
                if (port > limit) {
                    throw new HazelcastException("Could not find a free port in the TPC socket port range.");
                }
                AsyncServerSocket serverSocket = this.newServerSocket(reactor, clientSocketConfig, sslEnabled, sslEngineFactory);
                try {
                    serverSocket.bind(new InetSocketAddress(this.thisAddress.getInetAddress(), port));
                    success = true;
                }
                catch (UncheckedIOException e) {
                    if (!(e.getCause() instanceof SocketException)) {
                        throw e;
                    }
                }
                catch (UnknownHostException e) {
                    throw new UncheckedIOException(e);
                }
                finally {
                    if (!success) {
                        IOUtil.closeResource(serverSocket);
                    }
                }
                if (success) {
                    this.serverSockets.add(serverSocket);
                    serverSocket.start();
                }
                ++port;
            }
        }
    }

    private AsyncServerSocket newServerSocket(Reactor reactor, TpcSocketConfig clientSocketConfig, boolean sslEnabled, SSLEngineFactory sslEngineFactory) {
        return reactor.newAsyncServerSocketBuilder().set(AsyncSocketOptions.SO_RCVBUF, clientSocketConfig.getReceiveBufferSizeKB() * 1024).setAcceptConsumer(acceptRequest -> {
            AsyncSocketBuilder socketBuilder = reactor.newAsyncSocketBuilder((AcceptRequest)acceptRequest).setReader(this.readHandlerSuppliers.get(reactor).get()).setWriter(new ClientMessageEncoder()).set(AsyncSocketOptions.SO_SNDBUF, clientSocketConfig.getSendBufferSizeKB() * 1024).set(AsyncSocketOptions.SO_RCVBUF, clientSocketConfig.getReceiveBufferSizeKB() * 1024).set(AsyncSocketOptions.TCP_NODELAY, true).set(AsyncSocketOptions.SO_KEEPALIVE, true);
            if (sslEnabled) {
                socketBuilder.set(AsyncSocketOptions.SSL_ENGINE_FACTORY, sslEngineFactory);
            }
            AsyncSocket socket = socketBuilder.build();
            socket.start();
        }).build();
    }

    @Override
    public TpcSocketConfig getClientSocketConfig() {
        this.validateSocketConfig();
        if (this.config.getAdvancedNetworkConfig().isEnabled()) {
            ServerSocketEndpointConfig endpointConfig = (ServerSocketEndpointConfig)this.config.getAdvancedNetworkConfig().getEndpointConfigs().get(EndpointQualifier.CLIENT);
            return endpointConfig.getTpcSocketConfig();
        }
        return this.config.getNetworkConfig().getTpcSocketConfig();
    }

    private void validateSocketConfig() {
        AdvancedNetworkConfig advancedNetworkConfig = this.config.getAdvancedNetworkConfig();
        if (advancedNetworkConfig.isEnabled()) {
            TpcSocketConfig defaultTpcSocketConfig = new TpcSocketConfig();
            Map<EndpointQualifier, EndpointConfig> endpointConfigs = advancedNetworkConfig.getEndpointConfigs();
            endpointConfigs.forEach((endpointQualifier, endpointConfig) -> {
                if (endpointQualifier != EndpointQualifier.CLIENT && !endpointConfig.getTpcSocketConfig().equals(defaultTpcSocketConfig)) {
                    throw new InvalidConfigurationException("TPC socket configuration is only available for clients ports for now.");
                }
            });
            if (endpointConfigs.get(EndpointQualifier.CLIENT) == null) {
                throw new InvalidConfigurationException("Missing client server socket configuration. If you have enabled TPC and advanced networking, please configure a client server socket.");
            }
        }
    }

    private SSLConfig getClientEndpointTlsConfig() {
        if (this.config.getAdvancedNetworkConfig().isEnabled()) {
            return this.config.getAdvancedNetworkConfig().getEndpointConfigs().get(EndpointQualifier.CLIENT).getSSLConfig();
        }
        return this.config.getNetworkConfig().getSSLConfig();
    }

    @Override
    public void shutdown() {
        if (!this.enabled) {
            return;
        }
        this.logger.info("TpcServerBootstrap shutdown");
        this.tpcEngine.shutdown();
        try {
            this.tpcEngine.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.logger.warning("TpcEngine failed to terminate.");
            Thread.currentThread().interrupt();
        }
        this.logger.info("TpcServerBootstrap terminated");
    }
}

