/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.server.tcp;

import com.hazelcast.cluster.Address;
import com.hazelcast.internal.util.EmptyStatement;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class LinkedAddresses {
    private final Address primaryAddress;
    private final Set<Address> allLinkedAddresses;

    LinkedAddresses(Address primaryAddress) {
        this.primaryAddress = primaryAddress;
        this.allLinkedAddresses = Collections.newSetFromMap(new ConcurrentHashMap());
        this.allLinkedAddresses.add(primaryAddress);
    }

    public Address getPrimaryAddress() {
        return this.primaryAddress;
    }

    public Set<Address> getAllAddresses() {
        return Collections.unmodifiableSet(this.allLinkedAddresses);
    }

    public void addAllResolvedAddresses(Address address) {
        this.addLinkedAddresses(LinkedAddresses.getResolvedAddresses(address));
    }

    public void addLinkedAddresses(LinkedAddresses other) {
        this.allLinkedAddresses.addAll(other.getAllAddresses());
    }

    public static LinkedAddresses getResolvedAddresses(Address primaryAddress) {
        LinkedAddresses linkedAddresses = new LinkedAddresses(primaryAddress);
        try {
            InetAddress inetAddress = primaryAddress.getInetAddress();
            String ip = inetAddress.getHostAddress();
            Address addressIp = new Address(ip, primaryAddress.getPort());
            linkedAddresses.addAddress(addressIp);
        }
        catch (UnknownHostException e) {
            EmptyStatement.ignore(e);
        }
        return linkedAddresses;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinkedAddresses that = (LinkedAddresses)o;
        return Objects.equals(this.primaryAddress, that.primaryAddress) && this.allLinkedAddresses.size() == that.allLinkedAddresses.size() && this.allLinkedAddresses.containsAll(that.allLinkedAddresses);
    }

    public int hashCode() {
        return this.primaryAddress != null ? this.primaryAddress.hashCode() : 0;
    }

    public boolean contains(Address address) {
        return this.allLinkedAddresses.contains(address);
    }

    public boolean intersects(LinkedAddresses other) {
        HashSet<Address> tmp = new HashSet<Address>(this.allLinkedAddresses);
        tmp.retainAll(other.getAllAddresses());
        return !tmp.isEmpty();
    }

    public String toString() {
        return "LinkedAddresses{primaryAddress=" + String.valueOf(this.primaryAddress) + ", allLinkedAddresses=" + String.valueOf(this.allLinkedAddresses) + "}";
    }

    private void addAddress(Address address) {
        this.allLinkedAddresses.add(address);
    }
}

