/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl;

import com.hazelcast.internal.memory.HeapMemoryAccessor;
import com.hazelcast.internal.memory.MemoryBlock;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.impl.NativeMemoryDataUtil;
import com.hazelcast.internal.util.HashUtil;
import java.nio.ByteOrder;

public final class NativeMemoryData
extends MemoryBlock
implements Data {
    public static final int SIZE_OFFSET = 0;
    public static final int PARTITION_HASH_OFFSET = 4;
    public static final int TYPE_OFFSET = 8;
    public static final int DATA_OFFSET = 12;
    public static final int NATIVE_MEMORY_DATA_OVERHEAD = 4;
    private static final boolean BIG_ENDIAN = ByteOrder.BIG_ENDIAN == ByteOrder.nativeOrder();

    public NativeMemoryData() {
    }

    public NativeMemoryData(long address, int size) {
        super(address, size);
    }

    @Override
    public int totalSize() {
        return NativeMemoryDataUtil.readTotalSize(this.address());
    }

    @Override
    public int dataSize() {
        return NativeMemoryDataUtil.readDataSize(this.address());
    }

    @Override
    public int getPartitionHash() {
        int hash = this.getPartitionHashCode();
        if (hash != 0) {
            return BIG_ENDIAN ? hash : Integer.reverseBytes(hash);
        }
        return this.hashCode();
    }

    private int getPartitionHashCode() {
        if (this.address == 0L) {
            return 0;
        }
        return this.readInt(4L);
    }

    @Override
    public boolean hasPartitionHash() {
        int hash = this.getPartitionHashCode();
        return hash != 0;
    }

    @Override
    public byte[] toByteArray() {
        int len = this.totalSize();
        byte[] buffer = new byte[len];
        this.copyTo(4L, buffer, HeapMemoryAccessor.ARRAY_BYTE_BASE_OFFSET, len);
        return buffer;
    }

    @Override
    public void copyTo(byte[] dest, int destPos) {
        this.copyTo(4L, dest, HeapMemoryAccessor.ARRAY_BYTE_BASE_OFFSET + destPos, this.totalSize());
    }

    @Override
    public int getType() {
        return NativeMemoryDataUtil.readType(this.address());
    }

    @Override
    public int getHeapCost() {
        return 12;
    }

    @Override
    public boolean isPortable() {
        return -1 == this.getType();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof Data)) {
            return false;
        }
        Data data = (Data)o;
        if (this.getType() != data.getType()) {
            return false;
        }
        int dataSize = this.dataSize();
        if (dataSize != data.dataSize()) {
            return false;
        }
        if (dataSize == 0) {
            return true;
        }
        if (data instanceof NativeMemoryData) {
            return NativeMemoryDataUtil.equals(this.address(), ((NativeMemoryData)data).address(), dataSize);
        }
        byte[] bytes = data.toByteArray();
        return NativeMemoryDataUtil.equals(this.address(), dataSize, bytes);
    }

    @Override
    public int hashCode() {
        if (this.address == 0L) {
            return 0;
        }
        return HashUtil.MurmurHash3_x86_32_direct(this.address(), 12, this.dataSize());
    }

    @Override
    public long hash64() {
        if (this.address == 0L) {
            return 0L;
        }
        return HashUtil.MurmurHash3_x64_64_direct(this.address(), 12, this.dataSize());
    }

    public NativeMemoryData reset(long address) {
        this.setAddress(address);
        if (address > 0L) {
            this.setSize(4);
            this.setSize(this.totalSize() + 4);
        } else {
            this.setSize(0);
        }
        return this;
    }

    public NativeMemoryData reset(long address, int size) {
        this.setAddress(address);
        if (address > 0L) {
            this.setSize(size);
        }
        return this;
    }

    @Override
    public boolean isJson() {
        return -130 == this.getType();
    }

    @Override
    public boolean isCompact() {
        return -55 == this.getType();
    }

    @Override
    public String toString() {
        if (this.address() > 0L) {
            StringBuilder sb = new StringBuilder("NativeMemoryData{");
            if (this.size() >= 12) {
                sb.append("type=").append(this.getType());
                sb.append(", hashCode=").append(this.hashCode());
                sb.append(", partitionHash=").append(this.getPartitionHash());
                sb.append(", totalSize=").append(this.totalSize());
                sb.append(", dataSize=").append(this.dataSize());
                sb.append(", heapCost=").append(this.getHeapCost());
                sb.append(", address=").append(this.address());
                sb.append(", blockSize=").append(this.size());
            } else {
                sb.append("address=").append(this.address());
                sb.append(", blockSize=").append(this.size()).append(" (invalid)");
            }
            sb.append('}');
            return sb.toString();
        }
        return "NativeMemoryData{ NULL }";
    }
}

