/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl;

import com.hazelcast.internal.nio.BufferObjectDataOutput;
import com.hazelcast.internal.nio.EnterpriseBufferObjectDataInput;
import com.hazelcast.internal.nio.EnterpriseBufferObjectDataOutput;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.InputOutputFactory;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.impl.EnterpriseByteArrayObjectDataInput;
import com.hazelcast.internal.serialization.impl.EnterpriseByteArrayObjectDataOutput;
import java.nio.ByteOrder;

final class EnterpriseByteArrayInputOutputFactory
implements InputOutputFactory {
    private final ByteOrder byteOrder;

    EnterpriseByteArrayInputOutputFactory(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    @Override
    public EnterpriseBufferObjectDataInput createInput(Data data, InternalSerializationService service, boolean isCompatibility) {
        EnterpriseSerializationService serializationService = (EnterpriseSerializationService)service;
        return new EnterpriseByteArrayObjectDataInput(data.toByteArray(), 8, serializationService, this.byteOrder, isCompatibility);
    }

    @Override
    public EnterpriseBufferObjectDataInput createInput(byte[] buffer, InternalSerializationService service, boolean isCompatibility) {
        return new EnterpriseByteArrayObjectDataInput(buffer, 0, (EnterpriseSerializationService)service, this.byteOrder, isCompatibility);
    }

    @Override
    public EnterpriseBufferObjectDataInput createInput(byte[] buffer, int offset, InternalSerializationService service, boolean isCompatibility) {
        return new EnterpriseByteArrayObjectDataInput(buffer, offset, (EnterpriseSerializationService)service, this.byteOrder, isCompatibility);
    }

    @Override
    public EnterpriseBufferObjectDataOutput createOutput(int size, InternalSerializationService service) {
        return new EnterpriseByteArrayObjectDataOutput(size, (EnterpriseSerializationService)service, this.byteOrder);
    }

    @Override
    public BufferObjectDataOutput createOutput(int initialSize, int firstGrowthSize, InternalSerializationService service) {
        return new EnterpriseByteArrayObjectDataOutput(initialSize, firstGrowthSize, (EnterpriseSerializationService)service, this.byteOrder);
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }
}

