/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.operation;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Member;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.internal.partition.MigrationCycleOperation;
import com.hazelcast.internal.partition.MigrationInfo;
import com.hazelcast.internal.partition.MigrationStateImpl;
import com.hazelcast.internal.partition.PartitionRuntimeState;
import com.hazelcast.internal.partition.impl.InternalPartitionImpl;
import com.hazelcast.internal.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.internal.partition.impl.MigrationInterceptor;
import com.hazelcast.internal.partition.impl.PartitionEventManager;
import com.hazelcast.internal.partition.impl.PartitionStateManager;
import com.hazelcast.internal.partition.operation.AbstractPartitionOperation;
import com.hazelcast.internal.partition.operation.BeforePromotionOperation;
import com.hazelcast.internal.partition.operation.FinalizePromotionOperation;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationservice.CallStatus;
import com.hazelcast.spi.impl.operationservice.ExceptionAction;
import com.hazelcast.spi.impl.operationservice.OperationService;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;

public class PromotionCommitOperation
extends AbstractPartitionOperation
implements MigrationCycleOperation {
    private PartitionRuntimeState partitionState;
    private Collection<MigrationInfo> promotions;
    private UUID expectedMemberUuid;
    private transient boolean success;
    private transient MigrationStateImpl migrationState;
    private transient RunStage runStage = RunStage.BEFORE_PROMOTION;

    public PromotionCommitOperation() {
    }

    public PromotionCommitOperation(PartitionRuntimeState partitionState, Collection<MigrationInfo> promotions, UUID expectedMemberUuid) {
        Preconditions.checkNotNull(promotions);
        this.partitionState = partitionState;
        this.promotions = promotions;
        this.expectedMemberUuid = expectedMemberUuid;
    }

    @Override
    public void beforeRun() throws Exception {
        if (this.runStage != RunStage.BEFORE_PROMOTION) {
            return;
        }
        NodeEngine nodeEngine = this.getNodeEngine();
        Member localMember = nodeEngine.getLocalMember();
        if (!localMember.getUuid().equals(this.expectedMemberUuid)) {
            throw new IllegalStateException("This " + String.valueOf(localMember) + " is promotion commit destination but most probably it's restarted and not the expected target.");
        }
        Address masterAddress = nodeEngine.getMasterAddress();
        Address caller = this.getCallerAddress();
        if (!caller.equals(masterAddress)) {
            throw new IllegalStateException("Caller is not master node! Caller: " + String.valueOf(caller) + ", Master: " + String.valueOf(masterAddress));
        }
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        if (!partitionService.isMemberMaster(caller)) {
            throw new RetryableHazelcastException("Caller is not master node known by migration system! Caller: " + String.valueOf(caller));
        }
    }

    @Override
    public CallStatus call() throws Exception {
        switch (this.runStage) {
            case BEFORE_PROMOTION: {
                return this.beforePromotion();
            }
            case FINALIZE_PROMOTION: {
                this.finalizePromotion();
                return CallStatus.VOID;
            }
            case COMPLETE: {
                this.complete();
                return CallStatus.RESPONSE;
            }
        }
        throw new IllegalStateException("Unknown state: " + String.valueOf((Object)this.runStage));
    }

    private CallStatus beforePromotion() {
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        OperationServiceImpl operationService = nodeEngine.getOperationService();
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        if (!partitionService.getMigrationManager().acquirePromotionPermit()) {
            throw new RetryableHazelcastException("Another promotion is being run currently. This is only expected when promotion is retried to an unresponsive destination.");
        }
        long partitionStateStamp = partitionService.getPartitionStateStamp();
        if (this.partitionState.getStamp() == partitionStateStamp) {
            return this.alreadyAppliedAllPromotions();
        }
        this.filterAlreadyAppliedPromotions();
        if (this.promotions.isEmpty()) {
            return this.alreadyAppliedAllPromotions();
        }
        ILogger logger = this.getLogger();
        this.migrationState = new MigrationStateImpl(Clock.currentTimeMillis(), this.promotions.size(), 0, 0L);
        partitionService.getMigrationInterceptor().onPromotionStart(MigrationInterceptor.MigrationParticipant.DESTINATION, this.promotions);
        partitionService.getPartitionEventManager().sendMigrationProcessStartedEvent(this.migrationState);
        if (logger.isFineEnabled()) {
            logger.fine("Submitting BeforePromotionOperations for " + this.promotions.size() + " promotions. Promotion partition state stamp: " + this.partitionState.getStamp() + ", current partition state stamp: " + partitionStateStamp);
        }
        BeforePromotionOperationCallback beforePromotionsCallback = new BeforePromotionOperationCallback(this, this.promotions.size());
        for (MigrationInfo promotion : this.promotions) {
            if (logger.isFinestEnabled()) {
                logger.finest("Submitting BeforePromotionOperation for promotion: " + String.valueOf(promotion));
            }
            BeforePromotionOperation op = new BeforePromotionOperation(promotion, beforePromotionsCallback);
            op.setPartitionId(promotion.getPartitionId()).setNodeEngine(nodeEngine).setService(partitionService);
            operationService.execute(op);
        }
        return CallStatus.VOID;
    }

    private CallStatus alreadyAppliedAllPromotions() {
        this.getLogger().warning("Already applied all promotions to the partition state. Promotion state stamp: " + this.partitionState.getStamp());
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        partitionService.getMigrationManager().releasePromotionPermit();
        this.success = true;
        return CallStatus.RESPONSE;
    }

    private void filterAlreadyAppliedPromotions() {
        ILogger logger = this.getLogger();
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        PartitionStateManager stateManager = partitionService.getPartitionStateManager();
        Iterator<MigrationInfo> iter = this.promotions.iterator();
        while (iter.hasNext()) {
            MigrationInfo promotion = iter.next();
            InternalPartitionImpl partition = stateManager.getPartitionImpl(promotion.getPartitionId());
            if (partition.version() < promotion.getFinalPartitionVersion()) continue;
            logger.fine("Already applied promotion commit. -> " + String.valueOf(promotion));
            iter.remove();
        }
    }

    private void finalizePromotion() {
        NodeEngine nodeEngine = this.getNodeEngine();
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        OperationService operationService = nodeEngine.getOperationService();
        this.partitionState.setMaster(this.getCallerAddress());
        this.success = partitionService.processPartitionRuntimeState(this.partitionState);
        ILogger logger = this.getLogger();
        if (!this.success) {
            logger.severe("Promotion of " + this.promotions.size() + " partitions failed. . Promotion partition state stamp: " + this.partitionState.getStamp() + ", current partition state stamp: " + partitionService.getPartitionStateStamp());
        }
        if (logger.isFineEnabled()) {
            logger.fine("Submitting FinalizePromotionOperations for " + this.promotions.size() + " promotions. Result: " + this.success + ". Promotion partition state stamp: " + this.partitionState.getStamp() + ", current partition state stamp: " + partitionService.getPartitionStateStamp());
        }
        FinalizePromotionOperationCallback finalizePromotionsCallback = new FinalizePromotionOperationCallback(this, this.promotions.size());
        for (MigrationInfo promotion : this.promotions) {
            if (logger.isFinestEnabled()) {
                logger.finest("Submitting FinalizePromotionOperation for promotion: " + String.valueOf(promotion) + ". Result: " + this.success);
            }
            FinalizePromotionOperation op = new FinalizePromotionOperation(promotion, this.success, finalizePromotionsCallback);
            op.setPartitionId(promotion.getPartitionId()).setNodeEngine(nodeEngine).setService(partitionService);
            operationService.execute(op);
        }
    }

    private void complete() {
        InternalPartitionServiceImpl service = (InternalPartitionServiceImpl)this.getService();
        service.getMigrationInterceptor().onPromotionComplete(MigrationInterceptor.MigrationParticipant.DESTINATION, this.promotions, this.success);
        PartitionEventManager eventManager = service.getPartitionEventManager();
        MigrationStateImpl ms = this.migrationState;
        for (MigrationInfo promotion : this.promotions) {
            ms = ms.onComplete(1, 0L);
            eventManager.sendMigrationEvent(ms, promotion, 0L);
        }
        eventManager.sendMigrationProcessCompletedEvent(ms);
        service.getMigrationManager().releasePromotionPermit();
    }

    private void scheduleNextRun(RunStage nextState) {
        this.runStage = nextState;
        this.getNodeEngine().getOperationService().execute(this);
    }

    @Override
    public int getClassId() {
        return 8;
    }

    @Override
    public Object getResponse() {
        return this.success;
    }

    @Override
    public String getServiceName() {
        return "hz:core:partitionService";
    }

    @Override
    public ExceptionAction onInvocationException(Throwable throwable) {
        if (throwable instanceof MemberLeftException || throwable instanceof TargetNotMemberException) {
            return ExceptionAction.THROW_EXCEPTION;
        }
        return super.onInvocationException(throwable);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.expectedMemberUuid = UUIDSerializationUtil.readUUID(in);
        this.partitionState = (PartitionRuntimeState)in.readObject();
        this.promotions = SerializationUtil.readCollection(in);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        UUIDSerializationUtil.writeUUID(out, this.expectedMemberUuid);
        out.writeObject(this.partitionState);
        SerializationUtil.writeCollection(this.promotions, out);
    }

    private static enum RunStage {
        BEFORE_PROMOTION,
        FINALIZE_PROMOTION,
        COMPLETE;

    }

    private static class BeforePromotionOperationCallback
    implements PromotionOperationCallback {
        private final PromotionCommitOperation promotionCommitOperation;
        private final AtomicInteger tasks;

        BeforePromotionOperationCallback(PromotionCommitOperation promotionCommitOperation, int tasks) {
            this.promotionCommitOperation = promotionCommitOperation;
            this.tasks = new AtomicInteger(tasks);
        }

        @Override
        public void onComplete(MigrationInfo promotion) {
            int remainingTasks = this.tasks.decrementAndGet();
            ILogger logger = this.promotionCommitOperation.getLogger();
            if (logger.isFinestEnabled()) {
                logger.finest("Completed before stage of " + String.valueOf(promotion) + ". Remaining before promotion tasks: " + remainingTasks);
            }
            if (remainingTasks == 0) {
                logger.fine("All before promotion tasks are completed. Starting finalize promotion tasks...");
                this.promotionCommitOperation.scheduleNextRun(RunStage.FINALIZE_PROMOTION);
            }
        }
    }

    static interface PromotionOperationCallback {
        public void onComplete(MigrationInfo var1);
    }

    private static class FinalizePromotionOperationCallback
    implements PromotionOperationCallback {
        private final PromotionCommitOperation promotionCommitOperation;
        private final AtomicInteger tasks;

        FinalizePromotionOperationCallback(PromotionCommitOperation promotionCommitOperation, int tasks) {
            this.promotionCommitOperation = promotionCommitOperation;
            this.tasks = new AtomicInteger(tasks);
        }

        @Override
        public void onComplete(MigrationInfo promotion) {
            int remainingTasks = this.tasks.decrementAndGet();
            ILogger logger = this.promotionCommitOperation.getLogger();
            if (logger.isFinestEnabled()) {
                logger.finest("Completed finalize stage of " + String.valueOf(promotion) + ". Remaining finalize promotion tasks: " + remainingTasks);
            }
            if (remainingTasks == 0) {
                logger.fine("All finalize promotion tasks are completed.");
                this.promotionCommitOperation.scheduleNextRun(RunStage.COMPLETE);
            }
        }
    }
}

