/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.impl.MemberImpl;
import com.hazelcast.instance.impl.NodeState;
import com.hazelcast.internal.partition.InternalPartition;
import com.hazelcast.internal.partition.PartitionReplica;
import com.hazelcast.internal.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.internal.partition.operation.SafeStateCheckOperation;
import com.hazelcast.internal.util.FutureUtil;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.logging.ILogger;
import com.hazelcast.partition.MigrationListener;
import com.hazelcast.partition.Partition;
import com.hazelcast.partition.PartitionLostListener;
import com.hazelcast.partition.PartitionService;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import com.hazelcast.spi.properties.ClusterProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class PartitionServiceProxy
implements PartitionService {
    private final NodeEngineImpl nodeEngine;
    private final InternalPartitionServiceImpl partitionService;
    private final Map<Integer, Partition> partitionMap;
    private final Set<Partition> partitionSet;
    private final ILogger logger;
    private final FutureUtil.ExceptionHandler exceptionHandler = new FutureUtil.ExceptionHandler(){

        @Override
        public void handleException(Throwable e) {
            PartitionServiceProxy.this.logger.warning("Error while querying cluster's safe state", e);
        }
    };

    public PartitionServiceProxy(NodeEngineImpl nodeEngine, InternalPartitionServiceImpl partitionService) {
        this.nodeEngine = nodeEngine;
        this.partitionService = partitionService;
        int partitionCount = partitionService.getPartitionCount();
        Map<Integer, PartitionProxy> map = MapUtil.createHashMap(partitionCount);
        TreeSet<PartitionProxy> set = new TreeSet<PartitionProxy>();
        for (int i = 0; i < partitionCount; ++i) {
            PartitionProxy partition = new PartitionProxy(i);
            set.add(partition);
            map.put(i, partition);
        }
        this.partitionMap = Collections.unmodifiableMap(map);
        this.partitionSet = Collections.unmodifiableSet(set);
        this.logger = nodeEngine.getLogger(PartitionServiceProxy.class);
    }

    @Override
    public Set<Partition> getPartitions() {
        return this.partitionSet;
    }

    @Override
    public Partition getPartition(@Nonnull Object key) {
        Preconditions.checkNotNull(key, "key cannot be null");
        int partitionId = this.partitionService.getPartitionId(key);
        return this.partitionMap.get(partitionId);
    }

    @Override
    public UUID addMigrationListener(MigrationListener migrationListener) {
        return this.partitionService.addMigrationListener(migrationListener);
    }

    @Override
    public boolean removeMigrationListener(UUID registrationId) {
        return this.partitionService.removeMigrationListener(registrationId);
    }

    @Override
    public UUID addPartitionLostListener(PartitionLostListener partitionLostListener) {
        return this.partitionService.addPartitionLostListener(partitionLostListener);
    }

    @Override
    public boolean removePartitionLostListener(UUID registrationId) {
        return this.partitionService.removePartitionLostListener(registrationId);
    }

    @Override
    public boolean isClusterSafe() {
        Set<Member> members = this.nodeEngine.getClusterService().getMembers();
        if (members == null || members.isEmpty()) {
            return true;
        }
        ArrayList futures = new ArrayList(members.size());
        for (Member member : members) {
            Address target = member.getAddress();
            SafeStateCheckOperation operation = new SafeStateCheckOperation();
            InvocationFuture future = this.nodeEngine.getOperationService().invokeOnTarget("hz:core:partitionService", operation, target);
            futures.add(future);
        }
        int maxWaitTime = this.getMaxWaitTime();
        Collection<Boolean> results = FutureUtil.returnWithDeadline(futures, maxWaitTime, TimeUnit.SECONDS, this.exceptionHandler);
        if (results.size() != futures.size()) {
            return false;
        }
        for (Boolean result : results) {
            if (result.booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isMemberSafe(Member member) {
        boolean safe;
        if (member == null) {
            throw new NullPointerException("Parameter member must not be null");
        }
        MemberImpl localMember = this.nodeEngine.getLocalMember();
        if (((Object)localMember).equals(member)) {
            return this.isLocalMemberSafe();
        }
        Address target = member.getAddress();
        SafeStateCheckOperation operation = new SafeStateCheckOperation();
        InvocationFuture future = this.nodeEngine.getOperationService().invokeOnTarget("hz:core:partitionService", operation, target);
        try {
            Object result = future.get(10L, TimeUnit.SECONDS);
            safe = (Boolean)result;
        }
        catch (Throwable t) {
            safe = false;
            this.logger.warning("Error while querying member's safe state [" + String.valueOf(member) + "]", t);
        }
        return safe;
    }

    @Override
    public boolean isLocalMemberSafe() {
        if (!this.nodeActive()) {
            return true;
        }
        return this.partitionService.isMemberStateSafe();
    }

    @Override
    public boolean forceLocalMemberToBeSafe(long timeout, TimeUnit unit) {
        if (unit == null) {
            throw new NullPointerException();
        }
        if (timeout < 1L) {
            throw new IllegalArgumentException();
        }
        if (!this.nodeActive()) {
            return true;
        }
        return this.partitionService.getPartitionReplicaStateChecker().triggerAndWaitForReplicaSync(timeout, unit);
    }

    private boolean nodeActive() {
        return this.nodeEngine.getNode().getState() != NodeState.SHUT_DOWN;
    }

    private int getMaxWaitTime() {
        return this.nodeEngine.getProperties().getSeconds(ClusterProperty.GRACEFUL_SHUTDOWN_MAX_WAIT);
    }

    private class PartitionProxy
    implements Partition,
    Comparable {
        final int partitionId;

        PartitionProxy(int partitionId) {
            this.partitionId = partitionId;
        }

        @Override
        public int getPartitionId() {
            return this.partitionId;
        }

        @Override
        public Member getOwner() {
            InternalPartition partition = PartitionServiceProxy.this.partitionService.getPartition(this.partitionId);
            PartitionReplica owner = partition.getOwnerReplicaOrNull();
            if (owner == null) {
                return null;
            }
            return PartitionServiceProxy.this.nodeEngine.getClusterService().getMember(owner.address(), owner.uuid());
        }

        public int compareTo(Object o) {
            PartitionProxy partition = (PartitionProxy)o;
            return Integer.compare(this.partitionId, partition.partitionId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PartitionProxy partition = (PartitionProxy)o;
            return this.partitionId == partition.partitionId;
        }

        public int hashCode() {
            return this.partitionId;
        }

        public String toString() {
            return "Partition [" + this.partitionId + "], owner=" + String.valueOf(this.getOwner());
        }
    }
}

