/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.nio.tcp;

import com.hazelcast.config.SymmetricEncryptionConfig;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.internal.networking.ChannelOption;
import com.hazelcast.internal.networking.HandlerStatus;
import com.hazelcast.internal.networking.OutboundHandler;
import com.hazelcast.internal.nio.CipherHelper;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.nio.Packet;
import com.hazelcast.internal.nio.PacketIOHelper;
import com.hazelcast.internal.server.ServerConnection;
import java.nio.ByteBuffer;
import java.util.function.Supplier;
import javax.crypto.Cipher;

public class SymmetricCipherPacketEncoder
extends OutboundHandler<Supplier<Packet>, ByteBuffer> {
    private final Cipher cipher;
    private final PacketIOHelper packetWriter = new PacketIOHelper();
    private Packet packet;
    private ByteBuffer packetBuffer;
    private boolean packetWritten;

    public SymmetricCipherPacketEncoder(ServerConnection connection, SymmetricEncryptionConfig config) {
        this.cipher = CipherHelper.createSymmetricWriterCipher(config, connection);
    }

    @Override
    public void handlerAdded() {
        this.initDstBuffer();
        this.packetBuffer = ByteBuffer.allocate(this.channel.options().getOption(ChannelOption.SO_SNDBUF));
    }

    @Override
    public HandlerStatus onWrite() throws Exception {
        IOUtil.compactOrClear((ByteBuffer)this.dst);
        try {
            while (true) {
                if (this.packet == null) {
                    this.packet = (Packet)((Supplier)this.src).get();
                    if (this.packet == null) {
                        HandlerStatus handlerStatus = HandlerStatus.CLEAN;
                        return handlerStatus;
                    }
                }
                if (!this.packetWritten) {
                    if (((ByteBuffer)this.dst).remaining() < 4) {
                        HandlerStatus handlerStatus = HandlerStatus.DIRTY;
                        return handlerStatus;
                    }
                    int size = this.cipher.getOutputSize(this.packet.getFrameLength());
                    ((ByteBuffer)this.dst).putInt(size);
                    if (this.packetBuffer.capacity() < this.packet.getFrameLength()) {
                        this.packetBuffer = ByteBuffer.allocate(this.packet.getFrameLength());
                    }
                    if (!this.packetWriter.writeTo(this.packet, this.packetBuffer)) {
                        throw new HazelcastException("Packet didn't fit into the buffer! " + this.packet.getFrameLength() + " VS " + String.valueOf(this.packetBuffer));
                    }
                    this.packetBuffer.flip();
                    this.packetWritten = true;
                }
                if (!((ByteBuffer)this.dst).hasRemaining()) continue;
                int outputSize = this.cipher.getOutputSize(this.packetBuffer.remaining());
                if (outputSize <= ((ByteBuffer)this.dst).remaining()) {
                    this.cipher.update(this.packetBuffer, (ByteBuffer)this.dst);
                } else {
                    int len;
                    for (len = this.packetBuffer.remaining() / 2; len > 0 && this.cipher.getOutputSize(len) > ((ByteBuffer)this.dst).remaining(); len /= 2) {
                    }
                    if (len > 0) {
                        int limitOld = this.packetBuffer.limit();
                        this.packetBuffer.limit(this.packetBuffer.position() + len);
                        this.cipher.update(this.packetBuffer, (ByteBuffer)this.dst);
                        this.packetBuffer.limit(limitOld);
                    } else {
                        HandlerStatus handlerStatus = HandlerStatus.DIRTY;
                        return handlerStatus;
                    }
                }
                if (this.packetBuffer.hasRemaining() || ((ByteBuffer)this.dst).remaining() < this.cipher.getOutputSize(0)) continue;
                ((ByteBuffer)this.dst).put(this.cipher.doFinal());
                this.packetWritten = false;
                this.packet = null;
                this.packetBuffer.clear();
            }
        }
        finally {
            ((ByteBuffer)this.dst).flip();
        }
    }
}

