/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.nio.ssl;

import com.hazelcast.internal.networking.HandlerStatus;
import com.hazelcast.internal.networking.OutboundHandler;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.nio.ssl.TLSEncoder;
import com.hazelcast.internal.nio.ssl.TLSExecutor;
import com.hazelcast.internal.nio.ssl.TLSHandshakeDecoder;
import com.hazelcast.internal.nio.ssl.TLSUtil;
import com.hazelcast.logging.Logger;
import java.io.EOFException;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentMap;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLHandshakeException;

public class TLSHandshakeEncoder
extends OutboundHandler<Void, ByteBuffer> {
    private final SSLEngine sslEngine;
    private final ByteBuffer emptyBuffer = ByteBuffer.allocate(0);
    private final TLSExecutor tlsExecutor;
    private final ConcurrentMap attributeMap;
    private volatile boolean isHandshakeFailed;

    TLSHandshakeEncoder(SSLEngine sslEngine, TLSExecutor tlsExecutor, ConcurrentMap attributeMap) {
        this.sslEngine = sslEngine;
        this.tlsExecutor = tlsExecutor;
        this.attributeMap = attributeMap;
    }

    @Override
    public void handlerAdded() {
        this.initDstBuffer(this.sslEngine.getSession().getPacketBufferSize());
    }

    @Override
    public void interceptError(Throwable t) throws Throwable {
        if (t instanceof EOFException) {
            throw TLSHandshakeDecoder.newSSLException(t);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public HandlerStatus onWrite() throws Exception {
        IOUtil.compactOrClear((ByteBuffer)this.dst);
        try {
            block19: while (true) {
                handshakeStatus = this.sslEngine.getHandshakeStatus();
                switch (1.$SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus[handshakeStatus.ordinal()]) {
                    case 1: {
                        continue block19;
                    }
                    case 2: {
                        this.tlsExecutor.executeHandshakeTasks(this.sslEngine, this.channel);
                        var2_3 = HandlerStatus.BLOCKED;
                        return var2_3;
                    }
                    case 3: {
                        wrapResult = this.sslEngine.wrap(this.emptyBuffer, (ByteBuffer)this.dst);
                        wrapResultStatus = wrapResult.getStatus();
                        if (wrapResultStatus != SSLEngineResult.Status.OK) ** break;
                        continue block19;
                        if (wrapResultStatus == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                            var4_5 = HandlerStatus.DIRTY;
                            return var4_5;
                        }
                        if (wrapResultStatus != SSLEngineResult.Status.CLOSED) throw new IllegalStateException("Unexpected wrapResult:" + String.valueOf(wrapResult));
                        var4_6 = HandlerStatus.CLEAN;
                        return var4_6;
                    }
                    case 4: {
                        this.channel.inboundPipeline().wakeup();
                        var4_7 = HandlerStatus.BLOCKED;
                        return var4_7;
                    }
                    case 5: {
                        if (!this.isTlsHandshakeBufferDrained()) {
                            var4_8 = HandlerStatus.DIRTY;
                            return var4_8;
                        }
                        if (this.isHandshakeFailed) {
                            throw new SSLHandshakeException("TLS handshake failed.");
                        }
                        TLSUtil.publishRemoteCertificates(this.sslEngine, this.attributeMap);
                        this.channel.outboundPipeline().replace(this, new OutboundHandler[]{new TLSEncoder(this.sslEngine)});
                        this.channel.inboundPipeline().wakeup();
                        var4_9 = HandlerStatus.CLEAN;
                        return var4_9;
                    }
                }
                break;
            }
            throw new IllegalStateException();
        }
        catch (SSLHandshakeException e) {
            if (this.isHandshakeFailed) {
                throw e;
            }
            this.isHandshakeFailed = true;
            Logger.getLogger(this.getClass()).fine("TLS handshake failed. The SSLEngine.closeOutbound() will be called.", e);
            this.sslEngine.closeOutbound();
            this.sslEngine.wrap(this.emptyBuffer, (ByteBuffer)this.dst);
            if (this.isTlsHandshakeBufferDrained() != false) throw e;
            var2_3 = HandlerStatus.DIRTY;
            return var2_3;
        }
        finally {
            ((ByteBuffer)this.dst).flip();
        }
    }

    private boolean isTlsHandshakeBufferDrained() {
        return ((ByteBuffer)this.dst).position() == 0;
    }
}

