/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.nio.ssl;

import com.hazelcast.internal.networking.ChannelOption;
import com.hazelcast.internal.networking.HandlerStatus;
import com.hazelcast.internal.networking.OutboundHandler;
import com.hazelcast.internal.nio.IOUtil;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;

public class TLSEncoder
extends OutboundHandler<ByteBuffer, ByteBuffer> {
    private final SSLEngine sslEngine;

    public TLSEncoder(SSLEngine sslEngine) {
        this.sslEngine = sslEngine;
    }

    @Override
    public void handlerAdded() {
        int sendBufferSize = this.channel.options().getOption(ChannelOption.SO_SNDBUF);
        int packetBufferSize = this.sslEngine.getSession().getPacketBufferSize();
        this.initDstBuffer(Math.max(sendBufferSize, packetBufferSize));
    }

    @Override
    public HandlerStatus onWrite() throws Exception {
        IOUtil.compactOrClear((ByteBuffer)this.dst);
        try {
            SSLEngineResult wrapResult = this.sslEngine.wrap((ByteBuffer)this.src, (ByteBuffer)this.dst);
            switch (wrapResult.getStatus()) {
                case BUFFER_OVERFLOW: {
                    HandlerStatus handlerStatus = HandlerStatus.DIRTY;
                    return handlerStatus;
                }
                case OK: {
                    if (((ByteBuffer)this.src).remaining() > 0) {
                        HandlerStatus handlerStatus = HandlerStatus.DIRTY;
                        return handlerStatus;
                    }
                    HandlerStatus handlerStatus = HandlerStatus.CLEAN;
                    return handlerStatus;
                }
                case CLOSED: {
                    HandlerStatus handlerStatus = HandlerStatus.CLEAN;
                    return handlerStatus;
                }
            }
            throw new IllegalStateException("Unexpected " + String.valueOf(wrapResult));
        }
        finally {
            ((ByteBuffer)this.dst).flip();
        }
    }
}

