/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.namespace.impl;

import com.hazelcast.config.ConfigAccessor;
import com.hazelcast.config.JavaSerializationFilterConfig;
import com.hazelcast.config.UserCodeNamespaceConfig;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricsCollectionContext;
import com.hazelcast.internal.monitor.impl.LocalUserCodeNamespaceResourceStats;
import com.hazelcast.internal.monitor.impl.LocalUserCodeNamespaceResourceStatsImpl;
import com.hazelcast.internal.monitor.impl.LocalUserCodeNamespaceStats;
import com.hazelcast.internal.monitor.impl.LocalUserCodeNamespaceStatsImpl;
import com.hazelcast.internal.namespace.ResourceDefinition;
import com.hazelcast.internal.namespace.UserCodeNamespaceService;
import com.hazelcast.internal.namespace.impl.NamespaceAwareDriverManagerInterface;
import com.hazelcast.internal.namespace.impl.NamespaceThreadLocalContext;
import com.hazelcast.internal.nio.ClassLoaderUtil;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.SerializationClassNameFilter;
import com.hazelcast.internal.services.ManagedService;
import com.hazelcast.internal.util.ConstructorFunction;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.jet.impl.JobRepository;
import com.hazelcast.jet.impl.deployment.MapResourceClassLoader;
import com.hazelcast.jet.impl.util.ReflectionUtils;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.properties.ClusterProperty;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class UserCodeNamespaceServiceImpl
implements UserCodeNamespaceService,
ManagedService {
    private final ConcurrentMap<String, MapResourceClassLoader> namespaceToClassLoader = new ConcurrentHashMap<String, MapResourceClassLoader>();
    private final ConcurrentMap<String, LocalUserCodeNamespaceStats> statsMap = new ConcurrentHashMap<String, LocalUserCodeNamespaceStats>();
    private final ConstructorFunction<String, LocalUserCodeNamespaceStatsImpl> statsConstructorFunction = name -> new LocalUserCodeNamespaceStatsImpl();
    private final ClassLoader configClassLoader;
    private final SerializationClassNameFilter classFilter;
    private final ILogger logger = Logger.getLogger(UserCodeNamespaceServiceImpl.class);
    private boolean hasDefaultNamespace;

    public UserCodeNamespaceServiceImpl(ClassLoader configClassLoader, Map<String, UserCodeNamespaceConfig> nsConfigs, JavaSerializationFilterConfig filterConfig) {
        this.configClassLoader = configClassLoader;
        this.classFilter = filterConfig != null ? new SerializationClassNameFilter(filterConfig) : null;
        nsConfigs.forEach((nsName, nsConfig) -> this.addNamespace((String)nsName, ConfigAccessor.getResourceDefinitions(nsConfig)));
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        boolean dsMetricsEnabled = nodeEngine.getProperties().getBoolean(ClusterProperty.METRICS_USER_CODE_NAMESPACES);
        if (dsMetricsEnabled) {
            ((NodeEngineImpl)nodeEngine).getMetricsRegistry().registerDynamicMetricsProvider(this);
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean isDefaultNamespaceDefined() {
        return this.hasDefaultNamespace;
    }

    @Override
    public void addNamespace(@Nonnull String nsName, @Nonnull Collection<ResourceDefinition> resources) {
        Objects.requireNonNull(nsName, "namespace name cannot be null");
        Objects.requireNonNull(resources, "resources cannot be null");
        ConcurrentHashMap<String, byte[]> resourceMap = new ConcurrentHashMap<String, byte[]>();
        for (ResourceDefinition r : resources) {
            this.handleResource(nsName, r, resourceMap);
        }
        MapResourceClassLoader updated = new MapResourceClassLoader(nsName, this.configClassLoader, () -> resourceMap, true);
        MapResourceClassLoader removed = this.namespaceToClassLoader.put(nsName, updated);
        if (removed != null) {
            UserCodeNamespaceServiceImpl.cleanUpClassLoader(nsName, removed);
        }
        UserCodeNamespaceServiceImpl.initializeClassLoader(nsName, updated);
        if (nsName.equals("default")) {
            this.hasDefaultNamespace = true;
        }
        this.setNamespaceStats(nsName, resources);
    }

    private void setNamespaceStats(String nsName, Collection<ResourceDefinition> resourceDefinitions) {
        LocalUserCodeNamespaceStatsImpl nsStats = this.statsConstructorFunction.createNew(nsName);
        HashMap<String, LocalUserCodeNamespaceResourceStats> resourceStatsMap = new HashMap<String, LocalUserCodeNamespaceResourceStats>(resourceDefinitions.size());
        for (ResourceDefinition resource : resourceDefinitions) {
            LocalUserCodeNamespaceResourceStatsImpl resourceStats = new LocalUserCodeNamespaceResourceStatsImpl(resource.payload().length, resource.type());
            resourceStatsMap.put(resource.id(), resourceStats);
        }
        nsStats.setLocalUserCodeNamespaceResourceStats(resourceStatsMap);
        this.statsMap.put(nsName, nsStats);
    }

    @Override
    public boolean hasNamespace(String namespace) {
        return this.namespaceToClassLoader.containsKey(namespace);
    }

    private void setupNs(@Nullable String namespace) {
        if (namespace == null) {
            return;
        }
        MapResourceClassLoader loader = this.getClassLoaderForExactNamespace(namespace);
        if (loader == null) {
            throw new IllegalArgumentException(String.format("There is no environment defined for provided Namespace: %s\nAdd a new NamespaceConfig with the name '%s' and define resources to use this Namespace.", namespace, namespace));
        }
        NamespaceThreadLocalContext.onStartNsAware(loader);
    }

    private static void cleanupNs(@Nullable String namespace) {
        if (namespace == null) {
            return;
        }
        NamespaceThreadLocalContext.onCompleteNsAware(namespace);
    }

    @Override
    public void setupNamespace(@Nullable String namespace) {
        this.setupNs(this.transformNamespace(namespace));
    }

    @Override
    public void cleanupNamespace(@Nullable String namespace) {
        UserCodeNamespaceServiceImpl.cleanupNs(this.transformNamespace(namespace));
    }

    @Override
    public void runWithNamespace(@Nullable String namespace, Runnable runnable) {
        namespace = this.transformNamespace(namespace);
        this.setupNs(namespace);
        try {
            runnable.run();
        }
        finally {
            UserCodeNamespaceServiceImpl.cleanupNs(namespace);
        }
    }

    @Override
    public <V> V callWithNamespace(@Nullable String namespace, Callable<V> callable) {
        namespace = this.transformNamespace(namespace);
        this.setupNs(namespace);
        try {
            V v = callable.call();
            return v;
        }
        catch (Exception e) {
            throw ExceptionUtil.sneakyThrow(e);
        }
        finally {
            UserCodeNamespaceServiceImpl.cleanupNs(namespace);
        }
    }

    @Override
    public ClassLoader getClassLoaderForNamespace(@Nullable String namespace) {
        if ((namespace = this.transformNamespace(namespace)) != null) {
            return (ClassLoader)this.namespaceToClassLoader.get(namespace);
        }
        return null;
    }

    private String transformNamespace(String namespace) {
        if (namespace != null) {
            return namespace;
        }
        if (this.isDefaultNamespaceDefined()) {
            return "default";
        }
        return null;
    }

    private void handleResource(String nsName, ResourceDefinition resource, Map<String, byte[]> resourceMap) {
        int startingResourceSize = resourceMap.size();
        switch (resource.type()) {
            case JAR: {
                this.handleJar(resource.id(), resource.payload(), resourceMap);
                break;
            }
            case JARS_IN_ZIP: {
                this.handleJarInZip(resource.id(), resource.payload(), resourceMap);
                break;
            }
            case CLASS: {
                this.handleClass(resource.id(), resource.payload(), resourceMap);
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot handle resource type " + String.valueOf((Object)resource.type()));
            }
        }
        if (resourceMap.size() == startingResourceSize) {
            this.logger.info(String.format("The resource '%s' at URL '%s' in Namespace '%s' does not contain any valid contents", resource.id(), resource.url(), nsName));
        }
    }

    private void handleJar(String id, InputStream inputStream, Map<String, byte[]> resourceMap) {
        try {
            JarEntry entry;
            JarInputStream jarInputStream = new JarInputStream(inputStream);
            while ((entry = jarInputStream.getNextJarEntry()) != null) {
                if (entry.isDirectory()) continue;
                String className = ClassLoaderUtil.extractClassName(entry.getName());
                if (className != null && this.classFilter != null) {
                    this.classFilter.filter(className);
                }
                byte[] payload = IOUtil.compress(jarInputStream.readAllBytes());
                jarInputStream.closeEntry();
                resourceMap.put(className == null ? JobRepository.fileKeyName(entry.getName()) : JobRepository.classKeyName(ReflectionUtils.toClassResourceId(className)), payload);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to read from JAR bytes for resource with id " + id, e);
        }
    }

    private void handleJarInZip(String id, byte[] zipBytes, Map<String, byte[]> resourceMap) {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(zipBytes);){
            JobRepository.executeOnJarsInZIP(inputStream, zis -> this.handleJar(id, (InputStream)zis, resourceMap));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to read from JAR bytes for resource with id " + id, e);
        }
    }

    private void handleClass(String id, byte[] classBytes, Map<String, byte[]> resourceMap) {
        try {
            String fqClassName = Objects.requireNonNull(ReflectionUtils.getInternalBinaryName(classBytes), () -> "Unable to extract internal binary name from " + id);
            String extractedClassName = ClassLoaderUtil.extractClassName(fqClassName + ".class");
            if (extractedClassName != null && this.classFilter != null) {
                this.classFilter.filter(extractedClassName);
            }
            resourceMap.put(JobRepository.classKeyName(fqClassName + ".class"), IOUtil.compress(classBytes));
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Failed to read from CLASS bytes for resource with id " + id, ex);
        }
    }

    private void handleJar(String id, byte[] jarBytes, Map<String, byte[]> resourceMap) {
        try (ByteArrayInputStream stream = new ByteArrayInputStream(jarBytes);){
            this.handleJar(id, stream, resourceMap);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to read from JAR bytes for resource with id " + id, e);
        }
    }

    private static void initializeClassLoader(String nsName, MapResourceClassLoader classLoader) {
        NamespaceAwareDriverManagerInterface.initializeJdbcDrivers(nsName, classLoader);
    }

    private static void cleanUpClassLoader(String nsName, MapResourceClassLoader removedClassLoader) {
        NamespaceAwareDriverManagerInterface.cleanupJdbcDrivers(nsName, removedClassLoader);
    }

    MapResourceClassLoader getClassLoaderForExactNamespace(@Nonnull String namespace) {
        return (MapResourceClassLoader)this.namespaceToClassLoader.get(namespace);
    }

    @Override
    public Map<String, LocalUserCodeNamespaceStats> getStats() {
        return this.statsMap;
    }

    @Override
    public void provideDynamicMetrics(MetricDescriptor descriptor, MetricsCollectionContext context) {
        MetricDescriptor nsDescriptor = descriptor.copy().withPrefix("ucn");
        MetricDescriptor resourceDescriptor = descriptor.copy().withPrefix("ucn.resource");
        Map<String, LocalUserCodeNamespaceStats> stats = this.getStats();
        for (Map.Entry<String, LocalUserCodeNamespaceStats> entry : stats.entrySet()) {
            String nsName = entry.getKey();
            LocalUserCodeNamespaceStats localInstanceStats = entry.getValue();
            MetricDescriptor namespace = nsDescriptor.copy().withDiscriminator("name", nsName);
            context.collect(namespace, localInstanceStats);
            Map<String, LocalUserCodeNamespaceResourceStats> resourceStats = localInstanceStats.getResources();
            for (Map.Entry<String, LocalUserCodeNamespaceResourceStats> resourceEntry : resourceStats.entrySet()) {
                MetricDescriptor resource = resourceDescriptor.copy().withDiscriminator("name", nsName).withTag("resourceId", resourceEntry.getKey());
                context.collect(resource, resourceEntry.getValue());
            }
        }
    }

    @Override
    public void reset() {
        this.statsMap.clear();
        this.namespaceToClassLoader.keySet().forEach(this::cleanupNamespace);
        this.namespaceToClassLoader.clear();
    }

    @Override
    public void shutdown(boolean terminate) {
        this.reset();
    }
}

