/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.namespace.impl;

import com.hazelcast.client.impl.protocol.task.dynamicconfig.ResourceDefinitionHolder;
import com.hazelcast.internal.config.ConfigDataSerializerHook;
import com.hazelcast.internal.namespace.ResourceDefinition;
import com.hazelcast.jet.config.ResourceConfig;
import com.hazelcast.jet.config.ResourceType;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;

public class ResourceDefinitionImpl
implements ResourceDefinition {
    private String id;
    private byte[] payload;
    private ResourceType type;
    private String url;

    public ResourceDefinitionImpl() {
    }

    public ResourceDefinitionImpl(String id, byte[] payload, ResourceType type, String url) {
        this.id = id;
        this.payload = payload;
        this.type = type;
        this.url = url;
    }

    public ResourceDefinitionImpl(ResourceConfig resourceConfig) {
        this.id = resourceConfig.getId();
        this.payload = this.readPayloadFromUrl(this.id, resourceConfig.getUrl());
        this.type = resourceConfig.getResourceType();
        this.url = resourceConfig.getUrl().toString();
    }

    public ResourceDefinitionImpl(ResourceDefinitionHolder holder) {
        this.id = holder.getId();
        this.payload = holder.getPayload();
        this.type = ResourceType.getById(holder.getResourceType());
        this.url = holder.getResourceUrl();
        if (this.payload == null) {
            if (this.url == null) {
                throw new IllegalStateException("URL is not defined while payload is null for resource id " + this.id);
            }
            try {
                this.payload = this.readPayloadFromUrl(this.id, new URI(this.url).toURL());
            }
            catch (MalformedURLException | URISyntaxException ex) {
                throw new IllegalArgumentException("Encountered invalid URL for resource id " + this.id + " and URL " + this.url, ex);
            }
        }
    }

    private byte[] readPayloadFromUrl(String id, URL url) {
        byte[] byArray;
        block8: {
            InputStream is = url.openStream();
            try {
                byArray = is.readAllBytes();
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Could not open stream for resource id " + id + " and URL " + String.valueOf(url), e);
                }
            }
            is.close();
        }
        return byArray;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public ResourceType type() {
        return this.type;
    }

    @Override
    public byte[] payload() {
        return this.payload;
    }

    @Override
    @Nullable
    public String url() {
        return this.url;
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public int getFactoryId() {
        return ConfigDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 71;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.id);
        out.writeByteArray(this.payload);
        out.writeInt(this.type.getId());
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.id = in.readString();
        this.payload = in.readByteArray();
        this.type = ResourceType.getById(in.readInt());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceDefinitionImpl that = (ResourceDefinitionImpl)o;
        return Objects.equals(this.id, that.id) && Arrays.equals(this.payload, that.payload) && this.type == that.type && Objects.equals(this.url, that.url);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.id, this.type, this.url});
        result = 31 * result + Arrays.hashCode(this.payload);
        return result;
    }
}

