/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.monitor.impl.rest;

import com.hazelcast.instance.impl.EnterpriseNodeExtension;
import com.hazelcast.internal.ascii.TextCommandService;
import com.hazelcast.internal.ascii.rest.HttpCommandProcessor;
import com.hazelcast.internal.ascii.rest.HttpGetCommand;
import com.hazelcast.internal.ascii.rest.HttpGetCommandProcessor;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.monitor.impl.rest.LicenseInfoImpl;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.wan.impl.WanReplicationService;
import com.hazelcast.wan.impl.WanSyncStateResult;
import java.util.UUID;

class EnterpriseHttpGetCommandProcessor
extends HttpGetCommandProcessor {
    EnterpriseHttpGetCommandProcessor(TextCommandService textCommandService) {
        super(textCommandService);
    }

    @Override
    protected void handleLicense(HttpGetCommand command) {
        EnterpriseNodeExtension nodeExtension = (EnterpriseNodeExtension)this.textCommandService.getNode().getNodeExtension();
        LicenseInfoImpl licenseInfo = new LicenseInfoImpl(nodeExtension.getLicense());
        this.prepareResponse(command, new JsonObject().add("licenseInfo", licenseInfo.toJson()));
    }

    @Override
    protected void handleWanSyncProgress(HttpGetCommand command) {
        String uri = command.getURI();
        uri = StringUtil.stripTrailingSlash(uri);
        int lastSlash = uri.lastIndexOf(47);
        String syncUUIDAsString = uri.substring(lastSlash + 1);
        UUID syncUUID = UUID.fromString(syncUUIDAsString);
        WanReplicationService wanReplicationService = this.getNode().getNodeEngine().getWanReplicationService();
        WanSyncStateResult result = wanReplicationService.getSyncResult(syncUUID);
        if (result == null) {
            this.prepareResponse(command, EnterpriseHttpGetCommandProcessor.response(HttpCommandProcessor.ResponseType.FAIL, "message", "Sync progress with given uuid couldn't be found. This might be because several reasons. This member could be restarted after sync request issued. If more than 7 days passed or more than 100 new entries added, it could be evicted. For more detailed information please check member logs.", "syncUUID", syncUUIDAsString, "memberUUID", this.getNode().getLocalMember().getUuid().toString()));
            return;
        }
        JsonObject response = EnterpriseHttpGetCommandProcessor.response(HttpCommandProcessor.ResponseType.SUCCESS, new String[0]);
        response.add("result", result.toJson());
        this.prepareResponse(command, response);
    }
}

