/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.monitor.impl.jmx;

import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.jmx.HazelcastMBean;
import com.hazelcast.internal.jmx.ManagedAnnotation;
import com.hazelcast.internal.jmx.ManagedDescription;
import com.hazelcast.internal.jmx.ManagementService;
import com.hazelcast.internal.monitor.LicenseInfo;
import com.hazelcast.internal.util.MapUtil;
import java.util.List;
import java.util.Map;

@ManagedDescription(value="HazelcastInstance.LicenseInfo")
public class LicenseInfoMBean
extends HazelcastMBean<LicenseInfo> {
    public LicenseInfoMBean(LicenseInfo licenseInfo, Node node, ManagementService service) {
        super(licenseInfo, service);
        Map<String, String> properties = MapUtil.createHashMap(3);
        properties.put("type", ManagementService.quote("HazelcastInstance.LicenseInfo"));
        properties.put("name", ManagementService.quote("node" + String.valueOf(node.address)));
        properties.put("instance", ManagementService.quote(node.nodeEngine.getHazelcastInstance().getName()));
        this.setObjectName(properties);
    }

    @ManagedAnnotation(value="maxNodeCountAllowed")
    @ManagedDescription(value="Maximum nodes allowed to form a cluster under the current license")
    public String getMaxNodeCountAllowed() {
        return String.valueOf(((LicenseInfo)this.managedObject).getMaxNodeCountAllowed());
    }

    @ManagedAnnotation(value="allowedTieredStoreSize")
    @ManagedDescription(value="Maximum allowed tiered storage size")
    public int getAllowedTieredStoreSize() {
        return ((LicenseInfo)this.managedObject).getAllowedTieredStoreSize();
    }

    @ManagedAnnotation(value="allowedNativeMemorySize")
    @ManagedDescription(value="Maximum allowed native memory size")
    public int getAllowedNativeMemorySize() {
        return ((LicenseInfo)this.managedObject).getAllowedNativeMemorySize();
    }

    @ManagedAnnotation(value="allowedTpcCores")
    @ManagedDescription(value="Maximum allowed TPC cores")
    public int getAllowedTpcCores() {
        return ((LicenseInfo)this.managedObject).getAllowedTpcCores();
    }

    @ManagedAnnotation(value="expiryDate")
    @ManagedDescription(value="The expiry date of the current license")
    public String getExpiryDate() {
        return String.valueOf(((LicenseInfo)this.managedObject).getExpirationTime());
    }

    @ManagedAnnotation(value="keyHash")
    @ManagedDescription(value="SHA-256 hash of license key of the current license as a Base64 encoded string")
    public String getKeyHash() {
        return ((LicenseInfo)this.managedObject).getKeyHash();
    }

    @ManagedAnnotation(value="features")
    @ManagedDescription(value="Licensed features of the current license")
    public List<String> getFeatures() {
        return ((LicenseInfo)this.managedObject).getFeatures();
    }
}

