/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.memory.impl;

import com.hazelcast.internal.memory.impl.LibMalloc;
import com.hazelcast.internal.memory.impl.UnsafeUtil;

public final class UnsafeMalloc
implements LibMalloc {
    @Override
    public long malloc(long size) {
        if (size == 0L) {
            return 0L;
        }
        try {
            return UnsafeUtil.UNSAFE.allocateMemory(size);
        }
        catch (OutOfMemoryError e) {
            return 0L;
        }
    }

    @Override
    public long realloc(long address, long size) {
        if (size == 0L) {
            UnsafeUtil.UNSAFE.freeMemory(address);
            return 0L;
        }
        try {
            return UnsafeUtil.UNSAFE.reallocateMemory(address, size);
        }
        catch (OutOfMemoryError e) {
            return 0L;
        }
    }

    @Override
    public void free(long address) {
        UnsafeUtil.UNSAFE.freeMemory(address);
    }

    public String toString() {
        return "UnsafeMalloc";
    }

    @Override
    public void dispose() {
    }
}

