/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.memory.impl;

import com.hazelcast.config.NativeMemoryConfig;
import com.hazelcast.config.PersistentMemoryConfig;
import com.hazelcast.config.PersistentMemoryMode;
import com.hazelcast.internal.memory.impl.LibMalloc;
import com.hazelcast.internal.memory.impl.LibMallocFactory;
import com.hazelcast.internal.memory.impl.MemkindMalloc;
import com.hazelcast.internal.memory.impl.MemkindPmemMalloc;
import com.hazelcast.internal.memory.impl.MemkindUtil;

public final class MemkindMallocFactory
implements LibMallocFactory {
    private final NativeMemoryConfig config;

    public MemkindMallocFactory(NativeMemoryConfig config) {
        this.config = config;
    }

    @Override
    public LibMalloc create(long size) {
        PersistentMemoryConfig pmemConfig = this.config.getPersistentMemoryConfig();
        if (PersistentMemoryMode.MOUNTED == pmemConfig.getMode() && !MemkindUtil.useMemkind()) {
            return MemkindPmemMalloc.create(this.config, size);
        }
        return MemkindMalloc.create(this.config, size);
    }
}

