/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.memory;

import com.hazelcast.internal.memory.FreeMemoryChecker;
import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.memory.HazelcastMemoryManager;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.memory.MemoryStats;
import com.hazelcast.internal.memory.NativeMemoryStats;
import com.hazelcast.internal.memory.impl.LibMalloc;
import com.hazelcast.internal.memory.impl.LibMallocFactory;
import com.hazelcast.internal.memory.impl.UnsafeMallocFactory;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.metrics.StaticMetricsProvider;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.collection.Long2LongHashMap;
import com.hazelcast.internal.util.collection.Long2ObjectHashMap;
import com.hazelcast.internal.util.counters.Counter;
import com.hazelcast.internal.util.counters.MwCounter;
import com.hazelcast.internal.util.function.LongLongConsumer;
import com.hazelcast.jet.impl.util.ReflectionUtils;
import com.hazelcast.memory.Capacity;
import com.hazelcast.memory.NativeOutOfMemoryError;

public final class StandardMemoryManager
implements HazelcastMemoryManager,
StaticMetricsProvider {
    public static final String PROPERTY_DEBUG_ENABLED = "hazelcast.memory.manager.debug.enabled";
    public static final String PROPERTY_DEBUG_STACKTRACE_ENABLED = "hazelcast.memory.manager.debug.stacktrace.enabled";
    private static final int STACK_TRACE_OFFSET = 3;
    private static final FreeMemoryChecker DEFAULT_FREE_MEMORY_CHECKER = new FreeMemoryChecker();
    private static final LibMallocFactory DEFAULT_LIB_MALLOC_FACTORY = new UnsafeMallocFactory(DEFAULT_FREE_MEMORY_CHECKER);
    private final Counter sequenceGenerator = MwCounter.newMwCounter();
    private final boolean isDebugStackTraceEnabled = Boolean.getBoolean("hazelcast.memory.manager.debug.stacktrace.enabled");
    private final boolean isDebugEnabled = this.isDebugStackTraceEnabled || Boolean.getBoolean("hazelcast.memory.manager.debug.enabled");
    private final LibMalloc malloc;
    private final NativeMemoryStats memoryStats;
    private final Long2LongHashMap allocatedBlocks;
    private final Long2ObjectHashMap<String> allocatedStackTraces;

    public StandardMemoryManager(Capacity cap) {
        this(cap, DEFAULT_LIB_MALLOC_FACTORY);
    }

    public StandardMemoryManager(Capacity cap, LibMallocFactory libMallocFactory) {
        long size = cap.bytes();
        this.malloc = libMallocFactory.create(size);
        this.memoryStats = new NativeMemoryStats(size);
        this.allocatedBlocks = this.initAllocatedBlocks();
        this.allocatedStackTraces = this.initAllocatedStacktraces();
    }

    StandardMemoryManager(LibMalloc malloc, NativeMemoryStats memoryStats) {
        this.malloc = malloc;
        this.memoryStats = memoryStats;
        this.allocatedBlocks = this.initAllocatedBlocks();
        this.allocatedStackTraces = this.initAllocatedStacktraces();
    }

    private Long2LongHashMap initAllocatedBlocks() {
        if (this.isDebugEnabled) {
            return new Long2LongHashMap(0L);
        }
        return null;
    }

    private Long2ObjectHashMap<String> initAllocatedStacktraces() {
        if (this.isDebugStackTraceEnabled) {
            return new Long2ObjectHashMap<String>();
        }
        return null;
    }

    @Override
    public MemoryStats getMemoryStats() {
        return this.memoryStats;
    }

    @Override
    public long allocate(long size) {
        assert (size > 0L) : "Size must be positive: " + size;
        this.memoryStats.getMemoryAdjuster().adjustDataMemory(size);
        try {
            long address = this.malloc.malloc(size);
            StandardMemoryManager.checkNotNull(address, size);
            if (this.isDebugEnabled) {
                this.traceAllocation(address, size);
            }
            GlobalMemoryAccessorRegistry.AMEM.setMemory(address, size, (byte)0);
            return address;
        }
        catch (Throwable t) {
            this.memoryStats.removeCommittedNative(size);
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    public long reallocate(long address, long currentSize, long newSize) {
        assert (currentSize > 0L) : "Current size must be positive: " + currentSize;
        assert (newSize > 0L) : "New size must be positive: " + newSize;
        long diff = newSize - currentSize;
        if (diff > 0L) {
            this.memoryStats.getMemoryAdjuster().adjustDataMemory(diff);
        }
        try {
            long newAddress = this.malloc.realloc(address, newSize);
            StandardMemoryManager.checkNotNull(newAddress, newSize);
            if (this.isDebugEnabled) {
                this.traceRelease(address, currentSize);
                this.traceAllocation(newAddress, newSize);
            }
            if (diff > 0L) {
                long startAddress = newAddress + currentSize;
                GlobalMemoryAccessorRegistry.AMEM.setMemory(startAddress, diff, (byte)0);
            }
            return newAddress;
        }
        catch (Throwable t) {
            if (diff > 0L) {
                this.memoryStats.removeCommittedNative(diff);
            }
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    public void free(long address, long size) {
        assert (address != 0L) : "Invalid address: " + address + ", size: " + size;
        assert (size > 0L) : "Invalid memory size: " + size + ", address: " + address;
        if (this.isDebugEnabled) {
            this.traceRelease(address, size);
        }
        this.malloc.free(address);
        this.memoryStats.removeCommittedNative(size);
    }

    @Override
    public void compact() {
    }

    @Override
    public MemoryAllocator getSystemAllocator() {
        return this;
    }

    @Override
    public MemoryAllocator getTieredStoreAllocator() {
        return this;
    }

    @Override
    public boolean isDisposed() {
        return false;
    }

    @Override
    public void dispose() {
        if (this.isDebugEnabled) {
            this.allocatedBlocks.clear();
        }
        this.malloc.dispose();
    }

    @Override
    public long getUsableSize(long address) {
        return -1L;
    }

    @Override
    public long validateAndGetUsableSize(long address) {
        return -1L;
    }

    @Override
    public long getAllocatedSize(long address) {
        return -1L;
    }

    @Override
    public long validateAndGetAllocatedSize(long address) {
        return -1L;
    }

    @Override
    public long newSequence() {
        return this.sequenceGenerator.inc();
    }

    @Override
    public void provideStaticMetrics(MetricsRegistry registry) {
        registry.registerStaticMetrics(this.memoryStats, "memorymanager.stats");
    }

    public synchronized void forEachAllocatedBlock(LongLongConsumer consumer) {
        if (!this.isDebugEnabled) {
            throw new UnsupportedOperationException("Allocated blocks are tracked only in DEBUG mode!");
        }
        this.allocatedBlocks.longForEach(consumer);
    }

    public synchronized Long2ObjectHashMap<String> getAllocatedStackTraces() {
        if (!this.isDebugStackTraceEnabled) {
            throw new UnsupportedOperationException("Allocated blocks are tracked only in DEBUG_STACKTRACE mode!");
        }
        return this.allocatedStackTraces;
    }

    private synchronized void traceAllocation(long address, long size) {
        long current = this.allocatedBlocks.put(address, size);
        if (current != 0L) {
            throw new AssertionError((Object)("Already allocated! " + address));
        }
        if (this.isDebugStackTraceEnabled) {
            this.allocatedStackTraces.put(address, ReflectionUtils.getStackTrace(Thread.currentThread(), 3));
        }
    }

    private synchronized void traceRelease(long address, long size) {
        long current = this.allocatedBlocks.remove(address);
        if (current != size) {
            if (current == 0L) {
                throw new AssertionError((Object)("Either not allocated or duplicate free()! Address: " + address + ", Size: " + size));
            }
            throw new AssertionError((Object)("Invalid size! Address: " + address + ", Expected: " + current + ", Actual: " + size));
        }
        if (this.isDebugStackTraceEnabled) {
            this.allocatedStackTraces.remove(address);
        }
    }

    protected static void checkNotNull(long address, long size) {
        if (address == 0L) {
            throw new NativeOutOfMemoryError("Not enough contiguous memory available! Cannot acquire " + Capacity.toPrettyString(size) + "!");
        }
    }
}

