/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.memory;

import com.hazelcast.internal.memory.AbstractPoolingMemoryManager;
import com.hazelcast.internal.memory.FreeMemoryChecker;
import com.hazelcast.internal.memory.GarbageCollectable;
import com.hazelcast.internal.memory.GlobalIndexPoolingAllocator;
import com.hazelcast.internal.memory.GlobalPoolingMemoryManager;
import com.hazelcast.internal.memory.HazelcastMemoryManager;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.memory.MemoryStats;
import com.hazelcast.internal.memory.PooledNativeMemoryStats;
import com.hazelcast.internal.memory.SimpleGarbageCollector;
import com.hazelcast.internal.memory.ThreadLocalPoolingMemoryManager;
import com.hazelcast.internal.memory.impl.LibMalloc;
import com.hazelcast.internal.memory.impl.LibMallocFactory;
import com.hazelcast.internal.memory.impl.UnsafeMallocFactory;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.metrics.StaticMetricsProvider;
import com.hazelcast.internal.util.QuickMath;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.memory.Capacity;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class PoolingMemoryManager
implements HazelcastMemoryManager,
GarbageCollectable,
StaticMetricsProvider {
    static final int MIN_MIN_BLOCK_SIZE = 8;
    static final int MAX_PAGE_SIZE = 0x40000000;
    private static final int PERCENTAGE_FACTOR = 100;
    private static final FreeMemoryChecker DEFAULT_FREE_MEMORY_CHECKER = new FreeMemoryChecker();
    private static final LibMallocFactory DEFAULT_LIB_MALLOC_FACTORY = new UnsafeMallocFactory(DEFAULT_FREE_MEMORY_CHECKER);
    private final LibMalloc malloc;
    private final PooledNativeMemoryStats memoryStats;
    private final GlobalPoolingMemoryManager globalMemoryManager;
    private final GlobalIndexPoolingAllocator globalIndexAllocator;
    private final Map<Thread, HazelcastMemoryManager> threadLocalManagers = new ConcurrentHashMap<Thread, HazelcastMemoryManager>(32, 0.75f, 1);
    private final SimpleGarbageCollector gc;

    public PoolingMemoryManager(Capacity cap, String hzName) {
        this(cap, 16, 0x400000, 12.5f, 8192, DEFAULT_LIB_MALLOC_FACTORY, hzName);
    }

    public PoolingMemoryManager(Capacity size, int minBlockSize, int pageSize, float metadataSpacePercentage, String hzName) {
        this(size, minBlockSize, pageSize, metadataSpacePercentage, 8192, DEFAULT_LIB_MALLOC_FACTORY, hzName);
    }

    public PoolingMemoryManager(Capacity size, int minBlockSize, int pageSize, LibMallocFactory libMallocFactory, String hzName) {
        this(size, minBlockSize, pageSize, 12.5f, 8192, libMallocFactory, hzName);
    }

    public PoolingMemoryManager(Capacity cap, int minBlockSize, int pageSize, float metadataSpacePercentage, LibMallocFactory libMallocFactory, String hzName) {
        this(cap, minBlockSize, pageSize, metadataSpacePercentage, 8192, libMallocFactory, hzName);
    }

    public PoolingMemoryManager(Capacity cap, int minBlockSize, int pageSize, float metadataSpacePercentage, int indexNodeSize, LibMallocFactory libMallocFactory, String hzName) {
        Objects.requireNonNull(hzName, "hzName cannot be null");
        long totalSize = cap.bytes();
        if (totalSize <= 0L) {
            throw new IllegalArgumentException("Capacity must be positive!");
        }
        PoolingMemoryManager.checkBlockAndPageSize(minBlockSize, pageSize);
        long maxMetadata = (long)((float)totalSize * metadataSpacePercentage / 100.0f);
        long maxNative = QuickMath.normalize(totalSize, pageSize);
        this.malloc = libMallocFactory.create(totalSize);
        this.gc = new SimpleGarbageCollector(ThreadUtil.createThreadName(hzName, "memory.manager.gc.thread"));
        this.memoryStats = new PooledNativeMemoryStats(maxNative, maxMetadata, pageSize);
        this.globalMemoryManager = new GlobalPoolingMemoryManager(minBlockSize, pageSize, this.malloc, this.memoryStats, this.gc);
        this.globalIndexAllocator = new GlobalIndexPoolingAllocator(this.malloc, this.memoryStats, indexNodeSize);
        this.gc.registerGarbageCollectable(this);
        this.gc.start();
    }

    static void checkBlockAndPageSize(int minBlockSize, int pageSize) {
        if (!QuickMath.isPowerOfTwo(minBlockSize)) {
            throw new IllegalArgumentException("Minimum block size must be power of two, got " + minBlockSize);
        }
        if (minBlockSize < 8) {
            throw new IllegalArgumentException("Minimum block size must be greater than or equal to 8, got " + minBlockSize);
        }
        if (!QuickMath.isPowerOfTwo(pageSize)) {
            throw new IllegalArgumentException("Page size must be power of two, got " + pageSize);
        }
        if (pageSize < minBlockSize) {
            throw new IllegalArgumentException("Page size must be bigger than minimum block size of " + minBlockSize + ", got " + pageSize);
        }
        if (pageSize > 0x40000000) {
            throw new IllegalArgumentException("Page size must be smaller than or equal to 1073741824, got " + pageSize);
        }
    }

    @Override
    public long allocate(long size) {
        HazelcastMemoryManager manager = this.getMemoryManager();
        return manager.allocate(size);
    }

    @Override
    public long reallocate(long address, long currentSize, long newSize) {
        HazelcastMemoryManager manager = this.getMemoryManager();
        return manager.reallocate(address, currentSize, newSize);
    }

    @Override
    public void free(long address, long size) {
        HazelcastMemoryManager manager = this.getMemoryManager();
        manager.free(address, size);
    }

    @Override
    public void compact() {
        HazelcastMemoryManager manager = this.getMemoryManager();
        manager.compact();
    }

    @Override
    public long getUsableSize(long address) {
        HazelcastMemoryManager manager = this.getMemoryManager();
        return manager.getUsableSize(address);
    }

    @Override
    public long validateAndGetUsableSize(long address) {
        HazelcastMemoryManager manager = this.getMemoryManager();
        return manager.validateAndGetUsableSize(address);
    }

    @Override
    public long getAllocatedSize(long address) {
        HazelcastMemoryManager manager = this.getMemoryManager();
        return manager.getAllocatedSize(address);
    }

    @Override
    public long validateAndGetAllocatedSize(long address) {
        HazelcastMemoryManager manager = this.getMemoryManager();
        return manager.validateAndGetAllocatedSize(address);
    }

    @Override
    public long newSequence() {
        HazelcastMemoryManager manager = this.getMemoryManager();
        return manager.newSequence();
    }

    public int getHeaderSize() {
        AbstractPoolingMemoryManager manager = (AbstractPoolingMemoryManager)this.getMemoryManager();
        return manager.headerSize();
    }

    public GlobalPoolingMemoryManager getGlobalMemoryManager() {
        return this.globalMemoryManager;
    }

    public GlobalIndexPoolingAllocator getGlobalIndexAllocator() {
        return this.globalIndexAllocator;
    }

    public HazelcastMemoryManager getMemoryManager() {
        Thread current = Thread.currentThread();
        HazelcastMemoryManager pool = this.threadLocalManagers.get(current);
        if (pool == null) {
            pool = this.globalMemoryManager;
        }
        return pool;
    }

    public LibMalloc getLibMalloc() {
        return this.malloc;
    }

    @Override
    public void dispose() {
        this.gc.abort();
        Collection<HazelcastMemoryManager> managers = this.threadLocalManagers.values();
        if (!managers.isEmpty()) {
            Iterator<HazelcastMemoryManager> iterator = managers.iterator();
            while (iterator.hasNext()) {
                HazelcastMemoryManager pool = iterator.next();
                iterator.remove();
                PoolingMemoryManager.destroyPool(pool);
            }
        }
        this.threadLocalManagers.clear();
        PoolingMemoryManager.destroyPool(this.globalMemoryManager);
        PoolingMemoryManager.destroyPool(this.globalIndexAllocator);
        this.malloc.dispose();
        this.memoryStats.resetUsedNativeMemory();
    }

    @Override
    public boolean isDisposed() {
        HazelcastMemoryManager manager = this.getMemoryManager();
        return manager == null || manager.isDisposed();
    }

    private static void destroyPool(MemoryAllocator pool) {
        try {
            pool.dispose();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void registerThread(Thread thread) {
        if (this.threadLocalManagers.containsKey(thread)) {
            throw new IllegalArgumentException();
        }
        this.gc();
        this.threadLocalManagers.put(thread, this.newThreadLocalPoolingMemoryManager(this.globalMemoryManager.minBlockSize, this.globalMemoryManager.pageSize, this.malloc, this.memoryStats));
    }

    protected ThreadLocalPoolingMemoryManager newThreadLocalPoolingMemoryManager(int minBlockSize, int pageSize, LibMalloc malloc, PooledNativeMemoryStats stats) {
        return new ThreadLocalPoolingMemoryManager(minBlockSize, pageSize, malloc, stats);
    }

    public void deregisterThread(Thread thread) {
        HazelcastMemoryManager pool = this.threadLocalManagers.remove(thread);
        if (pool != null) {
            PoolingMemoryManager.destroyPool(pool);
        }
        this.gc();
    }

    @Override
    public final void gc() {
        if (!this.threadLocalManagers.isEmpty()) {
            Iterator<Map.Entry<Thread, HazelcastMemoryManager>> iter = this.threadLocalManagers.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<Thread, HazelcastMemoryManager> next = iter.next();
                Thread t = next.getKey();
                if (t.isAlive()) continue;
                iter.remove();
                HazelcastMemoryManager pool = next.getValue();
                PoolingMemoryManager.destroyPool(pool);
            }
        }
    }

    @Override
    public MemoryAllocator getSystemAllocator() {
        return this.globalMemoryManager.getSystemAllocator();
    }

    @Override
    public MemoryAllocator getTieredStoreAllocator() {
        return this.globalMemoryManager.getTieredStoreAllocator();
    }

    @Override
    public MemoryStats getMemoryStats() {
        return this.memoryStats;
    }

    public String toString() {
        return "PoolingMemoryManager{globalMemoryManager=" + String.valueOf(this.globalMemoryManager) + ", globalIndexMemoryAllocator=" + String.valueOf(this.globalIndexAllocator) + "}";
    }

    @Override
    public void provideStaticMetrics(MetricsRegistry registry) {
        registry.registerStaticMetrics(this.memoryStats, "memorymanager.stats");
    }
}

