/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.memory;

import com.hazelcast.internal.elastic.queue.LongLinkedBlockingQueue;
import com.hazelcast.internal.elastic.queue.LongQueue;
import com.hazelcast.internal.memory.AbstractPoolingMemoryManager;
import com.hazelcast.internal.memory.AddressQueue;
import com.hazelcast.internal.memory.DestroyedAddressQueue;
import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.memory.IndexAllocator;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.memory.PooledNativeMemoryStats;
import com.hazelcast.internal.memory.StandardMemoryManager;
import com.hazelcast.internal.memory.impl.LibMalloc;
import com.hazelcast.internal.util.QuickMath;
import com.hazelcast.memory.Capacity;
import com.hazelcast.memory.NativeOutOfMemoryError;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class GlobalIndexPoolingAllocator
implements IndexAllocator {
    public static final int DEFAULT_BTREE_INDEX_NODE_SIZE = 8192;
    protected final AbstractPoolingMemoryManager.MetadataMemoryAllocator systemAllocator;
    private final int nodeSize;
    private final PooledNativeMemoryStats memoryStats;
    private volatile AddressQueue addressQueue;
    private final MemoryAllocator nodeAllocator;
    private final AtomicBoolean destroyed = new AtomicBoolean();

    public GlobalIndexPoolingAllocator(LibMalloc malloc, PooledNativeMemoryStats memoryStats, int nodeSize) {
        this.nodeSize = nodeSize;
        this.memoryStats = memoryStats;
        if (!QuickMath.isPowerOfTwo(nodeSize)) {
            throw new IllegalArgumentException("Node size must be power of two, got " + nodeSize);
        }
        this.nodeAllocator = this.createNodeAllocator(malloc);
        this.systemAllocator = new AbstractPoolingMemoryManager.MetadataMemoryAllocator(malloc, memoryStats);
        this.addressQueue = new GlobalIndexAddressQueue(nodeSize);
    }

    protected MemoryAllocator createNodeAllocator(LibMalloc malloc) {
        return new StandardMemoryManager(malloc, this.memoryStats);
    }

    @Override
    public int getNodeSize() {
        return this.nodeSize;
    }

    @Override
    public long allocate(long size) {
        this.checkSize(size);
        long address = this.addressQueue.acquire();
        if (address == 0L) {
            try {
                address = this.nodeAllocator.allocate(this.nodeSize);
            }
            catch (NativeOutOfMemoryError e) {
                this.onOome(e);
                throw e;
            }
            this.zeroOutHeader(address);
            this.onMallocPage(address);
        }
        this.memoryStats.addUsedNativeMemory(size);
        return address;
    }

    protected void zeroOutHeader(long address) {
        AbstractPoolingMemoryManager.assertValidAddress(address);
        GlobalMemoryAccessorRegistry.AMEM.setMemory(address, 16L, (byte)0);
    }

    protected void onMallocPage(long pageAddress) {
        AbstractPoolingMemoryManager.assertValidAddress(pageAddress);
    }

    @Override
    public long reallocate(long address, long currentSize, long newSize) {
        AbstractPoolingMemoryManager.assertValidAddress(address);
        assert (currentSize == newSize);
        return address;
    }

    @Override
    public void free(long address, long size) {
        AbstractPoolingMemoryManager.assertValidAddress(address);
        this.checkSize(size);
        this.addressQueue.release(address);
        this.memoryStats.removeUsedNativeMemory(size);
    }

    private void onOome(NativeOutOfMemoryError e) {
    }

    @Override
    public void dispose() {
        long address;
        if (!this.destroyed.compareAndSet(false, true)) {
            return;
        }
        while ((address = this.addressQueue.acquire()) != 0L) {
            this.nodeAllocator.free(address, this.nodeSize);
        }
        this.addressQueue.destroy();
        this.addressQueue = DestroyedAddressQueue.INSTANCE;
    }

    private void checkSize(long size) {
        if (size != (long)this.nodeSize) {
            throw new IllegalArgumentException("Size " + size + " must be equal to " + this.nodeSize);
        }
    }

    @Override
    public List<Long> getNodeAddressesFromFreeQueue() {
        long address;
        ArrayList<Long> nodes = new ArrayList<Long>();
        while ((address = this.addressQueue.acquire()) != 0L) {
            nodes.add(address);
        }
        return nodes;
    }

    public String toString() {
        return "GlobalIndexPoolingAllocator";
    }

    private final class GlobalIndexAddressQueue
    implements AddressQueue {
        private final int memorySize;
        private final LongQueue queue;

        private GlobalIndexAddressQueue(int memorySize) {
            this.memorySize = memorySize;
            this.queue = this.createQueue();
        }

        private LongLinkedBlockingQueue createQueue() {
            return new LongLinkedBlockingQueue(GlobalIndexPoolingAllocator.this.systemAllocator, 0L);
        }

        @Override
        public boolean beforeCompaction() {
            return false;
        }

        @Override
        public void afterCompaction() {
        }

        @Override
        public long acquire() {
            return this.queue.poll();
        }

        @Override
        public boolean release(long address) {
            if (address == 0L) {
                throw new IllegalArgumentException("Illegal memory address: " + address);
            }
            return this.queue.offer(address);
        }

        @Override
        public int getMemorySize() {
            return this.memorySize;
        }

        @Override
        public int capacity() {
            return this.queue.capacity();
        }

        @Override
        public int remaining() {
            return this.queue.size();
        }

        @Override
        public void destroy() {
            this.queue.dispose();
        }

        @Override
        public int getIndex() {
            return 0;
        }

        public String toString() {
            return "GlobalIndexAddressQueue{memorySize=" + Capacity.toPrettyString(this.memorySize) + "}";
        }
    }
}

