/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.management;

import com.hazelcast.config.Config;
import com.hazelcast.config.DeviceConfig;
import com.hazelcast.config.LocalDeviceConfig;
import com.hazelcast.internal.dynamicconfig.ConfigurationService;
import com.hazelcast.internal.management.EnterpriseManagementDataSerializerHook;
import com.hazelcast.internal.management.operation.AbstractManagementOperation;
import com.hazelcast.internal.tstore.service.TieredStoreService;
import com.hazelcast.memory.Capacity;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class IncreaseDeviceCapacityOperation
extends AbstractManagementOperation {
    private Map<String, Capacity> newDeviceCapacityMap;

    public IncreaseDeviceCapacityOperation() {
    }

    public IncreaseDeviceCapacityOperation(Map<String, Capacity> newDeviceCapacityMap) {
        this.newDeviceCapacityMap = newDeviceCapacityMap;
    }

    @Override
    public void run() throws Exception {
        Config config = this.getNodeEngine().getNode().getConfig();
        Map<String, DeviceConfig> deviceConfigs = config.getDeviceConfigs();
        for (Map.Entry<String, Capacity> entry : this.newDeviceCapacityMap.entrySet()) {
            String deviceName = entry.getKey();
            Capacity newCapacity = entry.getValue();
            if (!deviceConfigs.containsKey(deviceName)) continue;
            LocalDeviceConfig localDeviceConfig = (LocalDeviceConfig)deviceConfigs.get(deviceName);
            localDeviceConfig.setCapacity(newCapacity);
            TieredStoreService tsService = (TieredStoreService)this.getNodeEngine().getService("hz:ee:tieredStoreServiceImpl");
            tsService.increaseDeviceCapacity(deviceName, newCapacity);
            ConfigurationService configurationService = (ConfigurationService)this.getNodeEngine().getService("hz:configurationService");
            configurationService.persist(localDeviceConfig);
        }
    }

    @Override
    public int getClassId() {
        return 1;
    }

    @Override
    public int getFactoryId() {
        return EnterpriseManagementDataSerializerHook.F_ID;
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int size = in.readInt();
        this.newDeviceCapacityMap = new HashMap<String, Capacity>();
        for (int i = 0; i < size; ++i) {
            String deviceName = in.readString();
            Capacity newDeviceCapacity = (Capacity)in.readObject();
            this.newDeviceCapacityMap.put(deviceName, newDeviceCapacity);
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.newDeviceCapacityMap.size());
        for (Map.Entry<String, Capacity> entry : this.newDeviceCapacityMap.entrySet()) {
            String deviceName = entry.getKey();
            Capacity newCapacity = entry.getValue();
            out.writeString(deviceName);
            out.writeObject(newCapacity);
        }
    }
}

