/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.iteration;

import com.hazelcast.internal.iteration.IterationResult;
import com.hazelcast.internal.util.UuidUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;

public class IteratorWithCursor<T> {
    private final Iterator<T> iterator;
    private UUID prevCursorId;
    private UUID cursorId;
    private long lastAccessTime;
    private List<T> page;

    public IteratorWithCursor(Iterator<T> iterator, UUID cursorId) {
        this.iterator = iterator;
        this.cursorId = cursorId;
        this.lastAccessTime = System.currentTimeMillis();
    }

    public IterationResult<T> iterate(@Nonnull UUID cursorId, int maxCount) {
        Objects.requireNonNull(cursorId);
        if (cursorId.equals(this.prevCursorId)) {
            this.access();
            return new IterationResult<T>(this.page, this.cursorId, null);
        }
        if (!cursorId.equals(this.cursorId)) {
            throw new IllegalStateException("The cursor id " + String.valueOf(cursorId) + " is not the current cursor id nor the previous cursor id.");
        }
        ArrayList<T> currentPage = new ArrayList<T>(maxCount);
        while (currentPage.size() < maxCount && this.iterator.hasNext()) {
            currentPage.add(this.iterator.next());
        }
        UUID cursorIdToForget = this.prevCursorId;
        this.prevCursorId = this.cursorId;
        this.cursorId = UuidUtil.newUnsecureUUID();
        this.page = currentPage;
        this.access();
        return new IterationResult<T>(this.page, this.cursorId, cursorIdToForget);
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    private void access() {
        this.lastAccessTime = System.currentTimeMillis();
    }
}

