/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.iteration;

import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.jet.datamodel.Tuple2;
import com.hazelcast.map.impl.MapDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.query.impl.AbstractIndex;
import com.hazelcast.query.impl.OrderedIndexStore;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class IndexIterationPointer
implements IdentifiedDataSerializable {
    public static final IndexIterationPointer ALL = IndexIterationPointer.create(null, false, null, false, false, null);
    public static final IndexIterationPointer ALL_DESC = ALL.asDescending();
    public static final IndexIterationPointer ALL_ALT = IndexIterationPointer.create(AbstractIndex.NULL, true, null, false, false, null);
    public static final IndexIterationPointer ALL_ALT_DESC = ALL_ALT.asDescending();
    public static final IndexIterationPointer IS_NULL = IndexIterationPointer.create(AbstractIndex.NULL, true, AbstractIndex.NULL, true, false, null);
    public static final IndexIterationPointer IS_NULL_DESC = IS_NULL.asDescending();
    public static final IndexIterationPointer IS_NOT_NULL = IndexIterationPointer.create(AbstractIndex.NULL, false, null, false, false, null);
    public static final IndexIterationPointer IS_NOT_NULL_DESC = IS_NOT_NULL.asDescending();
    private static final Comparator<IndexIterationPointer> FROM_COMPARATOR = Comparator.comparing(IndexIterationPointer::getFrom, OrderedIndexStore.SPECIAL_AWARE_COMPARATOR);
    private static final Comparator<IndexIterationPointer> TO_COMPARATOR = Comparator.comparing(IndexIterationPointer::getTo, OrderedIndexStore.SPECIAL_AWARE_COMPARATOR);
    private static final Comparator<IndexIterationPointer> POINTER_COMPARATOR = FROM_COMPARATOR.thenComparing(TO_COMPARATOR);
    private static final Comparator<IndexIterationPointer> POINTER_COMPARATOR_REVERSED = POINTER_COMPARATOR.reversed();
    private static final byte FLAG_DESCENDING = 1;
    private static final byte FLAG_FROM_INCLUSIVE = 2;
    private static final byte FLAG_TO_INCLUSIVE = 4;
    private static final byte FLAG_POINT_LOOKUP = 8;
    private byte flags;
    private Comparable<?> from;
    private Comparable<?> to;
    private Data lastEntryKeyData;

    public IndexIterationPointer() {
    }

    private IndexIterationPointer(byte flags, @Nullable Comparable<?> from, @Nullable Comparable<?> to, @Nullable Data lastEntryKeyData) {
        assert (from == null || to == null || from.compareTo(to) <= 0) : "from must be <= than to";
        this.flags = flags;
        assert (from == null || to == null || from.compareTo(to) != 0 || this.isFromInclusive() && this.isToInclusive()) : "Point lookup limits must be all inclusive";
        this.from = from;
        this.to = to;
        this.lastEntryKeyData = lastEntryKeyData;
    }

    public static IndexIterationPointer create(@Nullable Comparable<?> from, boolean fromInclusive, @Nullable Comparable<?> to, boolean toInclusive, boolean descending, @Nullable Data lastEntryKey) {
        return new IndexIterationPointer((byte)((descending ? 1 : 0) | (fromInclusive ? 2 : 0) | (toInclusive ? 4 : 0) | (from == to ? 8 : 0)), from, to, lastEntryKey);
    }

    public IndexIterationPointer asDescending() {
        assert (!this.isDescending()) : "Pointer is already descending";
        return IndexIterationPointer.create(this.getFrom(), this.isFromInclusive(), this.getTo(), this.isToInclusive(), true, this.lastEntryKeyData);
    }

    boolean isAll() {
        return (this.from == null || this.from == AbstractIndex.NULL && this.isFromInclusive()) && this.to == null;
    }

    @Nullable
    public Comparable<?> getFrom() {
        return this.from;
    }

    public boolean isFromInclusive() {
        return (this.flags & 2) != 0;
    }

    @Nullable
    public Comparable<?> getTo() {
        return this.to;
    }

    public boolean isToInclusive() {
        return (this.flags & 4) != 0;
    }

    public boolean isDescending() {
        return (this.flags & 1) != 0;
    }

    public Data getLastEntryKeyData() {
        return this.lastEntryKeyData;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeByte(this.flags);
        out.writeObject(this.from);
        if ((this.flags & 8) == 0) {
            out.writeObject(this.to);
        }
        IOUtil.writeData(out, this.lastEntryKeyData);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.flags = in.readByte();
        this.from = (Comparable)in.readObject();
        this.to = (this.flags & 8) == 0 ? (Comparable<Object>)in.readObject() : this.from;
        this.lastEntryKeyData = IOUtil.readData(in);
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 156;
    }

    public String toString() {
        return "IndexIterationPointer{" + (this.isFromInclusive() ? "[" : "(") + String.valueOf(this.from) + ", " + String.valueOf(this.to) + (this.isToInclusive() ? "]" : ")") + (this.isDescending() ? " DESC" : " ASC") + ", lastEntryKeyData=" + String.valueOf(this.lastEntryKeyData) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexIterationPointer that = (IndexIterationPointer)o;
        return this.flags == that.flags && Objects.equals(this.getFrom(), that.getFrom()) && Objects.equals(this.getTo(), that.getTo()) && Objects.equals(this.getLastEntryKeyData(), that.getLastEntryKeyData());
    }

    public int hashCode() {
        return Objects.hash(this.flags, this.getFrom(), this.getTo(), this.getLastEntryKeyData());
    }

    public static boolean overlapsOrdered(IndexIterationPointer left, IndexIterationPointer right, Comparator comparator) {
        assert (left.isDescending() == right.isDescending()) : "Cannot compare pointer with different directions";
        assert (left.lastEntryKeyData == null && right.lastEntryKeyData == null) : "Can merge only initial pointers";
        if (left == right) {
            return true;
        }
        assert (comparator.compare(left.from, right.from) <= 0) : "Pointers must be ordered";
        if (left.to == null || right.from == null) {
            return true;
        }
        boolean eqOverlaps = left.isToInclusive() || right.isFromInclusive();
        int rfCmpLt = comparator.compare(right.from, left.to);
        return eqOverlaps ? rfCmpLt <= 0 : rfCmpLt < 0;
    }

    public static IndexIterationPointer union(IndexIterationPointer left, IndexIterationPointer right, Comparator comparator) {
        assert (left.isDescending() == right.isDescending());
        assert (left.getLastEntryKeyData() == null && right.lastEntryKeyData == null) : "Can merge only initial pointers";
        Tuple2<Comparable<?>, Boolean> newFrom = IndexIterationPointer.min(left.getFrom(), left.isFromInclusive(), right.getFrom(), right.isFromInclusive(), comparator);
        Tuple2<Comparable<?>, Boolean> newTo = IndexIterationPointer.max(left.getTo(), left.isToInclusive(), right.getTo(), right.isToInclusive(), comparator);
        return IndexIterationPointer.create(newFrom.f0(), newFrom.f1(), newTo.f0(), newTo.f1(), left.isDescending(), null);
    }

    private static Tuple2<Comparable<?>, Boolean> min(Comparable<?> left, boolean leftInclusive, Comparable<?> right, boolean rightInclusive, Comparator comparator) {
        if (left == null || right == null) {
            return Tuple2.tuple2(null, false);
        }
        int result = comparator.compare(left, right);
        if (result == 0) {
            return Tuple2.tuple2(left, leftInclusive || rightInclusive);
        }
        if (result < 0) {
            return Tuple2.tuple2(left, leftInclusive);
        }
        return Tuple2.tuple2(right, rightInclusive);
    }

    private static Tuple2<Comparable<?>, Boolean> max(Comparable<?> left, boolean leftInclusive, Comparable<?> right, boolean rightInclusive, Comparator comparator) {
        if (left == null || right == null) {
            return Tuple2.tuple2(null, false);
        }
        int result = comparator.compare(left, right);
        if (result == 0) {
            return Tuple2.tuple2(left, leftInclusive || rightInclusive);
        }
        if (result < 0) {
            return Tuple2.tuple2(right, rightInclusive);
        }
        return Tuple2.tuple2(left, leftInclusive);
    }

    @Nonnull
    public static List<IndexIterationPointer> normalizePointers(@Nonnull List<IndexIterationPointer> result, boolean descending) {
        if (result.size() <= 1) {
            return result;
        }
        assert (result.stream().allMatch(r -> r.isDescending() == descending)) : "All iteration pointers must have the same direction";
        Collections.sort(result, descending ? POINTER_COMPARATOR_REVERSED : POINTER_COMPARATOR);
        int writeIdx = 0;
        IndexIterationPointer currentMerged = result.get(0);
        for (int nextPointerIdx = 1; nextPointerIdx < result.size(); ++nextPointerIdx) {
            IndexIterationPointer next = result.get(nextPointerIdx);
            if (!descending && IndexIterationPointer.overlapsOrdered(currentMerged, next, OrderedIndexStore.SPECIAL_AWARE_COMPARATOR)) {
                currentMerged = IndexIterationPointer.union(currentMerged, next, OrderedIndexStore.SPECIAL_AWARE_COMPARATOR);
                continue;
            }
            if (descending && IndexIterationPointer.overlapsOrdered(next, currentMerged, OrderedIndexStore.SPECIAL_AWARE_COMPARATOR)) {
                currentMerged = IndexIterationPointer.union(next, currentMerged, OrderedIndexStore.SPECIAL_AWARE_COMPARATOR);
                continue;
            }
            result.set(writeIdx++, currentMerged);
            currentMerged = next;
        }
        result.set(writeIdx++, currentMerged);
        return result.subList(0, writeIdx);
    }
}

