/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl.io;

import com.hazelcast.hotrestart.HotRestartException;
import com.hazelcast.internal.hotrestart.impl.encryption.EncryptionManager;
import com.hazelcast.internal.hotrestart.impl.io.ChunkFileOut;
import com.hazelcast.internal.memory.impl.UnsafeUtil;
import com.hazelcast.internal.nio.IOUtil;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import javax.annotation.Nonnull;

public class TombFileAccessor
implements Closeable {
    private static final int SKIP_BUFFER_SIZE = 1024;
    private AccessorImpl accessorImpl;
    private long recordSeq;
    private long keyPrefix;
    private int recordSize;

    public TombFileAccessor(File tombFile, EncryptionManager encryptionMgr) {
        this.accessorImpl = encryptionMgr.isEncryptionEnabled() ? new EncryptedAccessor(tombFile, encryptionMgr) : new MemoryMappedAccessor(tombFile);
    }

    public int loadAndCopyTombstone(int pos, ChunkFileOut out) throws IOException {
        assert (this.accessorImpl != null) : "Accessor has been closed";
        return this.accessorImpl.loadAndCopyTombstone(pos, out);
    }

    public final long recordSeq() {
        return this.recordSeq;
    }

    public final long keyPrefix() {
        return this.keyPrefix;
    }

    public final int recordSize() {
        return this.recordSize;
    }

    @Override
    public final void close() {
        this.accessorImpl.close();
        this.accessorImpl = null;
    }

    private final class EncryptedAccessor
    extends MemoryMappedAccessor {
        private byte[] skipBuffer;
        private PositionAwareInputStream in;
        private DataInputStream dataIn;

        EncryptedAccessor(File tombFile, EncryptionManager encryptionMgr) {
            super(tombFile);
            this.skipBuffer = new byte[1024];
            if (this.buf != null) {
                InputStream bbis = IOUtil.newInputStream(this.buf);
                this.in = new PositionAwareInputStream(encryptionMgr.wrap(bbis, tombFile.getParent()));
                this.dataIn = new DataInputStream(this.in);
            }
        }

        @Override
        public void close() {
            super.close();
            this.in = null;
            this.dataIn = null;
        }

        @Override
        public int loadAndCopyTombstone(int pos, ChunkFileOut out) throws IOException {
            assert (this.in != null) : "Tombstone chunk is empty or accessor has been closed";
            long n = (long)pos - this.in.position();
            if (n < 0L) {
                throw new HotRestartException("Tomb position not increasing monotonically");
            }
            this.skip(this.in, n);
            TombFileAccessor.this.recordSeq = this.dataIn.readLong();
            TombFileAccessor.this.keyPrefix = this.dataIn.readLong();
            int keySize = this.dataIn.readInt();
            out.writeTombstone(TombFileAccessor.this.recordSeq, TombFileAccessor.this.keyPrefix, this.in, keySize);
            TombFileAccessor.this.recordSize = (int)this.in.position() - pos;
            return TombFileAccessor.this.recordSize;
        }

        private void skip(InputStream in, long n) throws IOException {
            long remaining;
            int read;
            if ((long)in.available() >= n) {
                long skipped = in.skip(n);
                if (skipped == n) {
                    return;
                }
                n -= skipped;
            }
            if (n == 0L) {
                return;
            }
            for (remaining = n; remaining > 0L && (read = in.read(this.skipBuffer, 0, (int)Math.min(1024L, remaining))) >= 0; remaining -= (long)read) {
            }
            if (remaining > 0L) {
                throw new HotRestartException("Partial stream skip: " + (n - remaining) + ", requested: " + n);
            }
        }
    }

    private class MemoryMappedAccessor
    implements AccessorImpl {
        MappedByteBuffer buf;

        MemoryMappedAccessor(File tombFile) {
            FileChannel chan = null;
            try {
                chan = new FileInputStream(tombFile).getChannel();
                long size = chan.size();
                this.buf = size > 0L ? chan.map(FileChannel.MapMode.READ_ONLY, 0L, size) : null;
            }
            catch (IOException e) {
                try {
                    throw new HotRestartException("Failed to create tombstone file accessor", e);
                }
                catch (Throwable throwable) {
                    IOUtil.closeResource(chan);
                    throw throwable;
                }
            }
            IOUtil.closeResource(chan);
        }

        @Override
        public int loadAndCopyTombstone(int pos, ChunkFileOut out) throws IOException {
            assert (this.buf != null) : "Tombstone chunk is empty or accessor has been closed";
            this.buf.position(pos);
            TombFileAccessor.this.recordSeq = this.buf.getLong();
            TombFileAccessor.this.keyPrefix = this.buf.getLong();
            int keySize = this.buf.getInt();
            out.writeTombstone(TombFileAccessor.this.recordSeq, TombFileAccessor.this.keyPrefix, this.buf, keySize);
            TombFileAccessor.this.recordSize = this.buf.position() - pos;
            return TombFileAccessor.this.recordSize;
        }

        @Override
        public void close() {
            if (this.buf != null) {
                UnsafeUtil.UNSAFE.invokeCleaner(this.buf);
            }
            this.buf = null;
        }
    }

    private static interface AccessorImpl {
        public void close();

        public int loadAndCopyTombstone(int var1, ChunkFileOut var2) throws IOException;
    }

    private static class PositionAwareInputStream
    extends FilterInputStream {
        private long pos;
        private long mark;

        PositionAwareInputStream(InputStream in) {
            super(in);
        }

        public long position() {
            return this.pos;
        }

        @Override
        public int read() throws IOException {
            int b = super.read();
            if (b >= 0) {
                ++this.pos;
            }
            return b;
        }

        @Override
        public int read(@Nonnull byte[] b, int off, int len) throws IOException {
            int n = super.read(b, off, len);
            if (n > 0) {
                this.pos += (long)n;
            }
            return n;
        }

        @Override
        public long skip(long skip) throws IOException {
            long n = super.skip(skip);
            if (n > 0L) {
                this.pos += n;
            }
            return n;
        }

        @Override
        public void mark(int readlimit) {
            super.mark(readlimit);
            this.mark = this.pos;
        }

        @Override
        public void reset() throws IOException {
            super.reset();
            this.pos = this.mark;
        }
    }
}

