/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl.gc.record;

import com.hazelcast.internal.hotrestart.KeyHandle;
import com.hazelcast.internal.hotrestart.KeyHandleOffHeap;
import com.hazelcast.internal.hotrestart.impl.SetOfKeyHandle;
import com.hazelcast.internal.memory.MemoryManager;
import com.hazelcast.internal.util.HashUtil;
import com.hazelcast.internal.util.hashslot.HashSlotArray16byteKey;
import com.hazelcast.internal.util.hashslot.HashSlotCursor16byteKey;
import com.hazelcast.internal.util.hashslot.impl.HashSlotArray16byteKeyNoValue;

public final class SetOfKeyHandleOffHeap
implements SetOfKeyHandle {
    private final HashSlotArray16byteKey hsa;

    public SetOfKeyHandleOffHeap(MemoryManager memMgr) {
        this.hsa = new HashSlotArray16byteKeyNoValue(0L, memMgr);
        this.hsa.gotoNew();
    }

    @Override
    public void add(KeyHandle kh) {
        KeyHandleOffHeap ohk = (KeyHandleOffHeap)kh;
        this.hsa.ensure(ohk.address(), ohk.sequenceId());
    }

    @Override
    public void remove(KeyHandle kh) {
        KeyHandleOffHeap ohk = (KeyHandleOffHeap)kh;
        this.hsa.remove(ohk.address(), ohk.sequenceId());
    }

    @Override
    public SetOfKeyHandle.KhCursor cursor() {
        return new Cursor();
    }

    @Override
    public void dispose() {
        this.hsa.dispose();
    }

    private final class Cursor
    implements SetOfKeyHandle.KhCursor,
    KeyHandleOffHeap {
        private final HashSlotCursor16byteKey c;

        private Cursor() {
            this.c = SetOfKeyHandleOffHeap.this.hsa.cursor();
        }

        @Override
        public boolean advance() {
            return this.c.advance();
        }

        @Override
        public KeyHandleOffHeap asKeyHandle() {
            return this;
        }

        @Override
        public long address() {
            return this.c.key1();
        }

        @Override
        public long sequenceId() {
            return this.c.key2();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (!(obj instanceof KeyHandleOffHeap)) return false;
            KeyHandleOffHeap that = (KeyHandleOffHeap)obj;
            if (this.address() != that.address()) return false;
            if (this.sequenceId() != that.sequenceId()) return false;
            return true;
        }

        public int hashCode() {
            return (int)HashUtil.fastLongMix(HashUtil.fastLongMix(this.address()) + this.sequenceId());
        }
    }
}

