/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl.gc.record;

import com.hazelcast.internal.hotrestart.KeyHandle;
import com.hazelcast.internal.hotrestart.impl.KeyOnHeap;
import com.hazelcast.internal.hotrestart.impl.gc.record.Record;

public class RecordOnHeap
extends Record {
    private long seq;
    private int size;
    private int additionalInt;

    public RecordOnHeap(long seq, int size, boolean isTombstone, int additionalInt) {
        this.seq = seq;
        this.size = RecordOnHeap.toRawSizeValue(size, isTombstone);
        this.additionalInt = additionalInt;
    }

    @Override
    public final long rawSeqValue() {
        return this.seq;
    }

    @Override
    public final int rawSizeValue() {
        return this.size;
    }

    @Override
    public long keyPrefix(KeyHandle kh) {
        return ((KeyOnHeap)kh).prefix();
    }

    @Override
    public final void negateSeq() {
        this.seq = -this.seq;
    }

    @Override
    public final int additionalInt() {
        return this.additionalInt;
    }

    @Override
    public final int decrementGarbageCount() {
        assert (!this.isTombstone()) : "Attempt to decrement garbage count on a tombstone";
        return --this.additionalInt;
    }

    @Override
    public final void incrementGarbageCount() {
        assert (!this.isTombstone()) : "Attempt to increment garbage count on a tombstone";
        ++this.additionalInt;
    }

    @Override
    public final void setAdditionalInt(int newCount) {
        this.additionalInt = newCount;
    }

    @Override
    public final void setRawSeqSize(long rawSeqValue, int rawSizeValue) {
        this.seq = rawSeqValue;
        this.size = rawSizeValue;
    }
}

