/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl.gc.record;

import com.hazelcast.internal.hotrestart.KeyHandle;

public abstract class Record {
    public static final int VAL_HEADER_SIZE = 24;
    public static final int TOMB_HEADER_SIZE = 20;

    public final long deadOrAliveSeq() {
        long seq = this.rawSeqValue();
        assert (seq != 0L) : "Record seq is zero";
        return Math.abs(seq);
    }

    public final long liveSeq() {
        long seq = this.rawSeqValue();
        assert (seq > 0L) : "liveSeq() called on a dead record. Raw seq is " + seq;
        return seq;
    }

    public final long deadSeq() {
        long seq = this.rawSeqValue();
        assert (seq < 0L) : "deadSeq() called on a live record. Raw seq is " + seq;
        return -seq;
    }

    public final int size() {
        return Math.abs(this.rawSizeValue());
    }

    public final int payloadSize() {
        return this.size() - 24;
    }

    public final boolean isTombstone() {
        return this.rawSizeValue() < 0;
    }

    public boolean isAlive() {
        return this.rawSeqValue() > 0L;
    }

    public final int garbageCount() {
        return this.isTombstone() ? 0 : this.additionalInt();
    }

    public final int filePosition() {
        assert (this.isTombstone()) : "Attempt to retrieve file position of a value record";
        return this.additionalInt();
    }

    public final void setFilePosition(int filePosition) {
        assert (this.isTombstone()) : "Attempt to set file position on a value record";
        this.setAdditionalInt(filePosition);
    }

    public final void update(long seq, int size) {
        this.setRawSeqSize(seq, Record.toRawSizeValue(size, this.isTombstone()));
    }

    public final void retire(boolean mayIncrementGarbageCount) {
        assert (this.isAlive()) : "Attempt to retire a dead record";
        this.negateSeq();
        if (mayIncrementGarbageCount && !this.isTombstone()) {
            this.incrementGarbageCount();
        }
    }

    public String toString() {
        return String.format("%s(%03x)", this.getClass().getSimpleName(), this.liveSeq());
    }

    public abstract long keyPrefix(KeyHandle var1);

    public abstract void setRawSeqSize(long var1, int var3);

    public abstract long rawSeqValue();

    public abstract int rawSizeValue();

    public abstract void setAdditionalInt(int var1);

    public abstract int additionalInt();

    public abstract void negateSeq();

    public abstract int decrementGarbageCount();

    public abstract void incrementGarbageCount();

    public final void setGarbageCount(int newCount) {
        assert (newCount == 0 || !this.isTombstone()) : "Attempt to set non-zero garbage count on a tombstone";
        this.setAdditionalInt(newCount);
    }

    public static int size(byte[] key, byte[] value) {
        return value != null ? 24 + key.length + value.length : 20 + key.length;
    }

    public static int toRawSizeValue(int size, boolean isTombstone) {
        return isTombstone ? -size : size;
    }

    public static long positionInUnitsOfBufsize(long filePosition) {
        return filePosition >> 16;
    }
}

