/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl.gc.mem.accessors;

import com.hazelcast.hotrestart.HotRestartException;
import com.hazelcast.internal.hotrestart.impl.gc.mem.accessors.AbstractMapper;
import com.hazelcast.internal.hotrestart.impl.gc.mem.accessors.MapperAccessor;
import java.io.FileDescriptor;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.channels.FileChannel;

public class Java20Mapper
implements MapperAccessor {
    static final Class<?> FILE_DISPATCHER_CLASS;
    private final MethodHandle map;
    private final MethodHandle unmap;
    private final MethodHandle allocationGranularity;
    private final MethodHandle fileDescriptorHandle;
    private final Object fileDispatcher;

    public Java20Mapper() throws Throwable {
        Field reflectedFd = AbstractMapper.FCI_CLASS.getDeclaredField("fd");
        reflectedFd.setAccessible(true);
        Method reflectedMap = FILE_DISPATCHER_CLASS.getDeclaredMethod("map", FileDescriptor.class, Integer.TYPE, Long.TYPE, Long.TYPE, Boolean.TYPE);
        reflectedMap.setAccessible(true);
        Method reflectedUnmap = FILE_DISPATCHER_CLASS.getDeclaredMethod("unmap", Long.TYPE, Long.TYPE);
        reflectedUnmap.setAccessible(true);
        Method reflectedAllocationGranularity = FILE_DISPATCHER_CLASS.getDeclaredMethod("allocationGranularity", new Class[0]);
        reflectedAllocationGranularity.setAccessible(true);
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        Field reflectedNd = AbstractMapper.FCI_CLASS.getDeclaredField("nd");
        reflectedNd.setAccessible(true);
        this.fileDispatcher = lookup.unreflectGetter(reflectedNd).invoke();
        this.map = lookup.unreflect(reflectedMap);
        this.unmap = lookup.unreflect(reflectedUnmap);
        this.allocationGranularity = lookup.unreflect(reflectedAllocationGranularity);
        this.fileDescriptorHandle = lookup.unreflectGetter(reflectedFd);
    }

    @Override
    public long map(FileChannel fc, long position, long length) throws Throwable {
        FileDescriptor fileDescriptor = this.fileDescriptorHandle.invoke(fc);
        return this.map.invoke(this.fileDispatcher, fileDescriptor, 1, position, length, false);
    }

    @Override
    public int unmap(FileChannel fc, long address, long length) throws Throwable {
        return this.unmap.invoke(this.fileDispatcher, address, length);
    }

    @Override
    public long allocationGranularity(FileChannel channel) {
        try {
            return this.allocationGranularity.invoke(this.fileDispatcher);
        }
        catch (Throwable t) {
            throw new HotRestartException("Failed to retrieve mmap allocation granularity", t);
        }
    }

    static {
        try {
            FILE_DISPATCHER_CLASS = Class.forName("sun.nio.ch.FileDispatcher");
        }
        catch (ClassNotFoundException e) {
            throw new HotRestartException(e);
        }
    }
}

