/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl.gc.mem;

import com.hazelcast.hotrestart.HotRestartException;
import com.hazelcast.internal.hotrestart.impl.gc.mem.accessors.Java14Mapper;
import com.hazelcast.internal.hotrestart.impl.gc.mem.accessors.Java19Mapper;
import com.hazelcast.internal.hotrestart.impl.gc.mem.accessors.Java20Mapper;
import com.hazelcast.internal.hotrestart.impl.gc.mem.accessors.MapperAccessor;
import com.hazelcast.internal.nio.Disposable;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.util.JavaVersion;
import com.hazelcast.internal.util.QuickMath;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

final class MmapSlab
implements Disposable {
    private static final MapperAccessor MAPPER;
    private final long mmapPageSize;
    private final long blockSize;
    private final int initialBlockCountLog2;
    private final BitSet blockBitmap = new BitSet();
    private final RandomAccessFile raf;
    private final List<Long> bufBases = new ArrayList<Long>();
    private final List<Integer> offsetsOfBufsFromMmmapBases = new ArrayList<Integer>();
    private final NavigableMap<Long, Integer> bufBase2BufIndex = new TreeMap<Long, Integer>();
    private int blockCount;
    private int usedBlockCount;
    private final File mappedFile;

    MmapSlab(File baseDir, long blockSize) {
        this.blockSize = blockSize;
        try {
            this.mappedFile = new File(baseDir, blockSize + ".mmap");
            this.raf = new RandomAccessFile(this.mappedFile, "rw");
        }
        catch (Exception e) {
            throw new HotRestartException("Failed to create a MmapSlab for blockSize " + blockSize, e);
        }
        try {
            this.mmapPageSize = MAPPER.allocationGranularity(this.raf.getChannel());
            long minFileSize = 2L * this.mmapPageSize;
            long initialBlockCount = QuickMath.nextPowerOfTwo(minFileSize / blockSize);
            this.initialBlockCountLog2 = QuickMath.log2(initialBlockCount);
            this.mmapExpand(initialBlockCount);
        }
        catch (HotRestartException e) {
            IOUtil.delete(this.mappedFile);
            throw e;
        }
    }

    long allocate() {
        assert (!this.bufBases.isEmpty()) : "MmapSlab disposed";
        int freeBlockIndex = this.blockBitmap.nextClearBit(0);
        if (freeBlockIndex == this.blockCount) {
            this.mmapExpand(this.blockCount);
        }
        assert (freeBlockIndex < this.blockCount) : String.format("freeBlockIndex %d >= blockCount %d even after expanding", freeBlockIndex, this.blockCount);
        long blockBase = this.indexToBlockBase(freeBlockIndex);
        this.blockBitmap.set(freeBlockIndex);
        ++this.usedBlockCount;
        return blockBase;
    }

    boolean free(long blockBase) {
        assert (!this.bufBases.isEmpty()) : "MmapSlab disposed";
        this.blockBitmap.clear(this.blockBaseToIndex(blockBase));
        return --this.usedBlockCount == 0;
    }

    long indexToBlockBase(int blockIndex) {
        int blockIndexLog2 = QuickMath.log2(blockIndex);
        int indexOfBuf = Math.max(0, blockIndexLog2 - this.initialBlockCountLog2 + 1);
        long bufBase = this.bufBases.get(indexOfBuf);
        int indexAtBufBase = indexOfBuf == 0 ? 0 : 1 << blockIndexLog2;
        int bufRelativeIndex = blockIndex - indexAtBufBase;
        long blockOffset = this.blockSize * (long)bufRelativeIndex;
        return bufBase + blockOffset;
    }

    int blockBaseToIndex(long blockBase) {
        Map.Entry<Long, Integer> floorEntry = this.bufBase2BufIndex.floorEntry(blockBase);
        long bufBase = floorEntry.getKey();
        long blockOffset = blockBase - bufBase;
        assert (blockOffset % this.blockSize == 0L) : String.format("Block with base address %,d doesn't belong to this slab. Resolved buffer base %,d, block offset %,d. Block size %,d, blockOffset %% blockSize %,d", blockBase, bufBase, blockOffset, this.blockSize, blockOffset % this.blockSize);
        long bufRelativeBlockIndex = blockOffset / this.blockSize;
        int indexOfBuf = floorEntry.getValue();
        int indexAtBufBase = indexOfBuf == 0 ? 0 : 1 << indexOfBuf - 1 + this.initialBlockCountLog2;
        long blockIndex = (long)indexAtBufBase + bufRelativeBlockIndex;
        assert (blockIndex < (long)this.blockCount) : String.format("Block with base address %,d doesn't belong to this slab. Resolved buffer base %,d, block offset %,d, index at buffer base %,d, buffer-relative block index %,d, global block index %,d. Total block count %,d", blockBase, bufBase, blockOffset, indexAtBufBase, bufRelativeBlockIndex, blockIndex, this.blockCount);
        return (int)blockIndex;
    }

    private void mmapExpand(long addedBlockCount) {
        long addedFileSize = addedBlockCount * this.blockSize;
        long newFileSize = ((long)this.blockCount + addedBlockCount) * this.blockSize;
        try {
            this.raf.setLength(newFileSize);
            FileChannel chan = this.raf.getChannel();
            long fileposOfNewBuffer = (long)this.blockCount * this.blockSize;
            long offsetOfBufIntoMmapPage = fileposOfNewBuffer % this.mmapPageSize;
            long fileposOfMappedRegion = fileposOfNewBuffer - offsetOfBufIntoMmapPage;
            long sizeOfMappedRegion = addedFileSize + offsetOfBufIntoMmapPage;
            long mmapBase = MmapSlab.map0(chan, fileposOfMappedRegion, sizeOfMappedRegion);
            long bufBase = mmapBase + offsetOfBufIntoMmapPage;
            this.bufBases.add(bufBase);
            this.offsetsOfBufsFromMmmapBases.add((int)offsetOfBufIntoMmapPage);
            this.bufBase2BufIndex.put(bufBase, this.bufBases.size() - 1);
            this.blockCount = (int)((long)this.blockCount + addedBlockCount);
        }
        catch (Throwable t) {
            throw new HotRestartException(String.format("mmap allocation failed. addedFileSize %,d newFileSize %,d blockCount %,d blockSize %,d", addedFileSize, newFileSize, this.blockCount, this.blockSize), t);
        }
    }

    @Override
    public void dispose() {
        if (this.bufBases.isEmpty()) {
            return;
        }
        try {
            FileChannel chan = this.raf.getChannel();
            long blockCount = 1L << this.initialBlockCountLog2;
            boolean atFirstBuffer = true;
            for (int i = 0; i < this.bufBases.size(); ++i) {
                long bufBase = this.bufBases.get(i);
                int bufOffsetFromMmapBase = this.offsetsOfBufsFromMmmapBases.get(i);
                int unused = MAPPER.unmap(chan, bufBase - (long)bufOffsetFromMmapBase, blockCount * this.blockSize + (long)bufOffsetFromMmapBase);
                if (atFirstBuffer) {
                    atFirstBuffer = false;
                    continue;
                }
                blockCount *= 2L;
            }
            this.bufBases.clear();
            this.raf.close();
            IOUtil.delete(this.mappedFile);
        }
        catch (NoSuchMethodException e) {
            throw new HotRestartException("unmap0 method not found", e);
        }
        catch (InvocationTargetException e) {
            throw new HotRestartException("Reflection error accessing unmap0", e);
        }
        catch (IllegalAccessException e) {
            throw new HotRestartException("Reflection error accessing unmap0", e);
        }
        catch (IOException e) {
            throw new HotRestartException("Failed to close RAF", e);
        }
        catch (Throwable t) {
            throw new HotRestartException("unmap0 threw exception", t);
        }
    }

    private static long map0(FileChannel chan, long fileposOfMappedRegion, long sizeOfMappedRegion) {
        try {
            return MAPPER.map(chan, fileposOfMappedRegion, sizeOfMappedRegion);
        }
        catch (Throwable throwable) {
            throw new HotRestartException("Mapping invocation failed", throwable);
        }
    }

    static {
        try {
            MapperAccessor m = JavaVersion.isAtLeast(JavaVersion.JAVA_20) ? new Java20Mapper() : (JavaVersion.isAtLeast(JavaVersion.JAVA_19) ? new Java19Mapper() : new Java14Mapper());
            MAPPER = m;
        }
        catch (Throwable t) {
            throw new HotRestartException("Reflection error accessing sun.nio.ch.FileChannelImpl", t);
        }
    }
}

