/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl.gc.mem;

import com.hazelcast.hotrestart.HotRestartException;
import com.hazelcast.internal.hotrestart.impl.gc.mem.MmapSlab;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.nio.Disposable;
import com.hazelcast.internal.util.collection.Long2ObjectHashMap;
import java.io.File;

public class MmapMalloc
implements MemoryAllocator,
Disposable {
    private final File baseDir;
    private final Long2ObjectHashMap<MmapSlab> slabs = new Long2ObjectHashMap();
    private final boolean deleteEmptySlab;

    public MmapMalloc(File baseDir, boolean deleteEmptySlab) {
        this.deleteEmptySlab = deleteEmptySlab;
        if (!baseDir.exists() && !baseDir.mkdirs()) {
            throw new HotRestartException("Could not create the mmap base directory " + String.valueOf(baseDir));
        }
        this.baseDir = baseDir;
    }

    @Override
    public long allocate(long size) {
        MmapSlab slab = this.slabs.get(size);
        if (slab == null) {
            slab = new MmapSlab(this.baseDir, size);
            this.slabs.put(size, slab);
        }
        return slab.allocate();
    }

    @Override
    public long reallocate(long address, long currentSize, long newSize) {
        throw new UnsupportedOperationException("reallocate");
    }

    @Override
    public void free(long address, long size) {
        MmapSlab slab = this.slabs.get(size);
        if (slab.free(address) && this.deleteEmptySlab) {
            slab.dispose();
            this.slabs.remove(size);
        }
    }

    @Override
    public void dispose() {
        for (MmapSlab slab : this.slabs.values()) {
            slab.dispose();
        }
    }
}

