/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl.gc.chunk;

import com.hazelcast.internal.hotrestart.KeyHandle;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.Chunk;
import com.hazelcast.internal.hotrestart.impl.gc.record.Record;
import com.hazelcast.internal.hotrestart.impl.gc.record.RecordMap;

public abstract class GrowingChunk
extends Chunk {
    private final int sizeLimit = this.determineSizeLimit();
    private long size;
    private int addStep2FilePos;

    protected GrowingChunk(long chunkSeq, RecordMap records) {
        super(chunkSeq, records);
    }

    public final void addStep2(long recordSeq, long keyPrefix, KeyHandle kh, int size) {
        this.insertOrUpdate(recordSeq, keyPrefix, kh, this.addStep2FilePos, size);
        this.addStep2FilePos += size;
        ++this.liveRecordCount;
    }

    public final void addStep2(long recordSeq, long keyPrefix, KeyHandle kh, int filePos, int size) {
        this.insertOrUpdate(recordSeq, keyPrefix, kh, filePos, size);
        ++this.liveRecordCount;
    }

    public abstract void insertOrUpdate(long var1, long var3, KeyHandle var5, int var6, int var7);

    @Override
    public final long size() {
        return this.size;
    }

    protected final void grow(int amount) {
        this.size += (long)amount;
    }

    public final boolean full() {
        return this.size() >= (long)this.sizeLimit;
    }

    protected final void insertOrUpdateValue(long recordSeq, long keyPrefix, KeyHandle kh, int size) {
        Record existing = this.records.putIfAbsent(keyPrefix, kh, recordSeq, size, false, 0);
        if (existing != null) {
            existing.update(recordSeq, size);
        }
    }

    protected final void insertOrUpdateTombstone(long recordSeq, long keyPrefix, KeyHandle kh, int filePos, int size) {
        Record existing = this.records.putIfAbsent(keyPrefix, kh, recordSeq, size, true, filePos);
        if (existing != null) {
            existing.update(recordSeq, size);
            existing.setFilePosition(filePos);
        }
    }

    protected abstract int determineSizeLimit();
}

