/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl.gc;

import com.hazelcast.hotrestart.HotRestartException;
import com.hazelcast.internal.hotrestart.KeyHandle;
import com.hazelcast.internal.hotrestart.RamStore;
import com.hazelcast.internal.hotrestart.RamStoreRegistry;
import com.hazelcast.internal.hotrestart.impl.SortedBySeqRecordCursor;
import com.hazelcast.internal.hotrestart.impl.di.Inject;
import com.hazelcast.internal.hotrestart.impl.gc.ChunkManager;
import com.hazelcast.internal.hotrestart.impl.gc.GcHelper;
import com.hazelcast.internal.hotrestart.impl.gc.GcLogger;
import com.hazelcast.internal.hotrestart.impl.gc.MutatorCatchup;
import com.hazelcast.internal.hotrestart.impl.gc.PrefixTombstoneManager;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.Chunk;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.StableValChunk;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.SurvivorValChunk;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.WriteThroughChunk;
import com.hazelcast.internal.hotrestart.impl.gc.record.Record;
import com.hazelcast.internal.hotrestart.impl.gc.record.RecordDataHolder;
import com.hazelcast.internal.hotrestart.impl.gc.record.RecordMap;
import com.hazelcast.internal.util.collection.Long2ObjectHashMap;
import java.util.Collection;
import java.util.concurrent.TimeUnit;

final class ValEvacuator {
    public static final String SYSPROP_GC_STUCK_DETECT_THRESHOLD = "hazelcast.hotrestart.gc.stuckDetectThreshold";
    private final int stuckDetectionThreshold = Integer.getInteger("hazelcast.hotrestart.gc.stuckDetectThreshold", 1000000);
    private final Collection<StableValChunk> srcChunks;
    @Inject
    private GcLogger logger;
    @Inject
    private RamStoreRegistry ramStoreRegistry;
    @Inject
    private PrefixTombstoneManager pfixTombstoMgr;
    @Inject
    private MutatorCatchup mc;
    @Inject
    private GcHelper gcHelper;
    @Inject
    private ChunkManager chunkMgr;
    @Inject
    private RecordDataHolder recordDataHolder;
    private Long2ObjectHashMap<WriteThroughChunk> survivorMap;
    private final StableValChunk firstSrcChunk;
    private long start;
    private SurvivorValChunk survivor;

    ValEvacuator(Collection<StableValChunk> srcChunks, long start) {
        this.srcChunks = srcChunks;
        this.start = start;
        this.firstSrcChunk = srcChunks.iterator().next();
    }

    void evacuate() {
        this.chunkMgr.setSurvivors(new Long2ObjectHashMap<WriteThroughChunk>());
        this.survivorMap = this.chunkMgr.getSurvivors();
        SortedBySeqRecordCursor liveRecords = this.sortedLiveRecords();
        this.logger.finest("ValueGC preparation took %,d ms ", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.start));
        this.moveToSurvivors(liveRecords);
        liveRecords.dispose();
        for (Chunk chunk : this.survivorMap.values()) {
            this.pfixTombstoMgr.dismissGarbage(chunk);
        }
    }

    private SortedBySeqRecordCursor sortedLiveRecords() {
        RecordMap[] recordMaps = new RecordMap[this.srcChunks.size()];
        this.mc.catchupNow();
        int i = 0;
        int liveRecordCount = 0;
        for (StableValChunk chunk : this.srcChunks) {
            recordMaps[i++] = chunk.records;
            liveRecordCount += chunk.liveRecordCount;
        }
        this.mc.catchupNow();
        return recordMaps[0].sortedBySeqCursor(liveRecordCount, recordMaps, this.mc);
    }

    private void moveToSurvivors(SortedBySeqRecordCursor sortedCursor) {
        RecordDataHolder holder = this.recordDataHolder;
        while (sortedCursor.advance()) {
            this.applyClearOperation();
            Record r = sortedCursor.asRecord();
            if (!r.isAlive()) continue;
            holder.clear();
            KeyHandle kh = sortedCursor.asKeyHandle();
            RamStore ramStore = this.ramStoreRegistry.ramStoreForPrefix(r.keyPrefix(kh));
            if (ramStore != null && ramStore.copyEntry(kh, r.payloadSize(), holder)) {
                holder.flip();
                this.ensureSurvivor();
                this.chunkMgr.getTrackers().get(kh).moveToChunk(this.survivor.seq);
                this.survivor.add(r, kh, holder);
                if (!this.survivor.full()) continue;
                this.closeSurvivor();
                continue;
            }
            if (this.catchUpUntilRetired(r, this.mc)) continue;
            String ramStoreName = ramStore != null ? ramStore.getClass().getSimpleName() : "null";
            holder.keyBuffer.flip();
            throw new HotRestartException(String.format("Stuck while waiting for a record to be retired. Chunk #%03x, key prefix %x, record #%03x, size %,d, RAM store was %s", this.survivor != null ? this.survivor.seq : -1L, r.keyPrefix(kh), r.liveSeq(), r.size(), ramStoreName));
        }
        if (this.survivor != null) {
            this.closeSurvivor();
        }
    }

    private void applyClearOperation() {
        while (this.firstSrcChunk.needsDismissing()) {
            for (StableValChunk chunk : this.srcChunks) {
                this.pfixTombstoMgr.dismissGarbage(chunk);
                this.mc.catchupNow();
            }
        }
    }

    private void ensureSurvivor() {
        if (this.survivor != null) {
            return;
        }
        this.start = System.nanoTime();
        this.survivor = this.gcHelper.newSurvivorValChunk(this.mc);
        this.survivor.flagForFsyncOnClose(true);
        this.survivorMap.put(this.survivor.seq, (WriteThroughChunk)this.survivor);
    }

    private void closeSurvivor() {
        this.mc.catchupNow();
        this.survivor.close();
        this.mc.catchupNow();
        this.logger.finest("Wrote chunk #%03x (%,d bytes) in %d ms", this.survivor.seq, this.survivor.size(), TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.start));
        this.survivor = null;
        this.mc.catchupNow();
    }

    private boolean catchUpUntilRetired(Record r, MutatorCatchup mc) {
        for (int eventCount = 0; eventCount <= this.stuckDetectionThreshold && r.isAlive(); eventCount += this.catchUpSafely(mc, r)) {
        }
        return !r.isAlive();
    }

    private int catchUpSafely(MutatorCatchup mc, Record r) {
        int eventCount = mc.catchupNow();
        this.applyClearOperation();
        if (mc.shutdownRequested()) {
            eventCount += mc.catchupNow();
            this.applyClearOperation();
            if (r.isAlive()) {
                throw new HotRestartException("Record not available, retirement event not received, shutdown requested");
            }
        }
        return eventCount;
    }
}

