/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl.gc;

import com.hazelcast.hotrestart.HotRestartException;
import com.hazelcast.internal.hotrestart.KeyHandle;
import com.hazelcast.internal.hotrestart.impl.di.Inject;
import com.hazelcast.internal.hotrestart.impl.di.Name;
import com.hazelcast.internal.hotrestart.impl.gc.ChunkManager;
import com.hazelcast.internal.hotrestart.impl.gc.GcHelper;
import com.hazelcast.internal.hotrestart.impl.gc.GcLogger;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.ActiveValChunk;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.Chunk;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.StableChunk;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.StableValChunk;
import com.hazelcast.internal.hotrestart.impl.gc.record.Record;
import com.hazelcast.internal.hotrestart.impl.gc.record.RecordMap;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.util.collection.Long2LongHashMap;
import com.hazelcast.internal.util.collection.Long2ObjectHashMap;
import com.hazelcast.internal.util.collection.LongHashSet;
import com.hazelcast.internal.util.concurrent.ConcurrentConveyorSingleQueue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@SuppressFBWarnings(value={"IS"}, justification="All accesses of the map referred to by mutatorPrefixTombstones are synchronized. Setter doesn't need synchronization because it is called before GC thread is started.")
public class PrefixTombstoneManager {
    public static final String NEW_FILE_SUFFIX = ".new";
    public static final int SWEEPING_TIMESLICE_MS = 10;
    long chunkSeqToStartSweep;
    private final GcLogger logger;
    private final GcHelper gcHelper;
    private final ConcurrentConveyorSingleQueue<Runnable> conveyor;
    private final ChunkManager chunkMgr;
    private Long2LongHashMap mutatorPrefixTombstones;
    private Long2LongHashMap collectorPrefixTombstones;
    private final Long2LongHashMap dismissedActiveChunks = new Long2LongHashMap(0L);
    private Sweeper sweeper;

    @Inject
    PrefixTombstoneManager(ChunkManager chunkMgr, GcHelper gcHelper, GcLogger logger, @Name(value="gcConveyor") ConcurrentConveyorSingleQueue<Runnable> conveyor) {
        this.conveyor = conveyor;
        this.chunkMgr = chunkMgr;
        this.gcHelper = gcHelper;
        this.logger = logger;
    }

    public long maxRecordSeq() {
        if (this.collectorPrefixTombstones == null) {
            return 0L;
        }
        long maxSeq = 0L;
        Long2LongHashMap.LongLongCursor cursor = this.collectorPrefixTombstones.cursor();
        while (cursor.advance()) {
            long recordSeq = cursor.value();
            if (recordSeq <= maxSeq) continue;
            maxSeq = recordSeq;
        }
        return maxSeq;
    }

    public void setPrefixTombstones(Long2LongHashMap prefixTombstones) {
        this.mutatorPrefixTombstones = prefixTombstones;
        this.collectorPrefixTombstones = new Long2LongHashMap(prefixTombstones);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPrefixTombstones(long[] prefixes) {
        Long2LongHashMap tombstoneSnapshot;
        long currRecordSeq = this.gcHelper.recordSeq();
        PrefixTombstoneManager prefixTombstoneManager = this;
        synchronized (prefixTombstoneManager) {
            PrefixTombstoneManager.multiPut(this.mutatorPrefixTombstones, prefixes, currRecordSeq);
            tombstoneSnapshot = new Long2LongHashMap(this.mutatorPrefixTombstones);
        }
        this.conveyor.submit(this.addedPrefixTombstones(prefixes, currRecordSeq, this.gcHelper.chunkSeq()));
        this.persistTombstones(tombstoneSnapshot);
    }

    private Runnable addedPrefixTombstones(final long[] prefixes, final long recordSeq, final long startChunkSeq) {
        return new Runnable(){

            @Override
            public void run() {
                PrefixTombstoneManager.multiPut(PrefixTombstoneManager.this.collectorPrefixTombstones, prefixes, recordSeq);
                ActiveValChunk activeChunk = PrefixTombstoneManager.this.chunkMgr.getActiveValChunk();
                PrefixTombstoneManager.this.dismissGarbage(activeChunk, prefixes);
                PrefixTombstoneManager.multiPut(PrefixTombstoneManager.this.dismissedActiveChunks, prefixes, activeChunk.seq);
                for (StableChunk stableChunk : PrefixTombstoneManager.this.chunkMgr.getChunks().values()) {
                    stableChunk.needsDismissing(true);
                }
                if (PrefixTombstoneManager.this.chunkMgr.getSurvivors() != null) {
                    for (Chunk chunk : PrefixTombstoneManager.this.chunkMgr.getSurvivors().values()) {
                        chunk.needsDismissing(true);
                    }
                }
                if (PrefixTombstoneManager.this.sweeper == null) {
                    PrefixTombstoneManager.this.sweeper = new Sweeper(startChunkSeq);
                    PrefixTombstoneManager.this.chunkSeqToStartSweep = 0L;
                } else {
                    PrefixTombstoneManager.this.chunkSeqToStartSweep = startChunkSeq;
                }
            }
        };
    }

    @SuppressFBWarnings(value={"QBA"}, justification="sweptSome = true executes conditionally on sweepNextChunk() returning true. sweptSome correctly tells whether some chunk was swept")
    boolean sweepAsNeeded() {
        long start = System.nanoTime();
        if (this.sweeper != null) {
            boolean sweptSome = false;
            boolean hadMoreTime = true;
            while (this.sweeper.sweepNextChunk()) {
                sweptSome = true;
                if (true && (hadMoreTime = System.nanoTime() - start < TimeUnit.MILLISECONDS.toNanos(10L))) continue;
            }
            if (hadMoreTime) {
                this.sweeper = null;
            }
            return sweptSome;
        }
        if (this.chunkSeqToStartSweep != 0L) {
            this.sweeper = new Sweeper(this.chunkSeqToStartSweep);
            this.chunkSeqToStartSweep = 0L;
            this.sweepAsNeeded();
        }
        this.sweeper = null;
        return false;
    }

    boolean sweepingInProgress() {
        return this.sweeper != null || this.chunkSeqToStartSweep != 0L;
    }

    void dismissGarbage(ActiveValChunk chunk, long[] prefixesToDismiss) {
        this.logger.finest("Dismiss garbage in active chunk #%03x", chunk.seq);
        LongHashSet prefixSetToDismiss = new LongHashSet(prefixesToDismiss, 0L);
        RecordMap.Cursor cursor = chunk.records.cursor();
        while (cursor.advance()) {
            KeyHandle kh;
            Record r = cursor.asRecord();
            long prefix = r.keyPrefix(kh = cursor.toKeyHandle());
            if (!prefixSetToDismiss.contains(prefix)) continue;
            this.chunkMgr.dismissPrefixGarbage(chunk, kh, r);
        }
    }

    public boolean dismissGarbage(Chunk chunk) {
        if (!chunk.needsDismissing()) {
            return false;
        }
        this.logger.finest("Dismiss garbage in #%03x", chunk.seq);
        RecordMap.Cursor cursor = chunk.records.cursor();
        while (cursor.advance()) {
            KeyHandle kh;
            Record r = cursor.asRecord();
            long prefix = r.keyPrefix(kh = cursor.toKeyHandle());
            if (this.dismissedActiveChunks.get(prefix) == chunk.seq || r.deadOrAliveSeq() > this.collectorPrefixTombstones.get(prefix)) continue;
            this.chunkMgr.dismissPrefixGarbage(chunk, kh, r);
        }
        chunk.needsDismissing(false);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectGarbageTombstones(Long2LongHashMap garbageTombstones) {
        int collectedCount = 0;
        Long2LongHashMap.LongLongCursor cursor = garbageTombstones.cursor();
        while (cursor.advance()) {
            if (this.collectorPrefixTombstones.get(cursor.key()) != cursor.value()) continue;
            this.collectorPrefixTombstones.remove(cursor.key());
            this.dismissedActiveChunks.remove(cursor.key());
            ++collectedCount;
        }
        if (collectedCount > 0) {
            this.logger.fine("Collected %,d garbage prefix tombstones", collectedCount);
        }
        PrefixTombstoneManager prefixTombstoneManager = this;
        synchronized (prefixTombstoneManager) {
            Long2LongHashMap.LongLongCursor cursor2 = garbageTombstones.cursor();
            while (cursor2.advance()) {
                if (this.mutatorPrefixTombstones.get(cursor2.key()) != cursor2.value()) continue;
                this.mutatorPrefixTombstones.remove(cursor2.key());
            }
        }
    }

    private void persistTombstones(Long2LongHashMap tombstoneSnapshot) {
        File homeDir = this.gcHelper.homeDir;
        File newFile = new File(homeDir, "prefix-tombstones.new");
        FileOutputStream fileOut = null;
        try {
            fileOut = new FileOutputStream(newFile);
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(fileOut));
            Long2LongHashMap.LongLongCursor c = tombstoneSnapshot.cursor();
            while (c.advance()) {
                out.writeLong(c.key());
                out.writeLong(c.value());
            }
            out.flush();
            fileOut.getFD().sync();
            out.close();
            fileOut = null;
            IOUtil.rename(newFile, new File(homeDir, "prefix-tombstones"));
            IOUtil.fsyncDir(homeDir.toPath());
            this.logger.finestVerbose("Persisted prefix tombstones %s", tombstoneSnapshot);
        }
        catch (IOException e) {
            try {
                IOUtil.closeResource(fileOut);
                if (!newFile.delete()) {
                    this.logger.severe("Failed to delete " + String.valueOf(newFile));
                }
                throw new HotRestartException("IO error while writing prefix tombstones", e);
            }
            catch (Throwable throwable) {
                IOUtil.closeResource(fileOut);
                throw throwable;
            }
        }
        IOUtil.closeResource(fileOut);
    }

    private static void multiPut(Long2LongHashMap map, long[] keys, long value) {
        for (long prefix : keys) {
            map.put(prefix, value);
        }
    }

    public void backup(File targetDir) {
        File pfixTombstoneFile = new File(this.gcHelper.homeDir, "prefix-tombstones");
        if (pfixTombstoneFile.exists()) {
            IOUtil.copy(pfixTombstoneFile, targetDir);
        }
    }

    private final class Sweeper {
        private final Long2LongHashMap garbageTombstones;
        private final long lowChunkSeq;
        private final long sweptActiveChunkSeq;
        private long chunkSeq;

        Sweeper(long highChunkSeq) {
            this.garbageTombstones = new Long2LongHashMap(PrefixTombstoneManager.this.collectorPrefixTombstones);
            this.chunkSeq = highChunkSeq;
            this.lowChunkSeq = this.lowChunkSeq();
            ActiveValChunk activeChunk = PrefixTombstoneManager.this.chunkMgr.getActiveValChunk();
            if (activeChunk.seq <= highChunkSeq) {
                this.markLiveTombstones(activeChunk);
                this.sweptActiveChunkSeq = activeChunk.seq;
            } else {
                this.sweptActiveChunkSeq = 0L;
            }
        }

        boolean sweepNextChunk() {
            StableValChunk toSweep = this.nextChunkToSweep();
            if (toSweep == null) {
                PrefixTombstoneManager.this.collectGarbageTombstones(this.garbageTombstones);
                return false;
            }
            PrefixTombstoneManager.this.dismissGarbage(toSweep);
            if (toSweep.seq != this.sweptActiveChunkSeq) {
                this.markLiveTombstones(toSweep);
            }
            return true;
        }

        private void markLiveTombstones(Chunk chunk) {
            Object cursor = chunk.records.cursor();
            while (cursor.advance()) {
                Record r = cursor.asRecord();
                KeyHandle kh = cursor.toKeyHandle();
                long prefix = r.keyPrefix(kh);
                this.garbageTombstones.remove(prefix);
            }
            if (!(chunk instanceof StableValChunk)) {
                return;
            }
            cursor = ((StableValChunk)chunk).clearedPrefixesFoundAtRestart.cursor();
            while (cursor.advance()) {
                this.garbageTombstones.remove(cursor.value());
            }
        }

        private long lowChunkSeq() {
            long lowChunkSeq = Long.MAX_VALUE;
            Long2ObjectHashMap.KeyIterator it = PrefixTombstoneManager.this.chunkMgr.getChunks().keySet().iterator();
            while (it.hasNext()) {
                lowChunkSeq = Math.min(lowChunkSeq, it.nextLong());
            }
            return lowChunkSeq;
        }

        private StableValChunk nextChunkToSweep() {
            Long2ObjectHashMap<StableChunk> chunkMap = PrefixTombstoneManager.this.chunkMgr.getChunks();
            while (this.chunkSeq >= this.lowChunkSeq) {
                StableChunk c;
                if (!((c = (StableChunk)chunkMap.get((Object)this.chunkSeq--)) instanceof StableValChunk)) continue;
                StableValChunk stableValChunk = (StableValChunk)c;
                return stableValChunk;
            }
            return null;
        }
    }
}

