/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl.gc;

import com.hazelcast.hotrestart.HotRestartException;
import com.hazelcast.internal.hotrestart.impl.SetOfKeyHandle;
import com.hazelcast.internal.hotrestart.impl.di.Inject;
import com.hazelcast.internal.hotrestart.impl.di.Name;
import com.hazelcast.internal.hotrestart.impl.encryption.EncryptionManager;
import com.hazelcast.internal.hotrestart.impl.gc.GcLogger;
import com.hazelcast.internal.hotrestart.impl.gc.MutatorCatchup;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.ActiveValChunk;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.StableChunk;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.SurvivorValChunk;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.WriteThroughTombChunk;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.WriteThroughTombChunkImpl;
import com.hazelcast.internal.hotrestart.impl.gc.mem.MmapMalloc;
import com.hazelcast.internal.hotrestart.impl.gc.record.RecordMap;
import com.hazelcast.internal.hotrestart.impl.gc.record.RecordMapOffHeap;
import com.hazelcast.internal.hotrestart.impl.gc.record.RecordMapOnHeap;
import com.hazelcast.internal.hotrestart.impl.gc.record.SetOfKeyHandleOffHeap;
import com.hazelcast.internal.hotrestart.impl.gc.record.SetOfKeyHandleOnHeap;
import com.hazelcast.internal.hotrestart.impl.gc.tracker.TrackerMap;
import com.hazelcast.internal.hotrestart.impl.gc.tracker.TrackerMapOffHeap;
import com.hazelcast.internal.hotrestart.impl.gc.tracker.TrackerMapOnHeap;
import com.hazelcast.internal.hotrestart.impl.io.ChunkFileOut;
import com.hazelcast.internal.hotrestart.impl.io.EncryptedChunkFileOut;
import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.memory.MemoryManager;
import com.hazelcast.internal.memory.impl.MemoryManagerBean;
import com.hazelcast.internal.nio.Disposable;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.logging.Logger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import javax.crypto.Cipher;

public abstract class GcHelper
implements Disposable {
    public static final String PREFIX_TOMBSTONES_FILENAME = "prefix-tombstones";
    public static final int BITS_PER_HEX_DIGIT = 4;
    public static final int CHUNK_FNAME_LENGTH = 16;
    public static final int BUCKET_DIRNAME_DIGITS = 2;
    public static final int MAX_BUCKET_DIRS = 256;
    public static final int BUCKET_DIR_MASK = 255;
    private static final String BUCKET_DIRNAME_FORMAT = String.format("%%0%dx", 2);
    private static final String CHUNK_FNAME_FORMAT = String.format("%%0%dx%%s", 16);
    final File homeDir;
    final EncryptionManager encryptionMgr;
    final GcLogger logger;
    private final AtomicLong chunkSeq = new AtomicLong();
    private volatile long recordSeq;

    GcHelper(File homeDir, GcLogger logger, EncryptionManager encryptionMgr) {
        this.homeDir = homeDir;
        this.logger = logger;
        this.encryptionMgr = encryptionMgr;
    }

    public ActiveValChunk newActiveValChunk() {
        long seq = this.chunkSeq.incrementAndGet();
        return new ActiveValChunk(seq, this.newRecordMap(false), this.chunkFileOut(this.chunkFile("value", seq, ".chunk.active", true), null), this);
    }

    public final SurvivorValChunk newSurvivorValChunk(MutatorCatchup mc) {
        long seq = this.chunkSeq.incrementAndGet();
        return new SurvivorValChunk(seq, this.newRecordMap(true), this.chunkFileOut(this.chunkFile("value", seq, ".chunk.chunk.survivor", true), mc), this);
    }

    public WriteThroughTombChunk newActiveTombChunk() {
        return this.newWriteThroughTombChunk(".active");
    }

    final WriteThroughTombChunk newWriteThroughTombChunk(String suffix) {
        long seq = this.chunkSeq.incrementAndGet();
        return new WriteThroughTombChunkImpl(seq, suffix, this.newTombstoneMap(), this.chunkFileOut(this.chunkFile("tombstone", seq, ".chunk" + suffix, true), null), this);
    }

    private ChunkFileOut chunkFileOut(File f, MutatorCatchup mc) {
        try {
            Cipher cipher = this.encryptionMgr.newWriteCipher(f.getParent());
            return cipher == null ? new ChunkFileOut(f, mc) : new EncryptedChunkFileOut(f, mc, cipher);
        }
        catch (IOException e) {
            throw new HotRestartException(e);
        }
    }

    public final void initChunkSeq(long seq) {
        this.chunkSeq.set(seq);
    }

    public final long chunkSeq() {
        return this.chunkSeq.get();
    }

    final void initRecordSeq(long seq) {
        this.recordSeq = seq;
    }

    public final long recordSeq() {
        return this.recordSeq;
    }

    public final long nextRecordSeq() {
        return ++this.recordSeq;
    }

    public void deleteChunkFile(StableChunk chunk) {
        File toDelete = this.stableChunkFile(chunk, false);
        GcHelper.deleteFile(toDelete);
        this.deleteIVFile(chunk.base(), chunk.seq);
    }

    public void deleteChunkFiles(long[] chunkSeqs, boolean areValChunks) {
        String baseDir = areValChunks ? "value" : "tombstone";
        for (long seq : chunkSeqs) {
            GcHelper.deleteFile(this.chunkFile(baseDir, seq, ".chunk", false));
            this.deleteIVFile(baseDir, seq);
        }
    }

    public void deleteChunkFile(long seq, boolean isValChunk) {
        String baseDir = isValChunk ? "value" : "tombstone";
        GcHelper.deleteFile(this.chunkFile(baseDir, seq, ".chunk", false));
        this.deleteIVFile(baseDir, seq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="IV is an existing file and there is a catch statement for any case")
    public void deleteIVFile(String baseDir, long seq) {
        File ivFile = this.ivFile(baseDir, seq);
        if (ivFile.exists()) {
            File parentFile = ivFile.getParentFile();
            EncryptionManager encryptionManager = this.encryptionMgr;
            synchronized (encryptionManager) {
                if (parentFile != null && parentFile.list().length == 1) {
                    GcHelper.deleteFile(ivFile);
                }
            }
        }
    }

    private static void deleteFile(File toDelete) {
        if (!toDelete.exists()) {
            Logger.getLogger(GcHelper.class).info("Attempt to delete non-existent file " + String.valueOf(toDelete));
        }
        IOUtil.delete(toDelete);
    }

    public void changeSuffix(String base, long seq, String suffixNow, String suffixToBe) {
        File nameNow = this.chunkFile(base, seq, suffixNow, false);
        File nameToBe = this.chunkFile(base, seq, suffixToBe, false);
        IOUtil.rename(nameNow, nameToBe);
    }

    public final File stableChunkFile(StableChunk chunk, boolean mkdirs) {
        return this.chunkFile(chunk.base(), chunk.seq, chunk.fnameSuffix(), mkdirs);
    }

    public File chunkFile(String base, long seq, String suffix, boolean mkdirs) {
        String bucketDirname = String.format(BUCKET_DIRNAME_FORMAT, seq & 0xFFL);
        String chunkFilename = String.format(CHUNK_FNAME_FORMAT, seq, suffix);
        File bucketDir = new File(new File(this.homeDir, base), bucketDirname);
        if (mkdirs && !bucketDir.isDirectory() && !bucketDir.mkdirs()) {
            throw new HotRestartException("Cannot create chunk bucket directory " + String.valueOf(bucketDir));
        }
        return new File(bucketDir, chunkFilename);
    }

    public File ivFile(String base, long seq) {
        String bucketDirname = String.format(BUCKET_DIRNAME_FORMAT, seq & 0xFFL);
        File bucketDir = new File(new File(this.homeDir, base), bucketDirname);
        return new File(bucketDir, "iv.bin");
    }

    abstract RecordMap newRecordMap(boolean var1);

    abstract RecordMap newTombstoneMap();

    public abstract TrackerMap newTrackerMap();

    public abstract SetOfKeyHandle newSetOfKeyHandle();

    public static final class OffHeap
    extends GcHelper {
        private final MemoryManager ramMgr;
        private final MemoryManager mmapMgr;
        private final MemoryManager mmapMgrWithCompaction;

        @Inject
        private OffHeap(MemoryAllocator malloc, @Name(value="homeDir") File homeDir, GcLogger logger, EncryptionManager encryptionMgr) {
            super(homeDir, logger, encryptionMgr);
            this.ramMgr = OffHeap.wrapWithAmem(malloc);
            this.mmapMgr = OffHeap.wrapWithAmem(new MmapMalloc(new File(homeDir, "mmap"), false));
            this.mmapMgrWithCompaction = OffHeap.wrapWithAmem(new MmapMalloc(new File(homeDir, "mmap-with-compaction"), true));
        }

        @Override
        public RecordMap newRecordMap(boolean isForSurvivorValChunk) {
            return isForSurvivorValChunk ? RecordMapOffHeap.newRecordMapOffHeap(this.mmapMgr, this.ramMgr) : RecordMapOffHeap.newRecordMapOffHeap(this.ramMgr, null);
        }

        @Override
        public RecordMap newTombstoneMap() {
            return RecordMapOffHeap.newTombstoneMapOffHeap(this.ramMgr);
        }

        @Override
        public TrackerMap newTrackerMap() {
            return new TrackerMapOffHeap(this.ramMgr, this.mmapMgrWithCompaction.getAllocator());
        }

        @Override
        public SetOfKeyHandle newSetOfKeyHandle() {
            return new SetOfKeyHandleOffHeap(this.ramMgr);
        }

        @Override
        public void dispose() {
            this.mmapMgrWithCompaction.dispose();
            this.mmapMgr.dispose();
        }

        private static MemoryManager wrapWithAmem(MemoryAllocator malloc) {
            return new MemoryManagerBean(malloc, GlobalMemoryAccessorRegistry.AMEM);
        }
    }

    public static final class OnHeap
    extends GcHelper {
        @Inject
        private OnHeap(@Name(value="homeDir") File homeDir, GcLogger logger, EncryptionManager encryptionMgr) {
            super(homeDir, logger, encryptionMgr);
        }

        @Override
        public RecordMap newRecordMap(boolean ignored) {
            return new RecordMapOnHeap();
        }

        @Override
        RecordMap newTombstoneMap() {
            return this.newRecordMap(false);
        }

        @Override
        public TrackerMap newTrackerMap() {
            return new TrackerMapOnHeap();
        }

        @Override
        public SetOfKeyHandle newSetOfKeyHandle() {
            return new SetOfKeyHandleOnHeap();
        }

        @Override
        public void dispose() {
        }
    }
}

