/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl.gc;

import com.hazelcast.internal.hotrestart.impl.gc.chunk.StableValChunk;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

final class ChunkPriorityQueue {
    private int size;
    private final int maxSize;
    private final StableValChunk[] heap;

    ChunkPriorityQueue(int maxSize) {
        this.heap = new StableValChunk[maxSize == 0 ? 2 : maxSize + 1];
        this.maxSize = maxSize;
    }

    private static boolean betterThan(StableValChunk left, StableValChunk right) {
        return left.cachedBenefitToCost() > right.cachedBenefitToCost();
    }

    public StableValChunk offer(StableValChunk element) {
        if (this.size < this.maxSize) {
            ++this.size;
            this.heap[this.size] = element;
            this.upHeap();
            return null;
        }
        if (this.size > 0 && ChunkPriorityQueue.betterThan(element, this.heap[1])) {
            StableValChunk ret = this.heap[1];
            this.heap[1] = element;
            this.downHeap();
            return ret;
        }
        return element;
    }

    public StableValChunk head() {
        return this.size > 0 ? this.heap[1] : null;
    }

    public StableValChunk pop() {
        if (this.size > 0) {
            StableValChunk result = this.heap[1];
            this.heap[1] = this.heap[this.size];
            --this.size;
            this.downHeap();
            return result;
        }
        return null;
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.size = 0;
    }

    public List<StableValChunk> asList() {
        return this.isEmpty() ? Collections.emptyList() : Arrays.asList(this.heap).subList(1, this.size + 1);
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    private void upHeap() {
        int i = this.size;
        StableValChunk node = this.heap[i];
        for (int j = i >>> 1; j > 0 && ChunkPriorityQueue.betterThan(this.heap[j], node); j >>>= 1) {
            this.heap[i] = this.heap[j];
            i = j;
        }
        this.heap[i] = node;
    }

    private void downHeap() {
        int i = 1;
        StableValChunk node = this.heap[i];
        int j = i << 1;
        int k = j + 1;
        if (k <= this.size && ChunkPriorityQueue.betterThan(this.heap[j], this.heap[k])) {
            j = k;
        }
        while (j <= this.size && ChunkPriorityQueue.betterThan(node, this.heap[j])) {
            this.heap[i] = this.heap[j];
            i = j;
            k = (j = i << 1) + 1;
            if (k > this.size || !ChunkPriorityQueue.betterThan(this.heap[j], this.heap[k])) continue;
            j = k;
        }
        this.heap[i] = node;
    }
}

