/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl.gc;

import com.hazelcast.internal.hotrestart.HotRestartKey;
import com.hazelcast.internal.hotrestart.KeyHandle;
import com.hazelcast.internal.hotrestart.impl.di.DiContainer;
import com.hazelcast.internal.hotrestart.impl.di.Inject;
import com.hazelcast.internal.hotrestart.impl.di.Name;
import com.hazelcast.internal.hotrestart.impl.gc.BackupExecutor;
import com.hazelcast.internal.hotrestart.impl.gc.BackupTask;
import com.hazelcast.internal.hotrestart.impl.gc.ChunkManager;
import com.hazelcast.internal.hotrestart.impl.gc.GcHelper;
import com.hazelcast.internal.hotrestart.impl.gc.GcLogger;
import com.hazelcast.internal.hotrestart.impl.gc.GcParams;
import com.hazelcast.internal.hotrestart.impl.gc.MutatorCatchup;
import com.hazelcast.internal.hotrestart.impl.gc.Snapshotter;
import com.hazelcast.internal.hotrestart.impl.gc.TombChunkSelector;
import com.hazelcast.internal.hotrestart.impl.gc.TombEvacuator;
import com.hazelcast.internal.hotrestart.impl.gc.ValChunkSelector;
import com.hazelcast.internal.hotrestart.impl.gc.ValEvacuator;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.ActiveChunk;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.ActiveValChunk;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.Chunk;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.StableChunk;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.StableTombChunk;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.StableValChunk;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.WriteThroughChunk;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.WriteThroughTombChunk;
import com.hazelcast.internal.hotrestart.impl.gc.record.Record;
import com.hazelcast.internal.hotrestart.impl.gc.record.RecordMap;
import com.hazelcast.internal.hotrestart.impl.gc.tracker.Tracker;
import com.hazelcast.internal.hotrestart.impl.gc.tracker.TrackerMap;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.metrics.ProbeUnit;
import com.hazelcast.internal.util.collection.Long2ObjectHashMap;
import com.hazelcast.internal.util.counters.Counter;
import com.hazelcast.internal.util.counters.SwCounter;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ChunkManagerImpl
implements ChunkManager {
    private static final double UNIT_PERCENTAGE = 100.0;
    @Probe(name="valOccupancy", level=ProbeLevel.MANDATORY, unit=ProbeUnit.BYTES)
    final Counter valOccupancy = SwCounter.newSwCounter();
    @Probe(name="valGarbage", level=ProbeLevel.MANDATORY, unit=ProbeUnit.BYTES)
    final Counter valGarbage = SwCounter.newSwCounter();
    @Probe(name="tombOccupancy", level=ProbeLevel.MANDATORY, unit=ProbeUnit.BYTES)
    final Counter tombOccupancy = SwCounter.newSwCounter();
    @Probe(name="tombGarbage", level=ProbeLevel.MANDATORY, unit=ProbeUnit.BYTES)
    final Counter tombGarbage = SwCounter.newSwCounter();
    final Long2ObjectHashMap<StableChunk> chunks = new Long2ObjectHashMap();
    final TrackerMap trackers;
    Long2ObjectHashMap<WriteThroughChunk> survivors;
    ActiveValChunk activeValChunk;
    WriteThroughTombChunk activeTombChunk;
    private final DiContainer di;
    private final GcLogger logger;
    private final GcHelper gcHelper;
    private final BackupExecutor backupExecutor;
    private final String storeName;
    @Inject
    private Snapshotter snapshotter;
    private Set<Long> chunkSeqsPendingDeletion = Collections.newSetFromMap(new ConcurrentHashMap());
    private AtomicBoolean chunkDeletionInProgress = new AtomicBoolean();
    private long maxValLive;

    @Inject
    ChunkManagerImpl(GcHelper gcHelper, @Name(value="storeName") String storeName, MetricsRegistry metrics, GcLogger logger, DiContainer di, BackupExecutor backupExecutor) {
        this.di = di;
        this.logger = logger;
        this.gcHelper = gcHelper;
        this.trackers = gcHelper.newTrackerMap();
        this.backupExecutor = backupExecutor;
        this.storeName = storeName;
        MetricDescriptor descriptor = metrics.newMetricDescriptor();
        descriptor.withPrefix("persistence").withDiscriminator("storeName", storeName);
        metrics.registerStaticMetrics(descriptor, this);
        metrics.registerStaticMetrics(descriptor, this.trackers);
    }

    @Override
    public ActiveValChunk getActiveValChunk() {
        return this.activeValChunk;
    }

    @Override
    public void setActiveValChunk(ActiveValChunk activeValChunk) {
        this.activeValChunk = activeValChunk;
    }

    @Override
    public WriteThroughTombChunk getActiveTombChunk() {
        return this.activeTombChunk;
    }

    @Override
    public void setActiveTombChunk(WriteThroughTombChunk activeTombChunk) {
        this.activeTombChunk = activeTombChunk;
    }

    @Override
    public Long2ObjectHashMap<WriteThroughChunk> getSurvivors() {
        return this.survivors;
    }

    @Override
    public void setSurvivors(Long2ObjectHashMap<WriteThroughChunk> survivors) {
        this.survivors = survivors;
    }

    @Override
    public Counter getValOccupancy() {
        return this.valOccupancy;
    }

    @Override
    public Counter getValGarbage() {
        return this.valGarbage;
    }

    @Override
    public Counter getTombOccupancy() {
        return this.tombOccupancy;
    }

    @Override
    public Counter getTombGarbage() {
        return this.tombGarbage;
    }

    @Override
    public Long2ObjectHashMap<StableChunk> getChunks() {
        return this.chunks;
    }

    @Override
    public TrackerMap getTrackers() {
        return this.trackers;
    }

    @Override
    public long trackedKeyCount() {
        return this.trackers.size();
    }

    @Override
    public void dispose() {
        this.activeValChunk.dispose();
        this.activeTombChunk.dispose();
        for (Chunk chunk : this.chunks.values()) {
            chunk.dispose();
        }
        this.trackers.dispose();
    }

    @Override
    public void replaceActiveChunk(ActiveChunk fresh, ActiveChunk closed) {
        boolean isTombChunk = fresh instanceof WriteThroughTombChunk;
        if (isTombChunk) {
            this.activeTombChunk = (WriteThroughTombChunk)fresh;
        } else {
            this.activeValChunk = (ActiveValChunk)fresh;
        }
        if (closed == null) {
            return;
        }
        StableChunk stable = closed.toStableChunk();
        (isTombChunk ? this.tombOccupancy : this.valOccupancy).inc(stable.size());
        (isTombChunk ? this.tombGarbage : this.valGarbage).inc(stable.garbage);
        this.updateMaxLive();
        this.chunks.put(stable.seq, stable);
    }

    @Override
    public void addRecord(HotRestartKey hrKey, long recordSeq, int size, boolean isTombstone) {
        long prefix = hrKey.prefix();
        KeyHandle keyHandle = hrKey.handle();
        WriteThroughChunk activeChunk = isTombstone ? this.activeTombChunk : this.activeValChunk;
        Tracker tr = this.trackers.putIfAbsent(keyHandle, activeChunk.seq, false);
        if (tr != null) {
            if (tr.isAlive()) {
                Chunk chunk = this.chunk(tr.chunkSeq());
                this.retire(chunk, keyHandle, chunk.records.get(keyHandle));
            }
            tr.newLiveRecord(activeChunk.seq, isTombstone, this.trackers, false);
        } else assert (!isTombstone) : "Attempted to add a tombstone for non-existing key";
        activeChunk.addStep2(recordSeq, prefix, keyHandle, size);
    }

    @Override
    public void backupChunks(File targetDir) {
        if (this.backupExecutor.inProgress()) {
            this.logger.fine("Hot backup is already in progress, skipping running another backup");
            return;
        }
        int stableTombChunkCount = 0;
        for (StableChunk chunk : this.chunks.values()) {
            if (!(chunk instanceof StableTombChunk)) continue;
            ++stableTombChunkCount;
        }
        long[] stableTombChunkSeqs = new long[stableTombChunkCount];
        long[] stableValChunkSeqs = new long[this.chunks.size() - stableTombChunkCount];
        int valIdx = 0;
        int tombIdx = 0;
        for (StableChunk chunk : this.chunks.values()) {
            if (chunk instanceof StableTombChunk) {
                stableTombChunkSeqs[tombIdx++] = chunk.seq;
                continue;
            }
            stableValChunkSeqs[valIdx++] = chunk.seq;
        }
        this.backupExecutor.run(this.di.wire(new BackupTask(targetDir, this.storeName, stableValChunkSeqs, stableTombChunkSeqs)));
    }

    @Override
    public void updateMaxLive() {
        this.maxValLive = Math.max(this.maxValLive, this.valOccupancy.get() - this.valGarbage.get());
    }

    @Override
    public void retire(Chunk chunk, KeyHandle kh, Record r) {
        this.adjustGlobalGarbage(chunk, r);
        chunk.retire(kh, r);
    }

    @Override
    public void dismissPrefixGarbage(Chunk chunk, KeyHandle kh, Record r) {
        Tracker tr = this.trackers.get(kh);
        if (r.isAlive()) {
            if (tr == null || tr.chunkSeq() != chunk.seq) {
                return;
            }
            this.adjustGlobalGarbage(chunk, r);
            chunk.retire(kh, r, false);
            tr.retire(this.trackers);
        }
        if (tr != null) {
            tr.reduceGarbageCount(r.garbageCount());
            if (tr.garbageCount() == 0L) {
                this.trackers.removeIfDead(kh, tr);
            }
        } else assert (r.garbageCount() == 0) : "Inconsistent global zero garbage count vs. local " + r.garbageCount();
        r.setGarbageCount(0);
    }

    private void dismissGarbage(Chunk c, MutatorCatchup mc) {
        if (!(c instanceof StableValChunk)) {
            return;
        }
        RecordMap.Cursor cursor = c.records.cursor();
        while (cursor.advance()) {
            KeyHandle kh = cursor.toKeyHandle();
            Record r = cursor.asRecord();
            Tracker tr = this.trackers.get(kh);
            if (tr != null) {
                this.dismissChunkGarbageForKey(kh, r, tr);
            } else assert (r.garbageCount() == 0) : "Inconsistent zero global garbage count and local count " + r.garbageCount();
            mc.catchupAsNeeded();
        }
        c.garbage = 0L;
        mc.catchupNow();
    }

    private void dismissChunkGarbageForKey(KeyHandle kh, Record r, Tracker tr) {
        tr.reduceGarbageCount(r.garbageCount());
        r.setGarbageCount(0);
        long newCount = tr.garbageCount();
        if (newCount == 0L) {
            if (tr.isTombstone()) {
                this.dismissTombstone(kh, tr.chunkSeq());
            } else {
                this.trackers.removeIfDead(kh, tr);
            }
        } else assert (newCount >= 0L) : String.format("Garbage count for %s (live in #%03x) went below zero: %d - %d = %d", kh, tr.chunkSeq(), tr.garbageCount(), r.garbageCount(), newCount);
    }

    private void dismissTombstone(KeyHandle kh, long chunkSeq) {
        Chunk chunk = this.chunk(chunkSeq);
        Record r = chunk.records.get(kh);
        this.retire(chunk, kh, r);
        this.trackers.removeLiveTombstone(kh);
    }

    private void adjustGlobalGarbage(Chunk chunk, Record r) {
        if (chunk != this.activeValChunk && chunk != this.activeTombChunk) {
            (r.isTombstone() ? this.tombGarbage : this.valGarbage).inc(r.size());
        }
    }

    private Chunk chunk(long chunkSeq) {
        if (chunkSeq == this.activeValChunk.seq) {
            return this.activeValChunk;
        }
        if (chunkSeq == this.activeTombChunk.seq) {
            return this.activeTombChunk;
        }
        Chunk c = this.chunks.get(chunkSeq);
        Object chunk = c == null ? (this.survivors == null ? null : (Chunk)this.survivors.get(chunkSeq)) : c;
        assert (chunk != null) : String.format("Failed to fetch the chunk #%03x", chunkSeq);
        return chunk;
    }

    @Override
    public GcParams gcParams() {
        return GcParams.gcParams(this.valGarbage.get(), this.valOccupancy.get(), this.maxValLive, this.gcHelper.chunkSeq());
    }

    @Override
    public boolean valueGc(GcParams gcp, MutatorCatchup mc) {
        if (gcp == GcParams.ZERO) {
            return false;
        }
        long start = System.nanoTime();
        Collection<StableValChunk> srcChunks = this.di.wire(new ValChunkSelector(this.chunks.values(), gcp)).select();
        if (srcChunks.isEmpty()) {
            return false;
        }
        this.snapshotter.initSrcChunkSeqs(srcChunks);
        this.logger.finest("ValChunk selection took %,d us", TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - start));
        long garbage = this.valGarbage.get();
        long live = this.valOccupancy.get() - garbage;
        double garbagePercent = 100.0 * (double)garbage / (double)live;
        this.logger.finest("Start ValueGC: g/l %2.0f%% (%,d/%,d); costGoal %,d; benefitGoal %,d", garbagePercent, garbage, live, gcp.costGoal, gcp.benefitGoal);
        if (gcp.forceGc) {
            this.logger.fine("Forced ValueGC due to g/l %2.0f%%", garbagePercent);
        }
        this.di.wire(new ValEvacuator(srcChunks, start)).evacuate();
        this.afterEvacuation(GcType.VALUE, srcChunks, this.valGarbage, this.valOccupancy, start, mc);
        return true;
    }

    @Override
    public boolean tombGc(MutatorCatchup mc) {
        long start = System.nanoTime();
        Collection<StableTombChunk> srcChunks = TombChunkSelector.selectTombChunksToCollect(this.chunks.values(), mc);
        if (srcChunks.isEmpty()) {
            return false;
        }
        this.snapshotter.initSrcChunkSeqs(srcChunks);
        long garbage = this.tombGarbage.get();
        long live = this.tombOccupancy.get() - garbage;
        this.logger.finest("Start TombGC: g/l %2.0f%% (%,d/%,d)", 100.0 * (double)garbage / (double)live, garbage, live);
        this.di.wire(new TombEvacuator(srcChunks)).evacuate();
        this.afterEvacuation(GcType.TOMB, srcChunks, this.tombGarbage, this.tombOccupancy, start, mc);
        return true;
    }

    private void afterEvacuation(GcType gcType, Collection<? extends StableChunk> evacuatedChunks, Counter garbage, Counter occupancy, long start, MutatorCatchup mc) {
        long sizeBefore = 0L;
        long[] evacuatedChunkSeqs = new long[evacuatedChunks.size()];
        int evacuatedChunkSeqsIdx = 0;
        for (StableChunk stableChunk : evacuatedChunks) {
            sizeBefore += stableChunk.size();
            evacuatedChunkSeqs[evacuatedChunkSeqsIdx++] = stableChunk.seq;
            mc.catchupNow();
            this.dismissGarbage(stableChunk, mc);
            stableChunk.dispose();
            this.chunks.remove(stableChunk.seq);
        }
        long sizeAfter = 0L;
        for (WriteThroughChunk survivor : this.survivors.values()) {
            sizeAfter += survivor.size();
            this.chunks.put(survivor.seq, survivor.toStableChunk());
            mc.catchupNow();
        }
        this.survivors = null;
        this.snapshotter.resetSrcChunkSeqs();
        long reclaimed = sizeBefore - sizeAfter;
        long garbageAfterGc = garbage.inc(-reclaimed);
        long liveAfterGc = occupancy.inc(-reclaimed) - garbageAfterGc;
        this.logger.fine("%nDone %sGC: took %,3d ms; b/c %3.1f g/l %2.0f%% benefit %,d cost %,d garbage %,d live %,d", (Object)gcType, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start), sizeAfter == 0L ? 0.0 : (double)reclaimed / (double)sizeAfter, 100.0 * (double)garbageAfterGc / (double)liveAfterGc, reclaimed, sizeAfter, garbageAfterGc, liveAfterGc);
        assert (garbageAfterGc >= 0L) : String.format("%s garbage went below zero: %,d", new Object[]{gcType, garbageAfterGc});
        assert (liveAfterGc >= 0L) : String.format("%s live went below zero: %,d", new Object[]{gcType, liveAfterGc});
        boolean isValueGc = GcType.VALUE.equals((Object)gcType);
        if (this.backupExecutor.inProgress()) {
            this.coordinateChunkDeletion(evacuatedChunkSeqs, isValueGc);
        } else {
            this.gcHelper.deleteChunkFiles(evacuatedChunkSeqs, isValueGc);
        }
    }

    private void coordinateChunkDeletion(long[] evacuatedChunkSeqs, boolean isValueGc) {
        long backupTaskMaxChunkSeq = this.backupExecutor.getBackupTaskMaxChunkSeq();
        for (long seq : evacuatedChunkSeqs) {
            if (seq <= backupTaskMaxChunkSeq) {
                this.chunkSeqsPendingDeletion.add(isValueGc ? seq : -seq);
                continue;
            }
            this.gcHelper.deleteChunkFile(seq, isValueGc);
        }
        if (this.backupExecutor.isBackupTaskDone()) {
            this.deletePendingChunks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deletePendingChunks() {
        if (this.chunkDeletionInProgress.compareAndSet(false, true)) {
            try {
                for (Long chunkSeq : this.chunkSeqsPendingDeletion) {
                    long seq = chunkSeq;
                    boolean valChunk = seq > 0L;
                    this.gcHelper.deleteChunkFile(valChunk ? seq : -seq, valChunk);
                }
                this.chunkSeqsPendingDeletion.clear();
            }
            finally {
                this.chunkDeletionInProgress.set(false);
            }
        }
    }

    @Override
    public boolean removeChunkPendingDeletion(long seq, boolean isValChunk) {
        return this.chunkSeqsPendingDeletion.remove(isValChunk ? seq : -seq);
    }

    @Override
    public boolean isChunkPendingDeletion(long seq, boolean isValChunk) {
        return this.chunkSeqsPendingDeletion.contains(isValChunk ? seq : -seq);
    }

    private static enum GcType {
        VALUE("Value"),
        TOMB("Tomb");

        private final String desc;

        private GcType(String desc) {
            this.desc = desc;
        }

        public String toString() {
            return this.desc;
        }
    }
}

