/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl.di;

import com.hazelcast.internal.hotrestart.impl.di.DiException;
import com.hazelcast.internal.hotrestart.impl.di.Initialize;
import com.hazelcast.internal.hotrestart.impl.di.Inject;
import com.hazelcast.internal.hotrestart.impl.di.Name;
import com.hazelcast.internal.nio.Disposable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public final class DiContainer
implements Disposable {
    private final DiContainer parent;
    private final Map<Class<?>, Object> depsByType = new HashMap();
    private final Map<String, Object> depsByName = new HashMap<String, Object>();
    private final List<Disposable> disposables = new ArrayList<Disposable>();
    private List<Object> initOrder = new ArrayList<Object>();
    private Object lastDep;

    public DiContainer() {
        this(null);
    }

    public DiContainer(DiContainer parent) {
        this.parent = parent;
    }

    public DiContainer dep(Object dep) {
        if (dep instanceof Class) {
            Class clazz = (Class)dep;
            return this.dep(clazz);
        }
        Class<?> type = dep.getClass();
        this.depsByType.put(type, dep);
        this.onRegistration(dep);
        return this;
    }

    public <T> DiContainer dep(Class<? super T> declaredType, T dep) {
        this.depsByType.put(declaredType, declaredType.cast(dep));
        this.onRegistration(dep);
        return this;
    }

    public <T> DiContainer dep(String name, T dep) {
        this.depsByName.put(name, dep);
        this.onRegistration(dep);
        return this;
    }

    public DiContainer dep(Class<?> type) {
        Object dep = this.instantiate(type);
        this.depsByType.put(type, dep);
        this.onRegistration(dep);
        return this;
    }

    public <T> DiContainer dep(Class<? super T> declaredType, Class<T> actualType) {
        T dep = declaredType.cast(this.instantiate(actualType));
        this.depsByType.put(declaredType, dep);
        this.onRegistration(dep);
        return this;
    }

    public DiContainer dep(String name, Class<?> type) {
        Object dep = this.instantiate(type);
        this.depsByName.put(name, dep);
        this.onRegistration(dep);
        return this;
    }

    public DiContainer disposable() {
        this.disposable((Disposable)this.lastDep);
        return this;
    }

    public DiContainer disposable(Disposable target) {
        this.disposables.add(target);
        return this;
    }

    public <T> T instantiate(Class<T> type) {
        for (Constructor<?> c : type.getDeclaredConstructors()) {
            if (c.getAnnotation(Inject.class) == null) continue;
            return (T)DiContainer.newInstance(c, this.resolveDepArgs(c.getParameterTypes(), c.getParameterAnnotations()));
        }
        throw new DiException("No constructor annotated with @Inject in " + type.getName());
    }

    public <T> T wire(T target) {
        for (Class<?> type = target.getClass(); type != null; type = type.getSuperclass()) {
            this.injectFields(target, type);
            this.injectMethods(target, type);
        }
        return target;
    }

    public void initialize(Object target) {
        for (Method m : target.getClass().getDeclaredMethods()) {
            if (m.getAnnotation(Initialize.class) == null) continue;
            DiContainer.invoke(target, m, this.resolveDepArgs(m.getParameterTypes(), m.getParameterAnnotations()));
        }
    }

    public DiContainer wireAndInitializeAll() {
        if (this.initOrder == null) {
            throw new DiException("Container already initialized");
        }
        for (Object target : this.initOrder) {
            this.wire(target);
        }
        for (Object target : this.initOrder) {
            this.initialize(target);
        }
        this.initOrder = null;
        return this;
    }

    public Object invoke(Object target, String methodName) {
        Method m = DiContainer.findMethod(target, methodName);
        m.setAccessible(true);
        return DiContainer.invoke(target, m, this.resolveDepArgs(m.getParameterTypes(), m.getParameterAnnotations()));
    }

    public <T> T get(Class<T> t) {
        Object localDep = this.depsByType.get(t);
        if (localDep == null) {
            if (this.parent == null) {
                return null;
            }
            return this.parent.get(t);
        }
        return t.cast(localDep);
    }

    public Object get(String name) {
        Object localDep = this.depsByName.get(name);
        if (localDep == null) {
            if (this.parent == null) {
                return null;
            }
            return this.parent.get(name);
        }
        return localDep;
    }

    public <T> T get(String name, Class<T> type) {
        return type.cast(this.get(name));
    }

    @Override
    public void dispose() {
        ListIterator<Disposable> iterator = this.disposables.listIterator(this.disposables.size());
        while (iterator.hasPrevious()) {
            iterator.previous().dispose();
        }
    }

    private void onRegistration(Object target) {
        this.lastDep = target;
        if (this.initOrder != null) {
            this.initOrder.add(target);
        } else {
            this.initialize(this.wire(target));
        }
    }

    private <T> T resolveDependency(Name nameAnnotation, Class<T> targetType) {
        if (nameAnnotation != null) {
            String name = nameAnnotation.value();
            T dep = targetType.cast(this.get(name));
            if (dep == null) {
                throw new DiException(String.format("Couldn't resolve dep with name '%s'", name));
            }
            return dep;
        }
        T byType = this.get(targetType);
        if (byType == null) {
            throw new DiException(String.format("Couldn't resolve dep with type %s", targetType.getName()));
        }
        return byType;
    }

    private Object[] resolveDepArgs(Class<?>[] parameterTypes, Annotation[][] paramAnns) {
        Object[] args = new Object[parameterTypes.length];
        int i = 0;
        for (Class<?> t : parameterTypes) {
            args[i] = this.resolveDependency(DiContainer.findAnnotation(paramAnns[i], Name.class), t);
            ++i;
        }
        return args;
    }

    private static <T> T findAnnotation(Annotation[] anns, Class<T> annType) {
        for (Annotation ann : anns) {
            if (!annType.isAssignableFrom(ann.getClass())) continue;
            return annType.cast(ann);
        }
        return null;
    }

    private void injectFields(Object target, Class<?> type) {
        for (Field f : type.getDeclaredFields()) {
            if (f.getAnnotation(Inject.class) == null) continue;
            DiContainer.setField(target, f, this.resolveDependency(f.getAnnotation(Name.class), f.getType()));
        }
    }

    private void injectMethods(Object target, Class<?> type) {
        for (Method m : type.getDeclaredMethods()) {
            if (m.getAnnotation(Inject.class) == null) continue;
            DiContainer.invoke(target, m, this.resolveDepArgs(m.getParameterTypes(), m.getParameterAnnotations()));
        }
    }

    private static void setField(Object target, Field field, Object value) {
        field.setAccessible(true);
        try {
            field.set(target, value);
        }
        catch (IllegalAccessException e) {
            throw new DiException("Dependency injection failed", e);
        }
    }

    private static Object invoke(Object target, Method method, Object[] args) {
        method.setAccessible(true);
        try {
            return method.invoke(target, args);
        }
        catch (IllegalAccessException e) {
            throw new DiException("Dependency injection failed", e);
        }
        catch (InvocationTargetException e) {
            throw new DiException("Dependency injection failed", e.getCause());
        }
    }

    private static Method findMethod(Object target, String methodName) {
        for (Method m : target.getClass().getDeclaredMethods()) {
            if (!m.getName().equals(methodName)) continue;
            return m;
        }
        throw new DiException(String.format("Method lookup failed: %s#%s()", target.getClass().getName(), methodName));
    }

    private static <T> T newInstance(Constructor<T> cxor, Object[] args) {
        cxor.setAccessible(true);
        try {
            return cxor.newInstance(args);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new DiException("Instantiation failed", e);
        }
        catch (InvocationTargetException e) {
            throw new DiException("Instantiation failed", e.getCause());
        }
    }
}

