/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl;

import com.hazelcast.hotrestart.HotRestartException;
import com.hazelcast.internal.hotrestart.RamStoreRegistry;
import com.hazelcast.internal.hotrestart.impl.RestartItem;
import com.hazelcast.internal.hotrestart.impl.SetOfKeyHandle;
import com.hazelcast.internal.util.BiTuple;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.concurrent.BackoffIdleStrategy;
import com.hazelcast.internal.util.concurrent.ConcurrentConveyor;
import com.hazelcast.internal.util.concurrent.ConcurrentConveyorSingleQueue;
import com.hazelcast.internal.util.concurrent.IdleStrategy;
import com.hazelcast.internal.util.concurrent.OneToOneConcurrentArrayQueue;
import com.hazelcast.internal.util.concurrent.QueuedPipe;
import com.hazelcast.logging.ILogger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.TimeUnit;

public class RamStoreRestartLoop {
    public static final int QUEUE_CAPACITY_BUDGET = 4096;
    public static final int MIN_QUEUE_CAPACITY = 8;
    public static final int SPIN_COUNT = 1;
    public static final int YIELD_COUNT = 1;
    public static final long MAX_PARK_MICROS = 10L;
    public static final IdleStrategy DRAIN_IDLER = new BackoffIdleStrategy(1L, 1L, 1L, TimeUnit.MICROSECONDS.toNanos(10L));
    public final ConcurrentConveyorSingleQueue<RestartItem>[][] keyReceivers;
    public final ConcurrentConveyor<RestartItem>[] keyHandleSenders;
    public final ConcurrentConveyorSingleQueue<RestartItem>[][] valueReceivers;
    private final RestartItem keySubmitterGone;
    private final RestartItem.WithSetOfKeyHandle valueSubmitterGone;
    private final RamStoreRegistry reg;
    private final ILogger logger;
    private boolean submitterGoneSent;

    public RamStoreRestartLoop(int storeCount, int threadCount, RamStoreRegistry reg, ILogger logger) {
        this.reg = reg;
        this.logger = logger;
        this.keyReceivers = RamStoreRestartLoop.makeSingleQueueConveyors(storeCount, threadCount);
        this.keyHandleSenders = RamStoreRestartLoop.makeMultiQueueConveyors(storeCount, threadCount);
        this.valueReceivers = RamStoreRestartLoop.makeSingleQueueConveyors(storeCount, threadCount);
        this.keySubmitterGone = (RestartItem)this.keyReceivers[0][0].submitterGoneItem();
        this.valueSubmitterGone = (RestartItem.WithSetOfKeyHandle)this.valueReceivers[0][0].submitterGoneItem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run(int threadIndex) {
        int storeCount = this.keyHandleSenders.length;
        int remainder = threadIndex % storeCount;
        int quotient = threadIndex / storeCount;
        ConcurrentConveyorSingleQueue<RestartItem> keyReceiver = this.keyReceivers[remainder][quotient];
        ConcurrentConveyor<RestartItem> keyHandleSender = this.keyHandleSenders[remainder];
        QueuedPipe<RestartItem> keyHandleSendQ = keyHandleSender.queue(quotient);
        ConcurrentConveyorSingleQueue<RestartItem> valueReceiver = this.valueReceivers[remainder][quotient];
        try {
            keyReceiver.drainerArrived();
            valueReceiver.drainerArrived();
            this.mainLoop(threadIndex, keyReceiver, keyHandleSender, keyHandleSendQ, valueReceiver);
            keyReceiver.drainerDone();
            valueReceiver.drainerDone();
        }
        catch (Throwable t) {
            keyReceiver.drainerFailed(t);
            valueReceiver.drainerFailed(t);
            ExceptionUtil.sneakyThrow(t);
        }
        finally {
            this.ensureSubmitterGoneSent(keyHandleSender, keyHandleSendQ);
        }
    }

    private void mainLoop(int threadIndex, ConcurrentConveyor<RestartItem> keyReceiver, ConcurrentConveyor<RestartItem> keyHandleSender, QueuedPipe<RestartItem> sendQ, ConcurrentConveyor<RestartItem> valueReceiver) {
        int capacity = keyReceiver.queue(0).capacity();
        ArrayDeque keyBatch = new ArrayDeque(capacity);
        ArrayList valueBatch = new ArrayList(capacity);
        RestartItem keyHandleSubmitterGoneItem = keyHandleSender.submitterGoneItem();
        RestartItem danglingDownstreamItem = null;
        long idleCount = 0L;
        boolean didWork = true;
        long keyCount = 0L;
        long keyDrainCount = 0L;
        block0: while (true) {
            RestartItem downstreamItem;
            if (Thread.currentThread().isInterrupted()) {
                throw new HotRestartException("Thread interrupted inside RamStoreRestartLoop");
            }
            if (didWork) {
                idleCount = 0L;
            } else {
                DRAIN_IDLER.idle(idleCount++);
            }
            didWork = false;
            valueBatch.clear();
            valueReceiver.drainTo(valueBatch);
            for (RestartItem item : valueBatch) {
                if (this.consumeValueItem(item)) break block0;
                didWork = true;
            }
            int count = keyReceiver.drainTo(keyBatch, capacity - keyBatch.size());
            if (count > 0) {
                keyCount += (long)count;
                ++keyDrainCount;
            }
            if (danglingDownstreamItem != null) {
                if (!keyHandleSender.offer(sendQ, danglingDownstreamItem)) continue;
                danglingDownstreamItem = null;
            }
            do {
                RestartItem item;
                if ((item = (RestartItem)keyBatch.pollFirst()) == null) continue block0;
                downstreamItem = this.consumeKeyItem(item, keyHandleSubmitterGoneItem);
                didWork = true;
            } while (keyHandleSender.offer(sendQ, downstreamItem));
            danglingDownstreamItem = downstreamItem;
        }
        this.logger.fine(String.format("threadIndex %d: drained %,d items, mean queue size was %.1f (capacity %,d)", threadIndex, keyCount, (double)keyCount / (double)keyDrainCount, capacity));
    }

    private RestartItem consumeKeyItem(RestartItem item, RestartItem keyHandleSubmitterGoneItem) {
        if (!item.isSpecialItem()) {
            item.ramStore = this.reg.restartingRamStoreForPrefix(item.prefix);
            if (item.ramStore == null) {
                BiTuple<String, String> description = this.reg.describe(item.prefix);
                throw new HotRestartException("Recovery cannot proceed: persistence is not enabled for " + (String)description.element1 + " while it was previously configured as persistent. To allow recovery to complete, you can do one of the following:\n - " + (String)description.element2 + "\n - delete all persistent data to restart with a clear cluster");
            }
            item.keyHandle = item.ramStore.toKeyHandle(item.key);
            return item;
        }
        if (item.isClearedItem()) {
            return item;
        }
        assert (item == this.keySubmitterGone);
        this.submitterGoneSent = true;
        return keyHandleSubmitterGoneItem;
    }

    private boolean consumeValueItem(RestartItem item) {
        if (!item.isSpecialItem()) {
            item.ramStore.accept(item.keyHandle, item.value);
            return false;
        }
        if (item.isClearedItem()) {
            return false;
        }
        if (item == this.valueSubmitterGone) {
            return true;
        }
        SetOfKeyHandle sokh = ((RestartItem.WithSetOfKeyHandle)item).sokh;
        this.reg.ramStoreForPrefix(item.prefix).removeNullEntries(sokh);
        return false;
    }

    private static ConcurrentConveyor<RestartItem>[] makeMultiQueueConveyors(int storeCount, int threadCount) {
        ConcurrentConveyor[] conveyors = new ConcurrentConveyor[storeCount];
        QueueParams qp = new QueueParams(storeCount, threadCount);
        for (int storeIndex = 0; storeIndex < storeCount; ++storeIndex) {
            conveyors[storeIndex] = ConcurrentConveyor.concurrentConveyor(RestartItem.END, qp.makeQueues(storeIndex));
        }
        return conveyors;
    }

    private static ConcurrentConveyorSingleQueue<RestartItem>[][] makeSingleQueueConveyors(int storeCount, int threadCount) {
        ConcurrentConveyorSingleQueue[][] conveyorArrays = new ConcurrentConveyorSingleQueue[storeCount][];
        QueueParams qp = new QueueParams(storeCount, threadCount);
        for (int storeIndex = 0; storeIndex < conveyorArrays.length; ++storeIndex) {
            int submitterCount = qp.submitterCount(storeIndex);
            ConcurrentConveyorSingleQueue[] conveyors = new ConcurrentConveyorSingleQueue[submitterCount];
            for (int submitterIndex = 0; submitterIndex < submitterCount; ++submitterIndex) {
                conveyors[submitterIndex] = ConcurrentConveyorSingleQueue.concurrentConveyorSingleQueue(RestartItem.END, new OneToOneConcurrentArrayQueue(qp.queueCapacity));
            }
            conveyorArrays[storeIndex] = conveyors;
        }
        return conveyorArrays;
    }

    private void ensureSubmitterGoneSent(ConcurrentConveyor<RestartItem> conveyor, Queue<RestartItem> queue) {
        if (!this.submitterGoneSent) {
            try {
                conveyor.submit(queue, conveyor.submitterGoneItem());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class QueueParams {
        final int queueCapacity;
        private final int quotient;
        private final int remainder;

        QueueParams(int storeCount, int threadCount) {
            this.queueCapacity = Math.max(4096 / (threadCount / storeCount), 8);
            int maxThreadIndex = threadCount - 1;
            this.quotient = maxThreadIndex / storeCount;
            this.remainder = maxThreadIndex % storeCount;
        }

        int submitterCount(int storeIndex) {
            return this.quotient + (storeIndex <= this.remainder ? 1 : 0);
        }

        OneToOneConcurrentArrayQueue<RestartItem>[] makeQueues(int storeIndex) {
            OneToOneConcurrentArrayQueue[] qs = new OneToOneConcurrentArrayQueue[this.submitterCount(storeIndex)];
            for (int i = 0; i < qs.length; ++i) {
                qs[i] = new OneToOneConcurrentArrayQueue(this.queueCapacity);
            }
            return qs;
        }
    }
}

