/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.cluster;

import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.hotrestart.cluster.ClusterMetadataManager;
import com.hazelcast.internal.serialization.impl.compact.Schema;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;

public class CompactSchemaPersistenceManager {
    private final Object mutex = new Object();
    private final Set<Long> persistedSchemas = ConcurrentHashMap.newKeySet();
    private final ConcurrentHashMap<Long, DeregistratingFuture> inFlightOperations = new ConcurrentHashMap();
    private final ClusterMetadataManager metadataManager;
    private final Node node;

    public CompactSchemaPersistenceManager(Node node, ClusterMetadataManager metadataManager) {
        this.node = node;
        this.metadataManager = metadataManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalCompletableFuture<Void> persist(Schema schema) {
        long schemaId = schema.getSchemaId();
        if (this.persistedSchemas.contains(schemaId)) {
            return InternalCompletableFuture.newCompletedFuture(null);
        }
        DeregistratingFuture future = this.inFlightOperations.get(schemaId);
        if (future != null) {
            return future;
        }
        Object object = this.mutex;
        synchronized (object) {
            if (this.persistedSchemas.contains(schemaId)) {
                return InternalCompletableFuture.newCompletedFuture(null);
            }
            future = this.inFlightOperations.get(schemaId);
            if (future != null) {
                return future;
            }
            future = new DeregistratingFuture(schemaId);
            this.inFlightOperations.put(schemaId, future);
        }
        Collection<Schema> schemas = this.node.getSchemaService().getAllSchemas();
        this.metadataManager.writeCompactSchemas(schemas, future);
        return future;
    }

    public void markPersistedSchemas(Collection<Schema> schemas) {
        for (Schema schema : schemas) {
            this.persistedSchemas.add(schema.getSchemaId());
        }
    }

    public void persistAll(Collection<Schema> schemas) {
        ArrayList<Long> notYetPersistedSchemas = new ArrayList<Long>();
        for (Schema schema : schemas) {
            long schemaId = schema.getSchemaId();
            if (this.persistedSchemas.contains(schemaId)) continue;
            assert (!this.inFlightOperations.containsKey(schemaId));
            notYetPersistedSchemas.add(schemaId);
        }
        if (notYetPersistedSchemas.isEmpty()) {
            return;
        }
        InternalCompletableFuture<Void> future = new InternalCompletableFuture<Void>();
        Collection<Schema> allSchemas = this.node.getSchemaService().getAllSchemas();
        this.metadataManager.writeCompactSchemas(allSchemas, future);
        ((CompletableFuture)future.whenCompleteAsync((result, exception) -> {
            if (exception == null) {
                this.persistedSchemas.addAll(notYetPersistedSchemas);
            }
        }, ConcurrencyUtil.CALLER_RUNS)).join();
    }

    private final class DeregistratingFuture
    extends InternalCompletableFuture<Void> {
        private final long schemaId;

        DeregistratingFuture(long schemaId) {
            this.schemaId = schemaId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean complete(Void value) {
            Object object = CompactSchemaPersistenceManager.this.mutex;
            synchronized (object) {
                CompactSchemaPersistenceManager.this.persistedSchemas.add(this.schemaId);
                CompactSchemaPersistenceManager.this.inFlightOperations.remove(this.schemaId, this);
            }
            return super.complete(value);
        }

        @Override
        public boolean completeExceptionally(Throwable ex) {
            CompactSchemaPersistenceManager.this.inFlightOperations.remove(this.schemaId, this);
            return super.completeExceptionally(ex);
        }
    }
}

