/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.cluster;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.impl.MemberImpl;
import com.hazelcast.config.HotRestartClusterDataRecoveryPolicy;
import com.hazelcast.internal.hotrestart.cluster.ClusterMetadataManager;
import com.hazelcast.internal.hotrestart.cluster.HotRestartClusterStartStatus;
import com.hazelcast.internal.hotrestart.cluster.MemberClusterStartInfo;
import com.hazelcast.internal.management.dto.ClusterHotRestartStatusDTO;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class ClusterHotRestartStatusDTOUtil {
    private ClusterHotRestartStatusDTOUtil() {
    }

    public static ClusterHotRestartStatusDTO create(ClusterMetadataManager clusterMetadataManager) {
        HotRestartClusterDataRecoveryPolicy dataRecoveryPolicy = clusterMetadataManager.getClusterDataRecoveryPolicy();
        ClusterHotRestartStatusDTO.ClusterHotRestartStatus hotRestartStatus = ClusterHotRestartStatusDTOUtil.getClusterHotRestartStatus(clusterMetadataManager);
        long remainingValidationTimeMillis = clusterMetadataManager.getRemainingValidationTimeMillis();
        long remainingDataLoadTimeMillis = clusterMetadataManager.getRemainingDataLoadTimeMillis();
        Map<String, ClusterHotRestartStatusDTO.MemberHotRestartStatus> memberHotRestartStatusMap = ClusterHotRestartStatusDTOUtil.getMemberHotRestartStatusMap(clusterMetadataManager);
        return new ClusterHotRestartStatusDTO(dataRecoveryPolicy, hotRestartStatus, remainingValidationTimeMillis, remainingDataLoadTimeMillis, memberHotRestartStatusMap);
    }

    private static Map<String, ClusterHotRestartStatusDTO.MemberHotRestartStatus> getMemberHotRestartStatusMap(ClusterMetadataManager clusterMetadataManager) {
        Collection<MemberImpl> restoredMembers = clusterMetadataManager.getRestoredMembers();
        HashMap<String, ClusterHotRestartStatusDTO.MemberHotRestartStatus> memberHotRestartStatusMap = new HashMap<String, ClusterHotRestartStatusDTO.MemberHotRestartStatus>(restoredMembers.size());
        for (MemberImpl member : restoredMembers) {
            Address address = member.getAddress();
            memberHotRestartStatusMap.put(address.getHost() + ":" + address.getPort(), ClusterHotRestartStatusDTOUtil.getMemberHotRestartStatus(clusterMetadataManager, member));
        }
        return memberHotRestartStatusMap;
    }

    private static ClusterHotRestartStatusDTO.MemberHotRestartStatus getMemberHotRestartStatus(ClusterMetadataManager clusterMetadataManager, MemberImpl member) {
        MemberClusterStartInfo.DataLoadStatus dataLoadStatus = clusterMetadataManager.getMemberDataLoadStatus(member);
        if (dataLoadStatus == null) {
            return clusterMetadataManager.getHotRestartStatus() == HotRestartClusterStartStatus.CLUSTER_START_SUCCEEDED ? ClusterHotRestartStatusDTO.MemberHotRestartStatus.SUCCESSFUL : ClusterHotRestartStatusDTO.MemberHotRestartStatus.PENDING;
        }
        switch (dataLoadStatus) {
            case LOAD_IN_PROGRESS: {
                return ClusterHotRestartStatusDTO.MemberHotRestartStatus.LOAD_IN_PROGRESS;
            }
            case LOAD_SUCCESSFUL: {
                return ClusterHotRestartStatusDTO.MemberHotRestartStatus.SUCCESSFUL;
            }
            case LOAD_FAILED: {
                return ClusterHotRestartStatusDTO.MemberHotRestartStatus.FAILED;
            }
        }
        throw new IllegalArgumentException("Unknown status: " + String.valueOf((Object)dataLoadStatus));
    }

    private static ClusterHotRestartStatusDTO.ClusterHotRestartStatus getClusterHotRestartStatus(ClusterMetadataManager clusterMetadataManager) {
        HotRestartClusterStartStatus clusterStartStatus = clusterMetadataManager.getHotRestartStatus();
        switch (clusterStartStatus) {
            case CLUSTER_START_IN_PROGRESS: {
                return ClusterHotRestartStatusDTO.ClusterHotRestartStatus.IN_PROGRESS;
            }
            case CLUSTER_START_SUCCEEDED: {
                return ClusterHotRestartStatusDTO.ClusterHotRestartStatus.SUCCEEDED;
            }
            case CLUSTER_START_FAILED: {
                return ClusterHotRestartStatusDTO.ClusterHotRestartStatus.FAILED;
            }
        }
        throw new IllegalArgumentException("Unknown status: " + String.valueOf((Object)clusterStartStatus));
    }
}

