/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.backup;

import com.hazelcast.cluster.Address;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.internal.hotrestart.HotBackupService;
import com.hazelcast.internal.hotrestart.backup.HotRestartBackupSerializerHook;
import com.hazelcast.internal.util.EmptyStatement;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.spi.impl.AllowedDuringPassiveState;
import com.hazelcast.spi.impl.operationservice.ExceptionAction;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.impl.Transaction;
import java.io.IOException;
import java.util.UUID;

public class HotRestartBackupOperation
extends Operation
implements AllowedDuringPassiveState,
IdentifiedDataSerializable {
    private String transactionPhaseName;
    private Transaction.State transactionPhase;
    private long backupSeq;
    private Address initiator;
    private UUID txnId;
    private long leaseTime;

    public HotRestartBackupOperation() {
    }

    private HotRestartBackupOperation(Transaction.State transactionPhase, long backupSeq, Address initiator, UUID txnId, long leaseTime) {
        this.transactionPhase = transactionPhase;
        this.backupSeq = backupSeq;
        this.initiator = initiator;
        this.txnId = txnId;
        this.leaseTime = leaseTime;
    }

    public static HotRestartBackupOperation prepareOperation(Address initiator, UUID txnId, long leaseTime) {
        return new HotRestartBackupOperation(Transaction.State.PREPARING, 0L, initiator, txnId, leaseTime);
    }

    public static HotRestartBackupOperation commitOperation(long backupSeq, Address initiator, UUID txnId) {
        return new HotRestartBackupOperation(Transaction.State.COMMITTING, backupSeq, initiator, txnId, 0L);
    }

    public static HotRestartBackupOperation rollbackOperation(Address initiator, UUID txnId) {
        return new HotRestartBackupOperation(Transaction.State.ROLLING_BACK, 0L, initiator, txnId, 0L);
    }

    @Override
    public void beforeRun() throws Exception {
        if (this.transactionPhase == null || this.transactionPhase != Transaction.State.PREPARING && this.transactionPhase != Transaction.State.COMMITTING && this.transactionPhase != Transaction.State.ROLLING_BACK) {
            throw new IllegalArgumentException("Transaction phase is not allowed: " + this.transactionPhaseName);
        }
    }

    @Override
    public void run() throws Exception {
        HotBackupService service = (HotBackupService)this.getService();
        switch (this.transactionPhase) {
            case PREPARING: {
                service.prepareBackup(this.initiator, this.txnId, this.leaseTime);
                break;
            }
            case COMMITTING: {
                service.commitBackup(this.backupSeq, this.initiator, this.txnId);
                break;
            }
            case ROLLING_BACK: {
                this.getLogger().info("Rolling back cluster state! Initiator: " + String.valueOf(this.initiator));
                service.rollbackBackup(this.txnId);
                break;
            }
            default: {
                throw new IllegalArgumentException("Transaction phase is not allowed: " + String.valueOf((Object)this.transactionPhase));
            }
        }
    }

    @Override
    public void logError(Throwable e) {
        if (e instanceof TransactionException) {
            this.getLogger().severe(e.getMessage());
        } else {
            super.logError(e);
        }
    }

    @Override
    public ExceptionAction onInvocationException(Throwable throwable) {
        if (throwable instanceof MemberLeftException || throwable instanceof TargetNotMemberException) {
            return ExceptionAction.THROW_EXCEPTION;
        }
        return super.onInvocationException(throwable);
    }

    @Override
    public String getServiceName() {
        return "hz:ee:internalHotBackupService";
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeString(this.transactionPhase.toString());
        out.writeLong(this.backupSeq);
        out.writeObject(this.initiator);
        UUIDSerializationUtil.writeUUID(out, this.txnId);
        out.writeLong(this.leaseTime);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.transactionPhaseName = in.readString();
        try {
            this.transactionPhase = Transaction.State.valueOf(this.transactionPhaseName);
        }
        catch (IllegalArgumentException ignored) {
            EmptyStatement.ignore(ignored);
        }
        this.backupSeq = in.readLong();
        this.initiator = (Address)in.readObject();
        this.txnId = UUIDSerializationUtil.readUUID(in);
        this.leaseTime = in.readLong();
    }

    @Override
    public int getFactoryId() {
        return HotRestartBackupSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 1;
    }
}

