/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hidensity.impl;

import com.hazelcast.internal.hidensity.HiDensityRecord;
import com.hazelcast.internal.hidensity.HiDensityRecordAccessor;
import com.hazelcast.internal.memory.HazelcastMemoryManager;
import com.hazelcast.internal.memory.MemoryBlock;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;

public abstract class AbstractHiDensityRecordAccessor<R extends HiDensityRecord>
implements HiDensityRecordAccessor<R> {
    protected final EnterpriseSerializationService ss;
    protected final HazelcastMemoryManager memoryManager;

    public AbstractHiDensityRecordAccessor(EnterpriseSerializationService ss, HazelcastMemoryManager memoryManager) {
        this.ss = ss;
        this.memoryManager = memoryManager;
    }

    protected abstract R createRecord();

    @Override
    public abstract boolean isEqual(long var1, long var3);

    @Override
    public boolean isEqual(long address, R value) {
        return this.isEqual(address, ((MemoryBlock)value).address());
    }

    @Override
    public R newRecord() {
        return this.createRecord();
    }

    @Override
    public R read(long address) {
        if (address == 0L) {
            throw new IllegalArgumentException("Illegal memory address: " + address);
        }
        R record = this.newRecord();
        ((HiDensityRecord)record).reset(address);
        return record;
    }

    @Override
    public long dispose(R record) {
        if (((MemoryBlock)record).address() == 0L) {
            throw new IllegalArgumentException("Illegal memory address: " + ((MemoryBlock)record).address());
        }
        long size = 0L;
        size += this.disposeValue(record);
        ((HiDensityRecord)record).clear();
        this.memoryManager.free(((MemoryBlock)record).address(), ((MemoryBlock)record).size());
        ((HiDensityRecord)record).reset(0L);
        return size += this.getSize((MemoryBlock)record);
    }

    @Override
    public long dispose(long address) {
        return this.dispose((R)this.read(address));
    }

    @Override
    public NativeMemoryData readData(long valueAddress) {
        if (valueAddress == 0L) {
            throw new IllegalArgumentException("Illegal memory address: " + valueAddress);
        }
        return new NativeMemoryData().reset(valueAddress);
    }

    @Override
    public Object readValue(R record) {
        NativeMemoryData nativeMemoryData = this.readData(((HiDensityRecord)record).getValueAddress());
        return this.ss.toObject((Object)nativeMemoryData, this.memoryManager);
    }

    @Override
    public long readValueAddress(R record) {
        return ((MemoryBlock)record).readLong(0L);
    }

    @Override
    public void setValueAddress(R record, long address) {
        ((MemoryBlock)record).writeLong(0L, address);
    }

    @Override
    public void setValue(R record, Data value) {
        if (value == null) {
            this.setValueAddress(record, 0L);
            return;
        }
        assert (value instanceof NativeMemoryData) : "Parameter `value` should be a type of [" + String.valueOf(NativeMemoryData.class) + "], but found [" + String.valueOf(value) + "]";
        ((HiDensityRecord)record).setValueAddress(((NativeMemoryData)value).address());
    }

    @Override
    public long disposeValue(R record) {
        long valueAddress = ((HiDensityRecord)record).getValueAddress();
        long size = 0L;
        if (valueAddress != 0L) {
            size = this.disposeData(valueAddress);
            ((HiDensityRecord)record).setValueAddress(0L);
        }
        return size;
    }

    @Override
    public long disposeData(NativeMemoryData value) {
        if (value.address() == 0L) {
            throw new IllegalArgumentException("Illegal memory address: " + value.address());
        }
        long size = this.getSize(value);
        this.ss.disposeData(value, this.memoryManager);
        return size;
    }

    @Override
    public long disposeData(long address) {
        return this.disposeData(this.readData(address));
    }

    @Override
    public long getSize(MemoryBlock memoryBlock) {
        if (memoryBlock == null || memoryBlock.address() == 0L) {
            return 0L;
        }
        long size = this.memoryManager.getAllocatedSize(memoryBlock.address());
        if (size == -1L) {
            size = memoryBlock.size();
        }
        return size;
    }

    @Override
    public long getSize(long address, long expectedSize) {
        if (address == 0L) {
            throw new IllegalArgumentException("Illegal memory address: " + address);
        }
        long size = this.memoryManager.getAllocatedSize(address);
        if (size == -1L) {
            size = expectedSize;
        }
        return size;
    }
}

