/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.elastic.util;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.memory.MemoryBlock;
import com.hazelcast.internal.nio.Disposable;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import com.hazelcast.internal.serialization.impl.NativeMemoryDataUtil;

public final class DisposalUtil {
    private DisposalUtil() {
    }

    public static void dispose(EnterpriseSerializationService ess, MemoryAllocator malloc, Object object) {
        block6: {
            if (object == null) {
                return;
            }
            try {
                if (object instanceof Disposable) {
                    ((Disposable)object).dispose();
                    break block6;
                }
                if (object instanceof NativeMemoryData) {
                    NativeMemoryDataUtil.dispose(ess, malloc, (NativeMemoryData)object);
                    break block6;
                }
                if (object instanceof MemoryBlock) {
                    NativeMemoryDataUtil.dispose(ess, malloc, (MemoryBlock)object);
                    break block6;
                }
                throw new IllegalStateException("Unidentifiable object, don't know how to dispose. May cause leaks.");
            }
            catch (Exception exception) {
                throw new HazelcastException("Could not deallocate memory. There may be a native memory leak!", exception);
            }
        }
    }

    public static void dispose(EnterpriseSerializationService ess, MemoryAllocator malloc, Object ... objects) {
        HazelcastException caught = null;
        for (Object object : objects) {
            try {
                DisposalUtil.dispose(ess, malloc, object);
            }
            catch (HazelcastException exception) {
                caught = exception;
            }
            if (caught == null) continue;
            throw caught;
        }
    }
}

