/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.elastic.tree.impl;

import com.hazelcast.internal.elastic.tree.OffHeapTreeEntry;
import com.hazelcast.internal.elastic.tree.impl.EntryValuesIterator;
import com.hazelcast.internal.elastic.tree.impl.RedBlackTreeStore;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.memory.MemoryBlock;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.memory.NativeOutOfMemoryError;
import java.util.Iterator;

class RedBlackTreeNode
extends MemoryBlock {
    static final byte RED = 1;
    static final byte BLACK = 0;
    static final byte LEFT = 1;
    static final byte RIGHT = 0;
    private static final int LEFT_LEAF_OFFSET = 0;
    private static final int RIGHT_LEAF_OFFSET = 8;
    private static final int ENTRY_KEY_OFFSET = 16;
    private static final int ENTRY_KEY_SZ_OFFSET = 24;
    private static final int ENTRY_VALUE_OFFSET = 28;
    private static final int PARENT_OFFSET = 36;
    private static final int SIDE_OFFSET = 44;
    private static final int COLOR_OFFSET = 45;
    private static final int NODE_SIZE = 46;
    private final RedBlackTreeStore tree;
    private final MemoryAllocator malloc;

    private RedBlackTreeNode(RedBlackTreeStore tree, MemoryAllocator malloc, long address) {
        super(address, 46);
        this.tree = tree;
        this.malloc = malloc;
    }

    RedBlackTreeNode() {
        super(0L, 46);
        this.tree = null;
        this.malloc = null;
    }

    public OffHeapTreeEntry entry() {
        if (this.address == 0L) {
            throw new IllegalStateException("NULL address; ie. Sentinel node");
        }
        return new Entry();
    }

    RedBlackTreeNode parent() {
        long addr;
        if (this.address == 0L || (addr = this.readLong(36L)) == 0L) {
            return null;
        }
        return RedBlackTreeNode.of(this.tree, this.malloc, addr);
    }

    void parent(RedBlackTreeNode node) {
        assert (this.address != 0L);
        if (node == null) {
            this.writeLong(36L, 0L);
            return;
        }
        assert (node.address != this.address) : "Detected circular reference: " + this.address;
        this.writeLong(36L, node.address);
    }

    RedBlackTreeNode left() {
        return RedBlackTreeNode.of(this.tree, this.malloc, this.leftAddress());
    }

    long leftAddress() {
        assert (this.address != 0L);
        return this.readLong(0L);
    }

    void left(RedBlackTreeNode node) {
        assert (this.address != 0L);
        assert (node.address != this.address) : "Detected circular reference: " + this.address;
        this.writeLong(0L, node.address);
        if (!node.isNil()) {
            node.side((byte)1);
        }
    }

    RedBlackTreeNode right() {
        return RedBlackTreeNode.of(this.tree, this.malloc, this.rightAddress());
    }

    long rightAddress() {
        assert (this.address != 0L);
        return this.readLong(8L);
    }

    void right(RedBlackTreeNode node) {
        assert (this.address != 0L);
        assert (node.address != this.address) : "Detected circular reference: " + this.address;
        this.writeLong(8L, node.address);
        if (!node.isNil()) {
            node.side((byte)0);
        }
    }

    void clearSides() {
        assert (this.address != 0L);
        this.writeLong(0L, 0L);
        this.writeLong(8L, 0L);
    }

    byte color() {
        return this.address == 0L ? (byte)0 : this.readByte(45L);
    }

    void color(byte color) {
        if (color != 1 && color != 0) {
            throw new IllegalArgumentException("Unsupported tree-node color: " + color);
        }
        assert (this.address != 0L);
        this.writeByte(45L, color);
    }

    byte side() {
        assert (this.address != 0L);
        return this.readByte(44L);
    }

    void side(byte side) {
        if (side != 1 && side != 0) {
            throw new IllegalArgumentException("Unsupported tree-node side: " + side);
        }
        assert (this.address != 0L);
        this.writeByte(44L, side);
    }

    boolean isNil() {
        return this.address == 0L;
    }

    void reset() {
        this.reset(0L);
    }

    void reset(long baseAddr) {
        this.setAddress(baseAddr);
    }

    RedBlackTreeNode asNew() {
        return RedBlackTreeNode.of(this.tree, this.malloc, this.address);
    }

    void dispose() {
        this.dispose(false);
    }

    void dispose(boolean releasePayload) {
        if (this.isNil()) {
            return;
        }
        RedBlackTreeNode left = this.left();
        RedBlackTreeNode right = this.right();
        if (!left.isNil()) {
            left.dispose(releasePayload);
        }
        if (!right.isNil()) {
            right.dispose(releasePayload);
        }
        this.disposeEntry(releasePayload);
    }

    private void disposeEntry(boolean releasePayLoad) {
        this.disposeEntry(releasePayLoad, true);
    }

    private void disposeEntry(boolean releasePayLoad, boolean releaseValue) {
        MemoryBlock key = this.entry().getKey();
        if (key.address() != 0L && releasePayLoad) {
            this.malloc.free(key.address(), key.size());
        }
        if (releaseValue) {
            this.disposeValue(releasePayLoad);
        }
        this.malloc.free(this.address, 46L);
    }

    private void disposeValue(boolean releasePayLoad) {
        Entry entry = (Entry)this.entry();
        for (EntryValueNode value = entry.getValuesHead(); value != null; value = value.next()) {
            if (releasePayLoad) {
                this.disposeValuePayload(value);
            }
            EntryValueNode preValue = value;
            this.malloc.free(preValue.address(), preValue.size());
        }
    }

    private void disposeValuePayload(EntryValueNode node) {
        MemoryBlock value = node.value();
        if (value.address() != 0L) {
            this.malloc.free(value.address(), value.size());
        }
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        return "RedBlackTreeNode{address: " + this.address + ", parent: " + this.readLong(36L) + ", left: " + this.readLong(0L) + ", right: " + this.readLong(8L) + ", color: " + this.readByte(45L) + ", side: " + this.readByte(44L) + "}";
    }

    public static RedBlackTreeNode of(RedBlackTreeStore tree, MemoryAllocator malloc, long base) {
        return new RedBlackTreeNode(tree, malloc, base);
    }

    public static RedBlackTreeNode newNode(RedBlackTreeStore tree, MemoryAllocator malloc) {
        long addr = malloc.allocate(46L);
        return RedBlackTreeNode.of(tree, malloc, addr);
    }

    class Entry
    implements OffHeapTreeEntry {
        Entry() {
        }

        RedBlackTreeNode node() {
            return RedBlackTreeNode.this;
        }

        @Override
        public MemoryBlock getKey() {
            assert (RedBlackTreeNode.this.address != 0L);
            long address = RedBlackTreeNode.this.readLong(16L);
            int size = RedBlackTreeNode.this.readInt(24L);
            return address == 0L ? null : new MemoryBlock(address, size);
        }

        @Override
        public boolean hasValues() {
            return this.getValuesHead() != null;
        }

        @Override
        public Iterator<MemoryBlock> values() {
            return new EntryValuesIterator(this);
        }

        void setKey(MemoryBlock key) {
            assert (RedBlackTreeNode.this.address != 0L);
            RedBlackTreeNode.this.writeLong(16L, key.address());
            RedBlackTreeNode.this.writeInt(24L, key.size());
        }

        EntryValueNode getValuesHead() {
            assert (RedBlackTreeNode.this.address != 0L);
            long address = RedBlackTreeNode.this.readLong(28L);
            return address == 0L ? null : new EntryValueNode(address);
        }

        void setValuesHead(EntryValueNode valueNode) {
            RedBlackTreeNode.this.writeLong(28L, valueNode.address());
        }

        void addValue(MemoryBlock payload) {
            EntryValueNode head = this.getValuesHead();
            EntryValueNode newVal = null;
            try {
                newVal = this.newValueNode(payload);
                if (head == null || head.isEmpty()) {
                    this.setValuesHead(newVal);
                    newVal.last(newVal);
                } else {
                    EntryValueNode last = head.last();
                    if (last != null) {
                        last.next(newVal);
                    }
                    head.last(newVal);
                }
            }
            catch (NativeOutOfMemoryError | Exception ex) {
                if (newVal != null) {
                    RedBlackTreeNode.this.malloc.free(newVal.address(), newVal.size());
                }
                throw ExceptionUtil.rethrow(ex);
            }
        }

        EntryValueNode newValueNode(MemoryBlock payload) {
            long address = RedBlackTreeNode.this.malloc.allocate(28L);
            EntryValueNode node = new EntryValueNode(address);
            node.zero();
            node.value(payload);
            return node;
        }

        public String toString() {
            return "Entry{node: " + String.valueOf(this.node()) + ", key: " + RedBlackTreeNode.this.readLong(16L) + ", values: " + RedBlackTreeNode.this.readLong(28L) + "}";
        }
    }

    class EntryValueNode
    extends MemoryBlock {
        private static final int VALUE_SZ_OFFSET = 0;
        private static final int VALUE_ADDR_OFFSET = 4;
        private static final int VALUE_NEXT_NODE_OFFSET = 12;
        private static final int VALUE_LAST_NODE_OFFSET = 20;
        private static final int VALUE_NODE_SZ = 28;

        EntryValueNode(long addr) {
            super(addr, 28);
        }

        EntryValueNode next() {
            long addr = this.readLong(12L);
            return addr == 0L ? null : new EntryValueNode(addr);
        }

        void next(EntryValueNode ref) {
            this.writeLong(12L, ref.address);
        }

        EntryValueNode last() {
            long addr = this.readLong(20L);
            return addr == 0L ? null : new EntryValueNode(addr);
        }

        void last(EntryValueNode ref) {
            this.writeLong(20L, ref.address);
        }

        MemoryBlock value() {
            return new MemoryBlock(this.readLong(4L), this.readInt(0L));
        }

        void value(MemoryBlock value) {
            this.writeLong(4L, value.address());
            this.writeInt(0L, value.size());
        }

        boolean isEmpty() {
            return this.address == 0L;
        }
    }
}

