/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.elastic.queue;

import com.hazelcast.internal.elastic.LongIterator;
import com.hazelcast.internal.elastic.queue.LongQueue;
import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.memory.GlobalMemoryAccessorType;
import com.hazelcast.internal.memory.MemoryAccessor;
import com.hazelcast.internal.memory.MemoryAllocator;
import java.util.NoSuchElementException;

public final class LongArrayQueue
implements LongQueue {
    static final long ENTRY_SIZE = 8L;
    private static final MemoryAccessor MEMORY_ACCESSOR = GlobalMemoryAccessorRegistry.getGlobalMemoryAccessor(GlobalMemoryAccessorType.STANDARD);
    private final MemoryAllocator malloc;
    private final int capacity;
    private final long address;
    private final long nullItem;
    private int add;
    private int remove;
    private int size;

    public LongArrayQueue(MemoryAllocator memoryAllocator, int capacity, long nullItem) {
        this.malloc = memoryAllocator;
        this.capacity = capacity;
        this.nullItem = nullItem;
        long realCap = (long)capacity * 8L;
        this.address = this.malloc.allocate(realCap);
        this.clear();
    }

    public LongArrayQueue(MemoryAllocator malloc, LongQueue queue) {
        this(malloc, queue.size(), queue);
    }

    public LongArrayQueue(MemoryAllocator malloc, int capacity, LongQueue queue) {
        this(malloc, capacity, queue.nullItem());
        long value;
        while ((value = queue.poll()) != this.nullItem) {
            if (this.offer(value)) continue;
            throw new IllegalStateException("This: " + this.toString() + ", That: " + String.valueOf(queue));
        }
    }

    private long get(int index) {
        if (index >= this.capacity || index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return MEMORY_ACCESSOR.getLong(this.address + (long)index * 8L);
    }

    private void set(int index, long value) {
        if (index >= this.capacity || index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        MEMORY_ACCESSOR.putLong(this.address + (long)index * 8L, value);
    }

    @Override
    public boolean offer(long value) {
        this.ensureMemory();
        if (value == this.nullItem) {
            throw new IllegalArgumentException();
        }
        if (this.size == this.capacity) {
            return false;
        }
        this.set(this.add, value);
        ++this.add;
        ++this.size;
        if (this.add == this.capacity) {
            this.add = 0;
        }
        return true;
    }

    @Override
    public long peek() {
        this.ensureMemory();
        if (this.size == 0) {
            return this.nullItem;
        }
        return this.get(this.remove);
    }

    @Override
    public long poll() {
        this.ensureMemory();
        if (this.size == 0) {
            return this.nullItem;
        }
        long value = this.get(this.remove);
        this.set(this.remove, this.nullItem);
        ++this.remove;
        --this.size;
        if (this.remove == this.capacity) {
            this.remove = 0;
        }
        return value;
    }

    private void ensureMemory() {
        if (this.size < 0) {
            throw new IllegalStateException("Queue is already destroyed! " + this.toString());
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public int remainingCapacity() {
        return this.capacity - this.size;
    }

    @Override
    public void clear() {
        this.ensureMemory();
        for (int i = 0; i < this.capacity; ++i) {
            MEMORY_ACCESSOR.putLong(this.address + (long)i * 8L, this.nullItem);
        }
        this.add = 0;
        this.remove = 0;
        this.size = 0;
    }

    @Override
    public void dispose() {
        if (this.size >= 0) {
            this.malloc.free(this.address, (long)this.capacity * 8L);
            this.add = 0;
            this.remove = 0;
            this.size = -1;
        }
    }

    @Override
    public long nullItem() {
        return this.nullItem;
    }

    @Override
    public LongIterator iterator() {
        this.ensureMemory();
        return new Iter();
    }

    public boolean isAvailable() {
        return this.size >= 0;
    }

    public String toString() {
        return "LongArrayQueue{capacity=" + this.capacity + ", size=" + this.size + ", add=" + this.add + ", remove=" + this.remove + ", nullItem=" + this.nullItem + "}";
    }

    private final class Iter
    implements LongIterator {
        int remaining;
        int cursor;

        private Iter() {
            this.reset();
        }

        @Override
        public boolean hasNext() {
            return this.remaining > 0;
        }

        @Override
        public long next() {
            if (this.remaining == 0) {
                throw new NoSuchElementException();
            }
            LongArrayQueue.this.ensureMemory();
            long item = LongArrayQueue.this.get(this.cursor);
            this.cursor = this.inc(this.cursor);
            --this.remaining;
            return item;
        }

        private int inc(int i) {
            return ++i == LongArrayQueue.this.capacity ? 0 : i;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reset() {
            this.remaining = LongArrayQueue.this.size();
            this.cursor = LongArrayQueue.this.remove;
        }
    }
}

