/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.dynamicconfig.rewrite;

import com.hazelcast.config.AdvancedNetworkConfig;
import com.hazelcast.config.CacheSimpleConfig;
import com.hazelcast.config.CardinalityEstimatorConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.ConfigAccessor;
import com.hazelcast.config.DataConnectionConfig;
import com.hazelcast.config.DeviceConfig;
import com.hazelcast.config.DurableExecutorConfig;
import com.hazelcast.config.ExecutorConfig;
import com.hazelcast.config.FlakeIdGeneratorConfig;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.ListConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MultiMapConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.PNCounterConfig;
import com.hazelcast.config.QueueConfig;
import com.hazelcast.config.ReliableTopicConfig;
import com.hazelcast.config.ReplicatedMapConfig;
import com.hazelcast.config.RingbufferConfig;
import com.hazelcast.config.ScheduledExecutorConfig;
import com.hazelcast.config.SetConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.config.TopicConfig;
import com.hazelcast.config.UserCodeNamespaceConfig;
import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.internal.config.ConfigSections;
import com.hazelcast.internal.config.LicenseKey;
import com.hazelcast.internal.dynamicconfig.DynamicConfigGeneratorUtil;
import com.hazelcast.internal.dynamicconfig.DynamicConfigurationAwareConfig;
import com.hazelcast.internal.dynamicconfig.rewrite.RewriteChunk;
import com.hazelcast.internal.dynamicconfig.rewrite.RewritePath;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public final class RewriteUtil {
    private RewriteUtil() {
    }

    public static RewriteChunk generateRewriteChunk(Object subConfig, boolean configIsXml) {
        int indent;
        int n = indent = configIsXml ? 4 : 2;
        if (subConfig instanceof MultiMapConfig) {
            MultiMapConfig multiMapConfig = (MultiMapConfig)subConfig;
            return RewriteChunk.newRewriteChunk(new RewritePath().addTypeSegment(ConfigSections.HAZELCAST.getName()).addTypeSegment(ConfigSections.MULTIMAP.getName()).addNameSegment(multiMapConfig.getName()), DynamicConfigGeneratorUtil.multiMapConfigGenerator(multiMapConfig, configIsXml, indent), configIsXml);
        }
        if (subConfig instanceof MapConfig) {
            MapConfig mapConfig = (MapConfig)subConfig;
            return RewriteChunk.newRewriteChunk(new RewritePath().addTypeSegment(ConfigSections.HAZELCAST.getName()).addTypeSegment(ConfigSections.MAP.getName()).addNameSegment(mapConfig.getName()), DynamicConfigGeneratorUtil.mapConfigGenerator(mapConfig, configIsXml, indent), configIsXml);
        }
        if (subConfig instanceof CardinalityEstimatorConfig) {
            CardinalityEstimatorConfig cardinalityEstimatorConfig = (CardinalityEstimatorConfig)subConfig;
            return RewriteChunk.newRewriteChunk(new RewritePath().addTypeSegment(ConfigSections.HAZELCAST.getName()).addTypeSegment(ConfigSections.CARDINALITY_ESTIMATOR.getName()).addNameSegment(cardinalityEstimatorConfig.getName()), DynamicConfigGeneratorUtil.cardinalityEstimatorConfigGenerator(cardinalityEstimatorConfig, configIsXml, indent), configIsXml);
        }
        if (subConfig instanceof RingbufferConfig) {
            RingbufferConfig ringbufferConfig = (RingbufferConfig)subConfig;
            return RewriteChunk.newRewriteChunk(new RewritePath().addTypeSegment(ConfigSections.HAZELCAST.getName()).addTypeSegment(ConfigSections.RINGBUFFER.getName()).addNameSegment(ringbufferConfig.getName()), DynamicConfigGeneratorUtil.ringbufferConfigGenerator(ringbufferConfig, configIsXml, indent), configIsXml);
        }
        if (subConfig instanceof ListConfig) {
            ListConfig listConfig = (ListConfig)subConfig;
            return RewriteChunk.newRewriteChunk(new RewritePath().addTypeSegment(ConfigSections.HAZELCAST.getName()).addTypeSegment(ConfigSections.LIST.getName()).addNameSegment(listConfig.getName()), DynamicConfigGeneratorUtil.listConfigGenerator(listConfig, configIsXml, indent), configIsXml);
        }
        if (subConfig instanceof SetConfig) {
            SetConfig setConfig = (SetConfig)subConfig;
            return RewriteChunk.newRewriteChunk(new RewritePath().addTypeSegment(ConfigSections.HAZELCAST.getName()).addTypeSegment(ConfigSections.SET.getName()).addNameSegment(setConfig.getName()), DynamicConfigGeneratorUtil.setConfigGenerator(setConfig, configIsXml, indent), configIsXml);
        }
        if (subConfig instanceof ReplicatedMapConfig) {
            ReplicatedMapConfig replicatedMapConfig = (ReplicatedMapConfig)subConfig;
            return RewriteChunk.newRewriteChunk(new RewritePath().addTypeSegment(ConfigSections.HAZELCAST.getName()).addTypeSegment(ConfigSections.REPLICATED_MAP.getName()).addNameSegment(replicatedMapConfig.getName()), DynamicConfigGeneratorUtil.replicatedMapConfigGenerator(replicatedMapConfig, configIsXml, indent), configIsXml);
        }
        if (subConfig instanceof TopicConfig) {
            TopicConfig topicConfig = (TopicConfig)subConfig;
            return RewriteChunk.newRewriteChunk(new RewritePath().addTypeSegment(ConfigSections.HAZELCAST.getName()).addTypeSegment(ConfigSections.TOPIC.getName()).addNameSegment(topicConfig.getName()), DynamicConfigGeneratorUtil.topicConfigGenerator(topicConfig, configIsXml, indent), configIsXml);
        }
        if (subConfig instanceof ExecutorConfig) {
            ExecutorConfig executorConfig = (ExecutorConfig)subConfig;
            return RewriteChunk.newRewriteChunk(new RewritePath().addTypeSegment(ConfigSections.HAZELCAST.getName()).addTypeSegment(ConfigSections.EXECUTOR_SERVICE.getName()).addNameSegment(executorConfig.getName()), DynamicConfigGeneratorUtil.executorConfigGenerator(executorConfig, configIsXml, indent), configIsXml);
        }
        if (subConfig instanceof DurableExecutorConfig) {
            DurableExecutorConfig durableExecutorConfig = (DurableExecutorConfig)subConfig;
            return RewriteChunk.newRewriteChunk(new RewritePath().addTypeSegment(ConfigSections.HAZELCAST.getName()).addTypeSegment(ConfigSections.DURABLE_EXECUTOR_SERVICE.getName()).addNameSegment(durableExecutorConfig.getName()), DynamicConfigGeneratorUtil.durableExecutorConfigGenerator(durableExecutorConfig, configIsXml, indent), configIsXml);
        }
        if (subConfig instanceof ScheduledExecutorConfig) {
            ScheduledExecutorConfig scheduledExecutorConfig = (ScheduledExecutorConfig)subConfig;
            return RewriteChunk.newRewriteChunk(new RewritePath().addTypeSegment(ConfigSections.HAZELCAST.getName()).addTypeSegment(ConfigSections.SCHEDULED_EXECUTOR_SERVICE.getName()).addNameSegment(scheduledExecutorConfig.getName()), DynamicConfigGeneratorUtil.scheduledExecutorConfigGenerator(scheduledExecutorConfig, configIsXml, indent), configIsXml);
        }
        if (subConfig instanceof QueueConfig) {
            QueueConfig queueConfig = (QueueConfig)subConfig;
            return RewriteChunk.newRewriteChunk(new RewritePath().addTypeSegment(ConfigSections.HAZELCAST.getName()).addTypeSegment(ConfigSections.QUEUE.getName()).addNameSegment(queueConfig.getName()), DynamicConfigGeneratorUtil.queueConfigGenerator(queueConfig, configIsXml, indent), configIsXml);
        }
        if (subConfig instanceof ReliableTopicConfig) {
            ReliableTopicConfig reliableTopicConfig = (ReliableTopicConfig)subConfig;
            return RewriteChunk.newRewriteChunk(new RewritePath().addTypeSegment(ConfigSections.HAZELCAST.getName()).addTypeSegment(ConfigSections.RELIABLE_TOPIC.getName()).addNameSegment(reliableTopicConfig.getName()), DynamicConfigGeneratorUtil.reliableTopicConfigGenerator(reliableTopicConfig, configIsXml, indent), configIsXml);
        }
        if (subConfig instanceof CacheSimpleConfig) {
            CacheSimpleConfig cacheSimpleConfig = (CacheSimpleConfig)subConfig;
            return RewriteChunk.newRewriteChunk(new RewritePath().addTypeSegment(ConfigSections.HAZELCAST.getName()).addTypeSegment(ConfigSections.CACHE.getName()).addNameSegment(cacheSimpleConfig.getName()), DynamicConfigGeneratorUtil.cacheConfigGenerator(cacheSimpleConfig, configIsXml, indent), configIsXml);
        }
        if (subConfig instanceof FlakeIdGeneratorConfig) {
            FlakeIdGeneratorConfig flakeIdGeneratorConfig = (FlakeIdGeneratorConfig)subConfig;
            return RewriteChunk.newRewriteChunk(new RewritePath().addTypeSegment(ConfigSections.HAZELCAST.getName()).addTypeSegment(ConfigSections.FLAKE_ID_GENERATOR.getName()).addNameSegment(flakeIdGeneratorConfig.getName()), DynamicConfigGeneratorUtil.flakeIdGeneratorConfigGenerator(flakeIdGeneratorConfig, configIsXml, indent), configIsXml);
        }
        if (subConfig instanceof PNCounterConfig) {
            PNCounterConfig pnCounterConfig = (PNCounterConfig)subConfig;
            return RewriteChunk.newRewriteChunk(new RewritePath().addTypeSegment(ConfigSections.HAZELCAST.getName()).addTypeSegment(ConfigSections.PN_COUNTER.getName()).addNameSegment(pnCounterConfig.getName()), DynamicConfigGeneratorUtil.pnCounterConfigGenerator(pnCounterConfig, configIsXml, indent), configIsXml);
        }
        if (subConfig instanceof WanReplicationConfig) {
            WanReplicationConfig wanReplicationConfig = (WanReplicationConfig)subConfig;
            return RewriteChunk.newRewriteChunk(new RewritePath().addTypeSegment(ConfigSections.HAZELCAST.getName()).addTypeSegment(ConfigSections.WAN_REPLICATION.getName()).addNameSegment(wanReplicationConfig.getName()), DynamicConfigGeneratorUtil.wanReplicationConfigGenerator(wanReplicationConfig, configIsXml, indent), configIsXml);
        }
        if (subConfig instanceof LicenseKey) {
            LicenseKey licenseKey = (LicenseKey)subConfig;
            return RewriteChunk.newRewriteChunk(new RewritePath().addTypeSegment(ConfigSections.HAZELCAST.getName()).addTypeSegment(ConfigSections.LICENSE_KEY.getName()), DynamicConfigGeneratorUtil.licenseKeyConfigGenerator(licenseKey.getLicenseKey(), configIsXml, indent), configIsXml);
        }
        if (subConfig instanceof NetworkConfig) {
            NetworkConfig networkConfig = (NetworkConfig)subConfig;
            TcpIpConfig tcpIpConfig = networkConfig.getJoin().getTcpIpConfig();
            return RewriteChunk.newRewriteChunk(new RewritePath().addTypeSegment(ConfigSections.HAZELCAST.getName()).addTypeSegment(ConfigSections.NETWORK.getName()).addTypeSegment(ConfigSections.JOIN.getName()).addTypeSegment(ConfigSections.TCP_IP.getName()), DynamicConfigGeneratorUtil.tcpIpConfigGenerator(tcpIpConfig, configIsXml, indent, false), configIsXml);
        }
        if (subConfig instanceof AdvancedNetworkConfig) {
            AdvancedNetworkConfig advancedNetworkConfig = (AdvancedNetworkConfig)subConfig;
            TcpIpConfig tcpIpConfig = advancedNetworkConfig.getJoin().getTcpIpConfig();
            return RewriteChunk.newRewriteChunk(new RewritePath().addTypeSegment(ConfigSections.HAZELCAST.getName()).addTypeSegment(ConfigSections.ADVANCED_NETWORK.getName()).addTypeSegment(ConfigSections.JOIN.getName()).addTypeSegment(ConfigSections.TCP_IP.getName()), DynamicConfigGeneratorUtil.tcpIpConfigGenerator(tcpIpConfig, configIsXml, indent, true), configIsXml);
        }
        if (subConfig instanceof DataConnectionConfig) {
            DataConnectionConfig dataConnectionConfig = (DataConnectionConfig)subConfig;
            return RewriteChunk.newRewriteChunk(new RewritePath().addTypeSegment(ConfigSections.HAZELCAST.getName()).addTypeSegment(ConfigSections.DATA_CONNECTION.getName()).addNameSegment(dataConnectionConfig.getName()), DynamicConfigGeneratorUtil.dataConnectionConfigGenerator(dataConnectionConfig, configIsXml, indent), configIsXml);
        }
        if (subConfig instanceof UserCodeNamespaceConfig) {
            UserCodeNamespaceConfig userCodeNamespaceConfig = (UserCodeNamespaceConfig)subConfig;
            RewritePath rewritePath = configIsXml ? new RewritePath().addTypeSegment(ConfigSections.HAZELCAST.getName()).addTypeSegment(ConfigSections.USER_CODE_NAMESPACES.getName()).addTypeSegment(ConfigSections.USER_CODE_NAMESPACE.getName()).addNameSegment(userCodeNamespaceConfig.getName()) : new RewritePath().addTypeSegment(ConfigSections.HAZELCAST.getName()).addTypeSegment(ConfigSections.USER_CODE_NAMESPACES.getName()).addTypeSegment(userCodeNamespaceConfig.getName());
            return RewriteChunk.newRewriteChunk(rewritePath, DynamicConfigGeneratorUtil.userCodeNamespaceConfigGenerator(userCodeNamespaceConfig, configIsXml, indent), configIsXml);
        }
        throw new UnsupportedOperationException("Unsupported config type: " + String.valueOf(subConfig));
    }

    public static boolean configIsXml(File configurationFile) {
        if (configurationFile == null || !configurationFile.exists()) {
            throw new HazelcastException("Configuration file not found.");
        }
        return configurationFile.getPath().endsWith("xml");
    }

    public static File getDynamicConfigurationPersistenceFile(Config config) {
        return config.getConfigurationFile();
    }

    public static void checkDynamicConfigurationPersistenceFileRequirements(Config config) {
        Path configurationFilePath = RewriteUtil.getDynamicConfigurationPersistenceFile(config).toPath();
        if (!Files.exists(configurationFilePath, new LinkOption[0])) {
            throw new IllegalStateException("Dynamic configuration persistence file does not exist. (" + String.valueOf(configurationFilePath.toAbsolutePath()) + ") Please create the file. Hazelcast doesn't automatically create this file for you. Because in that case you may not notice if something were to happen that file.");
        }
        if (!Files.isReadable(configurationFilePath)) {
            throw new IllegalStateException("Can't read from dynamic configuration persistence file. (" + String.valueOf(configurationFilePath.toAbsolutePath()) + ") Please check the file permissions.");
        }
        if (!Files.isWritable(configurationFilePath)) {
            throw new IllegalStateException("Can't write to dynamic configuration persistence file. (" + String.valueOf(configurationFilePath.toAbsolutePath()) + ") Please check the file permissions.");
        }
    }

    public static boolean checkDynamicConfigurationNotPersistedYet(Config config, Object subConfig) {
        Config declarativeConfig = RewriteUtil.loadFromFile(config.getConfigurationFile());
        try {
            if (subConfig instanceof MultiMapConfig) {
                MultiMapConfig multiMapConfig = (MultiMapConfig)subConfig;
                return DynamicConfigurationAwareConfig.checkStaticConfigDoesNotExist(declarativeConfig.getMultiMapConfigs(), multiMapConfig.getName(), multiMapConfig);
            }
            if (subConfig instanceof MapConfig) {
                MapConfig mapConfig = (MapConfig)subConfig;
                return DynamicConfigurationAwareConfig.checkStaticConfigDoesNotExist(declarativeConfig.getMapConfigs(), mapConfig.getName(), mapConfig);
            }
            if (subConfig instanceof CardinalityEstimatorConfig) {
                CardinalityEstimatorConfig cardinalityEstimatorConfig = (CardinalityEstimatorConfig)subConfig;
                return DynamicConfigurationAwareConfig.checkStaticConfigDoesNotExist(declarativeConfig.getCardinalityEstimatorConfigs(), cardinalityEstimatorConfig.getName(), cardinalityEstimatorConfig);
            }
            if (subConfig instanceof RingbufferConfig) {
                RingbufferConfig ringbufferConfig = (RingbufferConfig)subConfig;
                return DynamicConfigurationAwareConfig.checkStaticConfigDoesNotExist(declarativeConfig.getRingbufferConfigs(), ringbufferConfig.getName(), ringbufferConfig);
            }
            if (subConfig instanceof ListConfig) {
                ListConfig listConfig = (ListConfig)subConfig;
                return DynamicConfigurationAwareConfig.checkStaticConfigDoesNotExist(declarativeConfig.getListConfigs(), listConfig.getName(), listConfig);
            }
            if (subConfig instanceof SetConfig) {
                SetConfig setConfig = (SetConfig)subConfig;
                return DynamicConfigurationAwareConfig.checkStaticConfigDoesNotExist(declarativeConfig.getSetConfigs(), setConfig.getName(), setConfig);
            }
            if (subConfig instanceof ReplicatedMapConfig) {
                ReplicatedMapConfig replicatedMapConfig = (ReplicatedMapConfig)subConfig;
                return DynamicConfigurationAwareConfig.checkStaticConfigDoesNotExist(declarativeConfig.getReplicatedMapConfigs(), replicatedMapConfig.getName(), replicatedMapConfig);
            }
            if (subConfig instanceof TopicConfig) {
                TopicConfig topicConfig = (TopicConfig)subConfig;
                return DynamicConfigurationAwareConfig.checkStaticConfigDoesNotExist(declarativeConfig.getTopicConfigs(), topicConfig.getName(), topicConfig);
            }
            if (subConfig instanceof ExecutorConfig) {
                ExecutorConfig executorConfig = (ExecutorConfig)subConfig;
                return DynamicConfigurationAwareConfig.checkStaticConfigDoesNotExist(declarativeConfig.getExecutorConfigs(), executorConfig.getName(), executorConfig);
            }
            if (subConfig instanceof DurableExecutorConfig) {
                DurableExecutorConfig durableExecutorConfig = (DurableExecutorConfig)subConfig;
                return DynamicConfigurationAwareConfig.checkStaticConfigDoesNotExist(declarativeConfig.getDurableExecutorConfigs(), durableExecutorConfig.getName(), durableExecutorConfig);
            }
            if (subConfig instanceof ScheduledExecutorConfig) {
                ScheduledExecutorConfig scheduledExecutorConfig = (ScheduledExecutorConfig)subConfig;
                return DynamicConfigurationAwareConfig.checkStaticConfigDoesNotExist(declarativeConfig.getScheduledExecutorConfigs(), scheduledExecutorConfig.getName(), scheduledExecutorConfig);
            }
            if (subConfig instanceof QueueConfig) {
                QueueConfig queueConfig = (QueueConfig)subConfig;
                return DynamicConfigurationAwareConfig.checkStaticConfigDoesNotExist(declarativeConfig.getQueueConfigs(), queueConfig.getName(), queueConfig);
            }
            if (subConfig instanceof ReliableTopicConfig) {
                ReliableTopicConfig reliableTopicConfig = (ReliableTopicConfig)subConfig;
                return DynamicConfigurationAwareConfig.checkStaticConfigDoesNotExist(declarativeConfig.getReliableTopicConfigs(), reliableTopicConfig.getName(), reliableTopicConfig);
            }
            if (subConfig instanceof CacheSimpleConfig) {
                CacheSimpleConfig cacheSimpleConfig = (CacheSimpleConfig)subConfig;
                return DynamicConfigurationAwareConfig.checkStaticConfigDoesNotExist(declarativeConfig.getCacheConfigs(), cacheSimpleConfig.getName(), cacheSimpleConfig);
            }
            if (subConfig instanceof FlakeIdGeneratorConfig) {
                FlakeIdGeneratorConfig flakeIdGeneratorConfig = (FlakeIdGeneratorConfig)subConfig;
                return DynamicConfigurationAwareConfig.checkStaticConfigDoesNotExist(declarativeConfig.getFlakeIdGeneratorConfigs(), flakeIdGeneratorConfig.getName(), flakeIdGeneratorConfig);
            }
            if (subConfig instanceof PNCounterConfig) {
                PNCounterConfig pnCounterConfig = (PNCounterConfig)subConfig;
                return DynamicConfigurationAwareConfig.checkStaticConfigDoesNotExist(declarativeConfig.getPNCounterConfigs(), pnCounterConfig.getName(), pnCounterConfig);
            }
            if (subConfig instanceof DataConnectionConfig) {
                DataConnectionConfig dataConnectionConfig = (DataConnectionConfig)subConfig;
                return DynamicConfigurationAwareConfig.checkStaticConfigDoesNotExist(declarativeConfig.getDataConnectionConfigs(), dataConnectionConfig.getName(), dataConnectionConfig);
            }
            if (subConfig instanceof UserCodeNamespaceConfig) {
                UserCodeNamespaceConfig userCodeNamespaceConfig = (UserCodeNamespaceConfig)subConfig;
                return DynamicConfigurationAwareConfig.checkStaticConfigDoesNotExist(ConfigAccessor.getNamespaceConfigs(declarativeConfig.getNamespacesConfig()), userCodeNamespaceConfig.getName(), userCodeNamespaceConfig);
            }
            if (subConfig instanceof WanReplicationConfig) {
                return true;
            }
            if (subConfig instanceof LicenseKey) {
                return true;
            }
            if (subConfig instanceof NetworkConfig) {
                return true;
            }
            if (subConfig instanceof AdvancedNetworkConfig) {
                return true;
            }
            if (subConfig instanceof DeviceConfig) {
                return true;
            }
            throw new UnsupportedOperationException("Unsupported config type: " + String.valueOf(subConfig));
        }
        catch (InvalidConfigurationException e) {
            throw new InvalidConfigurationException("Dynamic Configuration Persistence failed. There is a conflict between the declarative configuration file and dynamic change." + e.getMessage(), e);
        }
    }

    public static void checkDynamicConfigurationBackupDirRequirements(Config config) {
        Path backupDirPath = config.getDynamicConfigurationConfig().getBackupDir().toPath();
        if (!Files.exists(backupDirPath, new LinkOption[0]) && !backupDirPath.toFile().mkdirs()) {
            throw new IllegalStateException("Can't create the backup directory for dynamic configuration.");
        }
        if (!Files.isReadable(backupDirPath)) {
            throw new IllegalStateException("Can't read from dynamic configuration backup directory. (" + String.valueOf(backupDirPath.toAbsolutePath()) + ") Please check the file permissions.");
        }
        if (!Files.isWritable(backupDirPath)) {
            throw new IllegalStateException("Can't write to dynamic configuration backup directory. (" + String.valueOf(backupDirPath.toAbsolutePath()) + ") Please check the file permissions.");
        }
    }

    public static boolean configFileUsesUnixLineSeparator(String documentAsString) {
        int index = documentAsString.indexOf(10);
        if (index == -1) {
            return System.lineSeparator().equals("\n");
        }
        if (index == 0) {
            return true;
        }
        return documentAsString.charAt(index - 1) != '\r';
    }

    public static Config loadFromFile(File rootConfig) {
        try {
            return Config.loadFromFile(rootConfig);
        }
        catch (Exception e) {
            throw new InvalidConfigurationException("Can't read declarative configuration from file: " + rootConfig.getAbsolutePath() + ". Please check the the configuration file and the imported declarative configurations if there are any.", e);
        }
    }
}

