/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.dynamicconfig.rewrite;

import com.hazelcast.internal.config.ConfigSections;
import com.hazelcast.internal.dynamicconfig.rewrite.RewriteChunk;
import com.hazelcast.internal.dynamicconfig.rewrite.RewritePath;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RewriteChunkXml
extends RewriteChunk {
    private static final String ROOT_TAG = "<hazelcast xmlns=\"http://www.hazelcast.com/schema/config\">";
    private static final Pattern REGEX_INDENT = Pattern.compile("(\\R *)(<)");

    RewriteChunkXml(RewritePath path, String chunk) {
        super(path, chunk);
    }

    @Override
    void extend(RewritePath differencePath) {
        while (differencePath.segmentCount() > 0) {
            String segmentWithoutSeparator = differencePath.removeLastSegment();
            this.indent(4);
            if (Objects.equals(segmentWithoutSeparator, ConfigSections.HAZELCAST.getName())) {
                this.chunk = this.newLineSeparator + ROOT_TAG + this.chunk + this.newLineSeparator + "</" + segmentWithoutSeparator + ">";
                this.includesRootNode = true;
            } else {
                this.chunk = this.newLineSeparator + "<" + segmentWithoutSeparator + ">" + this.chunk + this.newLineSeparator + "</" + segmentWithoutSeparator + ">";
            }
            ++this.timesExtended;
        }
    }

    @Override
    void indent(int spaceCount) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < spaceCount; ++i) {
            stringBuilder.append(" ");
        }
        String indent = stringBuilder.toString();
        stringBuilder.setLength(0);
        Matcher m = REGEX_INDENT.matcher(this.chunk);
        int endPosition = 0;
        while (m.find()) {
            int startPosition = endPosition;
            endPosition = m.end(1);
            stringBuilder.append(this.chunk, startPosition, endPosition);
            stringBuilder.append(indent);
        }
        stringBuilder.append(this.chunk, endPosition, this.chunk.length());
        this.chunk = stringBuilder.toString();
    }

    @Override
    int getSpaceCount() {
        return (this.path.typeSegmentCount() - 1 - this.timesExtended) * 4;
    }
}

