/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.dynamicconfig.rewrite;

import com.hazelcast.config.ConfigAccessor;
import com.hazelcast.config.UserCodeNamespaceConfig;
import com.hazelcast.internal.namespace.ResourceDefinition;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Comparator;
import java.util.stream.Stream;

public final class DynamicConfigPersistenceMetadataWriter {
    private static final String META_DIR = "dynamic-persistence-metadata";
    private static final String TMP_SUFFIX = ".tmp";

    private DynamicConfigPersistenceMetadataWriter() {
    }

    public static void writeConfigMetadata(Object subConfig, Path root) throws IOException {
        if (subConfig instanceof UserCodeNamespaceConfig) {
            Path metaStore = DynamicConfigPersistenceMetadataWriter.getOrCreateMetaStore(root);
            DynamicConfigPersistenceMetadataWriter.handleNamespaceConfig((UserCodeNamespaceConfig)subConfig, metaStore);
        }
    }

    private static void handleNamespaceConfig(UserCodeNamespaceConfig nsConfig, Path rootMetaStore) throws IOException {
        Collection<ResourceDefinition> resources = ConfigAccessor.getResourceDefinitions(nsConfig);
        Path nsConfigMetaDir = DynamicConfigPersistenceMetadataWriter.generateConfigDirectory("hz:impl:namespaceService", nsConfig.getName());
        Path resolvedNamespaceMetaDir = rootMetaStore.resolve(nsConfigMetaDir);
        DynamicConfigPersistenceMetadataWriter.ensureEmpty(resolvedNamespaceMetaDir);
        if (resources != null && !resources.isEmpty()) {
            DynamicConfigPersistenceMetadataWriter.createDirectory(resolvedNamespaceMetaDir);
            resources.forEach(resource -> {
                try {
                    resource.setUrl(DynamicConfigPersistenceMetadataWriter.writeConfigMetadata(resolvedNamespaceMetaDir, resource.id(), resource.payload()));
                }
                catch (IOException e) {
                    throw ExceptionUtil.rethrow(e);
                }
            });
            IOUtil.fsyncDir(resolvedNamespaceMetaDir);
        }
    }

    private static void ensureEmpty(Path subConfigMetaDirectory) throws IOException {
        if (Files.exists(subConfigMetaDirectory, new LinkOption[0])) {
            try (Stream<Path> walk = Files.walk(subConfigMetaDirectory, new FileVisitOption[0]);){
                walk.sorted(Comparator.reverseOrder()).forEach(path -> {
                    try {
                        Files.delete(path);
                    }
                    catch (IOException e) {
                        throw ExceptionUtil.rethrow(e);
                    }
                });
            }
        }
    }

    private static void createDirectory(Path directory) throws IOException {
        if (!Files.exists(directory, new LinkOption[0])) {
            Files.createDirectories(directory, new FileAttribute[0]);
        }
    }

    private static String writeConfigMetadata(Path metaRoot, String id, byte[] metadata) throws IOException {
        Path metadataFile = metaRoot.resolve(DynamicConfigPersistenceMetadataWriter.toFileName(id));
        File metaFile = new File(metadataFile.toString());
        File tmpFile = new File(String.valueOf(metadataFile) + TMP_SUFFIX);
        try (FileOutputStream fileOut = new FileOutputStream(tmpFile);){
            fileOut.write(metadata);
            fileOut.flush();
            fileOut.getFD().sync();
        }
        catch (IOException e) {
            throw ExceptionUtil.rethrow(e);
        }
        IOUtil.rename(tmpFile, metaFile);
        return metadataFile.toUri().toURL().toString();
    }

    private static Path getOrCreateMetaStore(Path configRoot) throws IOException {
        Path configDir = configRoot.resolve(META_DIR);
        if (Files.exists(configDir, new LinkOption[0])) {
            return configDir;
        }
        return Files.createDirectory(configDir, new FileAttribute[0]);
    }

    private static Path generateConfigDirectory(String service, String configName) {
        return Paths.get(DynamicConfigPersistenceMetadataWriter.toFileName(service), DynamicConfigPersistenceMetadataWriter.toFileName(configName));
    }

    public static String toFileName(String name) {
        return name.replaceAll("[:\\\\/*\"?|<>',]", "_");
    }
}

