/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.dynamicconfig;

import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.config.Config;
import com.hazelcast.config.ConfigAccessor;
import com.hazelcast.config.DeviceConfig;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.LocalDeviceConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.NamedConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.config.UserCodeNamespaceConfig;
import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.instance.impl.EnterpriseNodeExtension;
import com.hazelcast.instance.impl.LicenseMemoryChecker;
import com.hazelcast.internal.cluster.ClusterService;
import com.hazelcast.internal.config.ConfigNamespace;
import com.hazelcast.internal.config.ConfigSections;
import com.hazelcast.internal.dynamicconfig.ClusterWideConfigurationService;
import com.hazelcast.internal.dynamicconfig.ConfigCheckMode;
import com.hazelcast.internal.dynamicconfig.ConfigUpdateResult;
import com.hazelcast.internal.dynamicconfig.DynamicConfigListener;
import com.hazelcast.internal.dynamicconfig.DynamicConfigurationAwareConfig;
import com.hazelcast.internal.dynamicconfig.rewrite.DynamicConfigPersistenceMetadataWriter;
import com.hazelcast.internal.dynamicconfig.rewrite.RewriteBackup;
import com.hazelcast.internal.dynamicconfig.rewrite.RewriteChunk;
import com.hazelcast.internal.dynamicconfig.rewrite.RewriteUtil;
import com.hazelcast.internal.dynamicconfig.rewrite.Rewriter;
import com.hazelcast.internal.management.IncreaseDeviceCapacityOperation;
import com.hazelcast.internal.management.ManagementCenterService;
import com.hazelcast.internal.management.events.ConfigUpdateFailedEvent;
import com.hazelcast.internal.management.events.ConfigUpdateFinishedEvent;
import com.hazelcast.internal.management.events.ConfigUpdateProgressEvent;
import com.hazelcast.internal.management.events.ConfigUpdateStartedEvent;
import com.hazelcast.internal.management.events.Event;
import com.hazelcast.internal.management.operation.SetLicenseOperation;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.tstore.service.TieredStoreService;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.InvocationUtil;
import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.license.domain.Feature;
import com.hazelcast.license.exception.InvalidLicenseException;
import com.hazelcast.memory.Capacity;
import com.hazelcast.memory.MemoryUnit;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.executionservice.ExecutionService;
import com.hazelcast.wan.impl.AddWanConfigResult;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public class EnterpriseClusterWideConfigurationService
extends ClusterWideConfigurationService {
    private static final String REWRITER_FILE_SUFFIX = ".rewrite";
    private static final int PERSIST_ACTION_MAX_RETRY_COUNT = 3;
    private static final int UPDATE_LICENSE_MAX_RETRY_COUNT = 100;

    public EnterpriseClusterWideConfigurationService(NodeEngine nodeEngine, DynamicConfigListener dynamicConfigListener) {
        super(nodeEngine, dynamicConfigListener);
    }

    @Override
    public void registerConfigLocally(IdentifiedDataSerializable newConfig, ConfigCheckMode configCheckMode) {
        MapConfig mapConfig;
        if (newConfig instanceof MapConfig && (mapConfig = (MapConfig)newConfig).getTieredStoreConfig().isEnabled()) {
            TieredStoreService tsService = (TieredStoreService)this.nodeEngine.getService("hz:ee:tieredStoreServiceImpl");
            tsService.validateDynamicConfig(this.nodeEngine.getConfig(), mapConfig);
        }
        super.registerConfigLocally(newConfig, configCheckMode);
    }

    @Override
    public void updateLicense(String licenseKey) {
        InvocationUtil.invokeOnStableClusterSerial(this.nodeEngine, () -> new SetLicenseOperation(licenseKey), 100).join();
    }

    void increaseLocalDeviceCapacity(Map<String, Capacity> newLocalDeviceCapacity) {
        InvocationUtil.invokeOnStableClusterSerial(this.nodeEngine, () -> new IncreaseDeviceCapacityOperation(newLocalDeviceCapacity), 100).join();
    }

    @Override
    public void persist(Object subConfig) {
        if (this.nodeEngine.getConfig().getDynamicConfigurationConfig().isPersistenceEnabled()) {
            try {
                this.persistWithRetryAndLock(subConfig);
            }
            catch (Exception e) {
                this.logger.severe("Dynamic Configuration Persistence failed. Please check if you have declarative configuration conflicts. Note that this operation is idempotent. You can retry after fixing the issue.", e);
            }
        }
    }

    private synchronized void persistWithRetryAndLock(Object subConfig) {
        this.logger.info("Persisting dynamic configuration started.");
        RewriteUtil.checkDynamicConfigurationPersistenceFileRequirements(this.nodeEngine.getConfig());
        int timesFailed = 0;
        if (RewriteUtil.checkDynamicConfigurationNotPersistedYet(this.nodeEngine.getConfig(), subConfig)) {
            while (true) {
                try {
                    this.retriedPersistAction(subConfig);
                    this.logger.info("Persisting dynamic configuration finished.");
                    return;
                }
                catch (Exception e) {
                    if (++timesFailed <= 3) continue;
                    throw ExceptionUtil.rethrow(e);
                }
                break;
            }
        }
    }

    private void retriedPersistAction(Object subConfig) throws IOException {
        File configurationFile = RewriteUtil.getDynamicConfigurationPersistenceFile(this.nodeEngine.getConfig());
        boolean configIsXml = RewriteUtil.configIsXml(configurationFile);
        DynamicConfigPersistenceMetadataWriter.writeConfigMetadata(subConfig, configurationFile.getParentFile().toPath());
        RewriteChunk rewriteChunk = RewriteUtil.generateRewriteChunk(subConfig, configIsXml);
        Rewriter rewriter = new Rewriter(new String(Files.readAllBytes(configurationFile.toPath())), rewriteChunk);
        File tmpFile = new File(String.valueOf(configurationFile.toPath()) + REWRITER_FILE_SUFFIX);
        Files.write(tmpFile.toPath(), rewriter.rewrite().getBytes(), new OpenOption[0]);
        RewriteBackup.takeBackup(this.nodeEngine.getConfig(), this.logger);
        IOUtil.move(tmpFile.toPath(), configurationFile.toPath());
    }

    @Override
    public UUID updateAsync(String configPatch) {
        ConfigUpdater configUpdater = new ConfigUpdater(this.nodeEngine, this.nodeEngine.getConfig(), configPatch);
        ExecutionService executionService = this.nodeEngine.getExecutionService();
        Future<ConfigUpdateResult> future = executionService.submit("hz:mc", configUpdater::update);
        executionService.asCompletableFuture(future).whenCompleteAsync((result, throwable) -> {
            if (throwable != null) {
                this.logger.severe("dynamic configuration update failed", (Throwable)throwable);
            }
        }, ConcurrencyUtil.CALLER_RUNS);
        return configUpdater.configUpdateProcessId;
    }

    @Override
    public ConfigUpdateResult update(Config newConfig) {
        ConfigUpdater configUpdater = new ConfigUpdater(this.nodeEngine, this.nodeEngine.getConfig(), newConfig);
        return configUpdater.update();
    }

    void emitManagementCenterEvent(Event event) {
        ManagementCenterService service = ((NodeEngineImpl)this.nodeEngine).getManagementCenterService();
        if (service != null) {
            service.log(event);
        }
    }

    final class ConfigUpdater {
        private final Map<String, Set<String>> scannedConfigs = new HashMap<String, Set<String>>();
        private final Set<ConfigNamespace> addedConfigs = new HashSet<ConfigNamespace>();
        private final Set<ConfigNamespace> ignoredConfigs = new HashSet<ConfigNamespace>();
        private final DynamicConfigurationAwareConfig oldConfig;
        private final Supplier<Config> newConfigSupplier;
        private final NodeEngine nodeEngine;
        private Config newConfig;
        private final UUID configUpdateProcessId;
        private int totalChangeCount;
        private int appliedChangeCount;
        private ConfigNamespace nextNamespace;

        private ConfigUpdater(NodeEngine nodeEngine, Config oldConfig, String configPatch) {
            this(nodeEngine, oldConfig, () -> Optional.ofNullable(configPatch).map(Config::loadFromString).orElse(null));
        }

        ConfigUpdater(NodeEngine nodeEngine, Config oldConfig, Config newConfig) {
            this(nodeEngine, oldConfig, () -> newConfig);
        }

        private ConfigUpdater(NodeEngine nodeEngine, Config oldConfig, Supplier<Config> newConfigSupplier) {
            this.nodeEngine = nodeEngine;
            this.oldConfig = (DynamicConfigurationAwareConfig)Objects.requireNonNull(oldConfig);
            this.newConfigSupplier = newConfigSupplier;
            this.configUpdateProcessId = UuidUtil.newUnsecureUUID();
        }

        private ConfigUpdateResult update() {
            try {
                EnterpriseClusterWideConfigurationService.this.logger.info("Updating configuration.");
                EnterpriseClusterWideConfigurationService.this.emitManagementCenterEvent(new ConfigUpdateStartedEvent(this.configUpdateProcessId));
                this.checkLicense();
                try {
                    this.newConfig = this.newConfigSupplier.get();
                    if (this.newConfig == null) {
                        this.newConfig = Config.loadFromFile(this.oldConfig.getConfigurationFile());
                        EnterpriseClusterWideConfigurationService.this.logger.info("Detected reload operation. Using " + this.newConfig.getConfigurationFile().getAbsolutePath() + ".");
                    }
                }
                catch (IllegalArgumentException e) {
                    throw new ConfigurationParsingException(e);
                }
                catch (InvalidConfigurationException e) {
                    throw new ConfigurationValidationException(e);
                }
                this.scanAll();
                this.applyAll();
                ConfigUpdateResult configUpdateResult = new ConfigUpdateResult(this.addedConfigs, this.ignoredConfigs);
                EnterpriseClusterWideConfigurationService.this.emitManagementCenterEvent(new ConfigUpdateFinishedEvent(this.configUpdateProcessId, configUpdateResult));
                EnterpriseClusterWideConfigurationService.this.logger.info("Configuration successfully updated.");
                return configUpdateResult;
            }
            catch (ConfigurationParsingException e) {
                EnterpriseClusterWideConfigurationService.this.emitManagementCenterEvent(new ConfigUpdateFailedEvent(this.configUpdateProcessId, ConfigUpdateFailedEvent.FailureReason.PARSING_FAILURE, e, null, ConfigUpdateResult.EMPTY));
                throw ExceptionUtil.rethrow(e);
            }
            catch (ConfigurationValidationException e) {
                EnterpriseClusterWideConfigurationService.this.emitManagementCenterEvent(new ConfigUpdateFailedEvent(this.configUpdateProcessId, ConfigUpdateFailedEvent.FailureReason.SCHEMA_VALIDATION_FAILURE, e, null, ConfigUpdateResult.EMPTY));
                throw ExceptionUtil.rethrow(e);
            }
            catch (InvalidLicenseException e) {
                EnterpriseClusterWideConfigurationService.this.emitManagementCenterEvent(new ConfigUpdateFailedEvent(this.configUpdateProcessId, ConfigUpdateFailedEvent.FailureReason.INVALID_LICENSE, e, null, ConfigUpdateResult.EMPTY));
                throw ExceptionUtil.rethrow(e);
            }
            catch (Exception e) {
                ConfigUpdateResult configUpdateResult = new ConfigUpdateResult(this.addedConfigs, this.ignoredConfigs);
                EnterpriseClusterWideConfigurationService.this.emitManagementCenterEvent(new ConfigUpdateFailedEvent(this.configUpdateProcessId, ConfigUpdateFailedEvent.FailureReason.GENERIC_FAILURE, e, this.nextNamespace, configUpdateResult));
                throw ExceptionUtil.rethrow(e);
            }
        }

        void scanAll() {
            this.scan(ConfigSections.MAP, Config::getMapConfigs);
            this.scan(ConfigSections.CACHE, Config::getCacheConfigs);
            this.scan(ConfigSections.QUEUE, Config::getQueueConfigs);
            this.scan(ConfigSections.LIST, Config::getListConfigs);
            this.scan(ConfigSections.SET, Config::getSetConfigs);
            this.scan(ConfigSections.MULTIMAP, Config::getMultiMapConfigs);
            this.scan(ConfigSections.REPLICATED_MAP, Config::getReplicatedMapConfigs);
            this.scan(ConfigSections.RINGBUFFER, Config::getRingbufferConfigs);
            this.scan(ConfigSections.TOPIC, Config::getTopicConfigs);
            this.scan(ConfigSections.RELIABLE_TOPIC, Config::getReliableTopicConfigs);
            this.scan(ConfigSections.EXECUTOR_SERVICE, Config::getExecutorConfigs);
            this.scan(ConfigSections.DURABLE_EXECUTOR_SERVICE, Config::getDurableExecutorConfigs);
            this.scan(ConfigSections.SCHEDULED_EXECUTOR_SERVICE, Config::getScheduledExecutorConfigs);
            this.scan(ConfigSections.CARDINALITY_ESTIMATOR, Config::getCardinalityEstimatorConfigs);
            this.scan(ConfigSections.PN_COUNTER, Config::getPNCounterConfigs);
            this.scan(ConfigSections.FLAKE_ID_GENERATOR, Config::getFlakeIdGeneratorConfigs);
            this.scan(ConfigSections.DATA_CONNECTION, Config::getDataConnectionConfigs);
            this.scanNetworkConfig();
            this.scanAdvancedNetworkConfig();
            this.scanWan();
            this.scanLicenseKey();
            this.scanUserCodeNamespaceConfig();
            this.scanTieredStorageConfig();
            this.scanLocalDeviceConfig();
        }

        private void applyAll() {
            this.apply(ConfigSections.MAP, Config::addMapConfig, Config::getMapConfigs);
            this.apply(ConfigSections.CACHE, Config::addCacheConfig, Config::getCacheConfigs);
            this.apply(ConfigSections.QUEUE, Config::addQueueConfig, Config::getQueueConfigs);
            this.apply(ConfigSections.LIST, Config::addListConfig, Config::getListConfigs);
            this.apply(ConfigSections.SET, Config::addSetConfig, Config::getSetConfigs);
            this.apply(ConfigSections.MULTIMAP, Config::addMultiMapConfig, Config::getMultiMapConfigs);
            this.apply(ConfigSections.REPLICATED_MAP, Config::addReplicatedMapConfig, Config::getReplicatedMapConfigs);
            this.apply(ConfigSections.RINGBUFFER, Config::addRingBufferConfig, Config::getRingbufferConfigs);
            this.apply(ConfigSections.TOPIC, Config::addTopicConfig, Config::getTopicConfigs);
            this.apply(ConfigSections.RELIABLE_TOPIC, Config::addReliableTopicConfig, Config::getReliableTopicConfigs);
            this.apply(ConfigSections.EXECUTOR_SERVICE, Config::addExecutorConfig, Config::getExecutorConfigs);
            this.apply(ConfigSections.DURABLE_EXECUTOR_SERVICE, Config::addDurableExecutorConfig, Config::getDurableExecutorConfigs);
            this.apply(ConfigSections.SCHEDULED_EXECUTOR_SERVICE, Config::addScheduledExecutorConfig, Config::getScheduledExecutorConfigs);
            this.apply(ConfigSections.CARDINALITY_ESTIMATOR, Config::addCardinalityEstimatorConfig, Config::getCardinalityEstimatorConfigs);
            this.apply(ConfigSections.PN_COUNTER, Config::addPNCounterConfig, Config::getPNCounterConfigs);
            this.apply(ConfigSections.FLAKE_ID_GENERATOR, Config::addFlakeIdGeneratorConfig, Config::getFlakeIdGeneratorConfigs);
            this.apply(ConfigSections.DATA_CONNECTION, Config::addDataConnectionConfig, Config::getDataConnectionConfigs);
            this.applyNetworkConfig();
            this.applyAdvancedNetworkConfig();
            this.applyWan();
            this.applyLicenseKey();
            this.applyUserCodeNamespaceConfig();
            this.applyLocalDeviceConfig();
        }

        private <T> void scan(ConfigSections section, Function<Config, Map<String, T>> getSubConfigs) {
            HashSet<String> scanSet = new HashSet<String>();
            Map<String, T> oldStaticSubConfigs = getSubConfigs.apply(this.oldConfig.getStaticConfig());
            Map<String, T> oldSubConfigs = getSubConfigs.apply(this.oldConfig);
            Map<String, T> newSubConfigs = getSubConfigs.apply(this.newConfig);
            for (String subConfigName : newSubConfigs.keySet()) {
                this.nextNamespace = new ConfigNamespace(section, subConfigName);
                DynamicConfigurationAwareConfig.checkStaticConfigDoesNotExist(oldStaticSubConfigs.get(subConfigName), newSubConfigs.get(subConfigName));
                EnterpriseClusterWideConfigurationService.this.checkCurrentConfigNullOrEqual(ConfigCheckMode.THROW_EXCEPTION, oldSubConfigs.get(subConfigName), newSubConfigs.get(subConfigName));
                scanSet.add(subConfigName);
                ++this.totalChangeCount;
            }
            if (!scanSet.isEmpty()) {
                this.scannedConfigs.put(section.getName(), scanSet);
            }
        }

        private void scanWan() {
            HashSet<String> scanSet = new HashSet<String>();
            Map<String, WanReplicationConfig> newSubConfigs = this.newConfig.getWanReplicationConfigs();
            for (String subConfigName : newSubConfigs.keySet()) {
                this.nextNamespace = new ConfigNamespace(ConfigSections.WAN_REPLICATION, subConfigName);
                scanSet.add(subConfigName);
                ++this.totalChangeCount;
            }
            if (!scanSet.isEmpty()) {
                this.scannedConfigs.put(ConfigSections.WAN_REPLICATION.getName(), scanSet);
            }
        }

        private void scanLicenseKey() {
            String newLicenseKey = this.newConfig.getLicenseKey();
            this.nextNamespace = new ConfigNamespace(ConfigSections.LICENSE_KEY);
            if (newLicenseKey != null) {
                this.scannedConfigs.put(ConfigSections.LICENSE_KEY.getName(), null);
                ++this.totalChangeCount;
            }
        }

        private void scanNetworkConfig() {
            if (this.oldConfig.getAdvancedNetworkConfig().isEnabled()) {
                return;
            }
            this.nextNamespace = new ConfigNamespace(ConfigSections.NETWORK);
            if (this.newConfig.getAdvancedNetworkConfig().isEnabled()) {
                throw new InvalidConfigurationException("Default networking is used in the current network configuration but the new one has advanced networking configuration enabled.");
            }
            this.scanTcpIpJoinMemberList(ConfigSections.NETWORK);
        }

        private void scanAdvancedNetworkConfig() {
            if (!this.oldConfig.getAdvancedNetworkConfig().isEnabled()) {
                return;
            }
            this.nextNamespace = new ConfigNamespace(ConfigSections.ADVANCED_NETWORK);
            if (!this.newConfig.getAdvancedNetworkConfig().isEnabled() && this.hasNonDefaultNetworkConfig(this.newConfig)) {
                throw new InvalidConfigurationException("Advanced networking enabled in the current configuration but the new configuration uses the regular networking configuration.");
            }
            this.scanTcpIpJoinMemberList(ConfigSections.ADVANCED_NETWORK);
        }

        private void scanTcpIpJoinMemberList(ConfigSections networkSection) {
            TcpIpConfig oldTcpIpConfig;
            TcpIpConfig newTcpIpConfig;
            if (networkSection == ConfigSections.NETWORK) {
                newTcpIpConfig = this.newConfig.getNetworkConfig().getJoin().getTcpIpConfig();
                oldTcpIpConfig = this.oldConfig.getNetworkConfig().getJoin().getTcpIpConfig();
            } else {
                newTcpIpConfig = this.newConfig.getAdvancedNetworkConfig().getJoin().getTcpIpConfig();
                oldTcpIpConfig = this.oldConfig.getAdvancedNetworkConfig().getJoin().getTcpIpConfig();
            }
            HashSet<String> newMembers = new HashSet<String>(newTcpIpConfig.getMembers());
            HashSet<String> oldMembers = new HashSet<String>(oldTcpIpConfig.getMembers());
            if (oldTcpIpConfig.isEnabled() && newTcpIpConfig.isEnabled()) {
                if (!newMembers.containsAll(oldMembers) || !oldMembers.containsAll(newMembers)) {
                    this.scannedConfigs.put(networkSection.getName(), null);
                    ++this.totalChangeCount;
                }
            } else {
                if (!oldTcpIpConfig.isEnabled() && newTcpIpConfig.isEnabled()) {
                    throw new InvalidConfigurationException("TCP-IP join configuration is not enabled in the current configuration but it's enabled in the updated one.");
                }
                if (oldTcpIpConfig.isEnabled() && !newTcpIpConfig.isEnabled() && this.hasNonDefaultNetworkConfig(this.newConfig)) {
                    throw new InvalidConfigurationException("TCP-IP join configuration is enabled in the current configuration but it's not enabled in the updated one.");
                }
            }
        }

        private void scanUserCodeNamespaceConfig() {
            HashSet<String> scanSet = new HashSet<String>();
            Map<String, UserCodeNamespaceConfig> newSubConfigs = ConfigAccessor.getNamespaceConfigs(this.newConfig.getNamespacesConfig());
            for (String subConfigName : newSubConfigs.keySet()) {
                this.nextNamespace = new ConfigNamespace(ConfigSections.USER_CODE_NAMESPACE, subConfigName);
                scanSet.add(subConfigName);
                ++this.totalChangeCount;
            }
            if (!scanSet.isEmpty()) {
                this.scannedConfigs.put(ConfigSections.USER_CODE_NAMESPACE.getName(), scanSet);
            }
        }

        private void scanTieredStorageConfig() {
            TieredStoreService tsService = (TieredStoreService)this.nodeEngine.getService("hz:ee:tieredStoreServiceImpl");
            tsService.validateDynamicConfig(this.newConfig, new NamedConfig[0]);
        }

        private void scanLocalDeviceConfig() {
            HashSet<String> scanSet = new HashSet<String>();
            Map<String, DeviceConfig> newSubConfigs = this.newConfig.getDeviceConfigs();
            Map<String, DeviceConfig> oldSubConfigs = this.oldConfig.getDeviceConfigs();
            if (oldSubConfigs.size() != newSubConfigs.size()) {
                throw new InvalidConfigurationException("Cannot add/remove local device dynamically");
            }
            for (String subConfigName : newSubConfigs.keySet()) {
                LocalDeviceConfig newDeviceConfig;
                this.nextNamespace = new ConfigNamespace(ConfigSections.LOCAL_DEVICE, subConfigName);
                if (!oldSubConfigs.containsKey(subConfigName)) {
                    throw new InvalidConfigurationException(String.format("Cannot change local device name: %s dynamically.", subConfigName));
                }
                LocalDeviceConfig oldDeviceConfig = (LocalDeviceConfig)oldSubConfigs.get(subConfigName);
                if (!this.checkOnlyCapacityChanges(oldDeviceConfig, newDeviceConfig = (LocalDeviceConfig)newSubConfigs.get(subConfigName))) {
                    throw new InvalidConfigurationException(String.format("Cannot dynamically update local device from %s to %s. Only capacity increase is supported.", oldDeviceConfig, newDeviceConfig));
                }
                scanSet.add(subConfigName);
                ++this.totalChangeCount;
            }
            if (!scanSet.isEmpty()) {
                this.scannedConfigs.put(ConfigSections.LOCAL_DEVICE.getName(), scanSet);
            }
        }

        private boolean checkOnlyCapacityChanges(LocalDeviceConfig oldDeviceConfig, LocalDeviceConfig newDeviceConfig) {
            if (!oldDeviceConfig.getName().equals(newDeviceConfig.getName())) {
                return false;
            }
            if (!oldDeviceConfig.getBaseDir().equals(newDeviceConfig.getBaseDir())) {
                return false;
            }
            if (oldDeviceConfig.getBlockSize() != newDeviceConfig.getBlockSize()) {
                return false;
            }
            if (oldDeviceConfig.getReadIOThreadCount() != newDeviceConfig.getReadIOThreadCount()) {
                return false;
            }
            return oldDeviceConfig.getWriteIOThreadCount() == newDeviceConfig.getWriteIOThreadCount();
        }

        private boolean hasNonDefaultNetworkConfig(Config config) {
            return config.getAdvancedNetworkConfig().isEnabled() || config.getNetworkConfig().getJoin().getTcpIpConfig().isEnabled() || config.getNetworkConfig().getJoin().getTcpIpConfig().getMembers().size() > 0;
        }

        private void incrementChangeCount() {
            ++this.appliedChangeCount;
            EnterpriseClusterWideConfigurationService.this.emitManagementCenterEvent(new ConfigUpdateProgressEvent(this.configUpdateProcessId, this.totalChangeCount, this.appliedChangeCount, this.nextNamespace));
        }

        private <T extends NamedConfig> void apply(ConfigSections section, BiFunction<Config, T, Config> addSubConfig, Function<Config, Map<String, T>> getSubConfigs) {
            Map<String, T> oldSubConfigs = getSubConfigs.apply(this.oldConfig);
            Map<String, T> newSubConfigs = getSubConfigs.apply(this.newConfig);
            if (this.scannedConfigs.containsKey(section.getName())) {
                for (String name : this.scannedConfigs.get(section.getName())) {
                    this.nextNamespace = new ConfigNamespace(section, name);
                    NamedConfig oldSubConfig = (NamedConfig)oldSubConfigs.get(name);
                    addSubConfig.apply(this.oldConfig, (Config)((Object)((NamedConfig)newSubConfigs.get(name))));
                    if (oldSubConfig == null || !oldSubConfig.equals(newSubConfigs.get(name))) {
                        this.addedConfigs.add(this.nextNamespace);
                    } else {
                        this.ignoredConfigs.add(this.nextNamespace);
                    }
                    this.incrementChangeCount();
                }
            }
        }

        private void applyWan() {
            if (this.scannedConfigs.containsKey(ConfigSections.WAN_REPLICATION.getName())) {
                for (String wanConfigName : this.scannedConfigs.get(ConfigSections.WAN_REPLICATION.getName())) {
                    this.nextNamespace = new ConfigNamespace(ConfigSections.WAN_REPLICATION, wanConfigName);
                    AddWanConfigResult addWanConfigResult = this.nodeEngine.getWanReplicationService().addWanReplicationConfig(this.newConfig.getWanReplicationConfig(wanConfigName));
                    if (!addWanConfigResult.getAddedPublisherIds().isEmpty()) {
                        this.addedConfigs.add(this.nextNamespace);
                    } else {
                        this.ignoredConfigs.add(this.nextNamespace);
                    }
                    this.incrementChangeCount();
                }
            }
        }

        private void applyLicenseKey() {
            if (this.scannedConfigs.containsKey(ConfigSections.LICENSE_KEY.getName())) {
                this.nextNamespace = new ConfigNamespace(ConfigSections.LICENSE_KEY);
                String oldLicenseKey = this.oldConfig.getLicenseKey();
                EnterpriseClusterWideConfigurationService.this.updateLicense(this.newConfig.getLicenseKey());
                if (oldLicenseKey == null || !oldLicenseKey.equals(this.newConfig.getLicenseKey())) {
                    this.addedConfigs.add(this.nextNamespace);
                } else {
                    this.ignoredConfigs.add(this.nextNamespace);
                }
                this.incrementChangeCount();
            }
        }

        private void applyLocalDeviceConfig() {
            if (this.scannedConfigs.containsKey(ConfigSections.LOCAL_DEVICE.getName())) {
                Capacity newCapacity;
                String deviceName;
                HashMap<String, Capacity> oldDeviceCapacity = new HashMap<String, Capacity>();
                HashMap<String, Capacity> newDeviceCapacity = new HashMap<String, Capacity>();
                for (Map.Entry<String, DeviceConfig> entry : this.oldConfig.getDeviceConfigs().entrySet()) {
                    deviceName = entry.getKey();
                    Capacity oldCapacity = entry.getValue().getCapacity();
                    oldDeviceCapacity.put(deviceName, oldCapacity);
                }
                for (Map.Entry<String, DeviceConfig> entry : this.newConfig.getDeviceConfigs().entrySet()) {
                    deviceName = entry.getKey();
                    newCapacity = entry.getValue().getCapacity();
                    Capacity oldCapacity = (Capacity)oldDeviceCapacity.get(deviceName);
                    if (newCapacity.bytes() < oldCapacity.bytes()) {
                        throw new InvalidConfigurationException("Tiered store new local device capacity: " + newCapacity.toPrettyString() + " cannot be less than old capacity: " + oldCapacity.toPrettyString());
                    }
                    newDeviceCapacity.put(deviceName, newCapacity);
                }
                this.checkLicensedDeviceCapacity(newDeviceCapacity);
                for (String configName : this.scannedConfigs.get(ConfigSections.LOCAL_DEVICE.getName())) {
                    boolean changed;
                    this.nextNamespace = new ConfigNamespace(ConfigSections.LOCAL_DEVICE, configName);
                    EnterpriseClusterWideConfigurationService.this.increaseLocalDeviceCapacity(newDeviceCapacity);
                    Capacity oldCapacity = (Capacity)oldDeviceCapacity.get(configName);
                    newCapacity = (Capacity)newDeviceCapacity.get(configName);
                    boolean bl = changed = !oldCapacity.equals(newCapacity);
                    if (changed) {
                        this.addedConfigs.add(this.nextNamespace);
                    } else {
                        this.ignoredConfigs.add(this.nextNamespace);
                    }
                    this.incrementChangeCount();
                }
            }
        }

        private void applyNetworkConfig() {
            if (this.scannedConfigs.containsKey(ConfigSections.NETWORK.getName())) {
                this.nextNamespace = new ConfigNamespace(ConfigSections.NETWORK);
                ArrayList<String> oldMembers = new ArrayList<String>(this.oldConfig.getNetworkConfig().getJoin().getTcpIpConfig().getMembers());
                List<String> newMembers = this.newConfig.getNetworkConfig().getJoin().getTcpIpConfig().getMembers();
                EnterpriseClusterWideConfigurationService.this.updateTcpIpConfigMemberList(newMembers);
                if (!oldMembers.equals(newMembers)) {
                    this.addedConfigs.add(this.nextNamespace);
                } else {
                    this.ignoredConfigs.add(this.nextNamespace);
                }
                this.incrementChangeCount();
            }
        }

        private void applyAdvancedNetworkConfig() {
            if (this.scannedConfigs.containsKey(ConfigSections.ADVANCED_NETWORK.getName())) {
                this.nextNamespace = new ConfigNamespace(ConfigSections.ADVANCED_NETWORK);
                ArrayList<String> oldMembers = new ArrayList<String>(this.oldConfig.getAdvancedNetworkConfig().getJoin().getTcpIpConfig().getMembers());
                List<String> newMembers = this.newConfig.getAdvancedNetworkConfig().getJoin().getTcpIpConfig().getMembers();
                EnterpriseClusterWideConfigurationService.this.updateTcpIpConfigMemberList(newMembers);
                if (!oldMembers.equals(newMembers)) {
                    this.addedConfigs.add(this.nextNamespace);
                } else {
                    this.ignoredConfigs.add(this.nextNamespace);
                }
                this.incrementChangeCount();
            }
        }

        private void applyUserCodeNamespaceConfig() {
            if (this.scannedConfigs.containsKey(ConfigSections.USER_CODE_NAMESPACE.getName())) {
                for (String nsName : this.scannedConfigs.get(ConfigSections.USER_CODE_NAMESPACE.getName())) {
                    this.nextNamespace = new ConfigNamespace(ConfigSections.USER_CODE_NAMESPACE, nsName);
                    UserCodeNamespaceConfig oldNamespaceConfig = ConfigAccessor.getNamespaceConfigs(this.oldConfig.getNamespacesConfig()).get(nsName);
                    UserCodeNamespaceConfig nsConfig = ConfigAccessor.getNamespaceConfigs(this.newConfig.getNamespacesConfig()).get(nsName);
                    this.oldConfig.getNamespacesConfig().addNamespaceConfig(nsConfig);
                    if (oldNamespaceConfig == null || ConfigAccessor.getResourceDefinitions(oldNamespaceConfig).equals(ConfigAccessor.getResourceDefinitions(nsConfig))) {
                        this.addedConfigs.add(this.nextNamespace);
                    } else {
                        this.ignoredConfigs.add(this.nextNamespace);
                    }
                    this.incrementChangeCount();
                }
            }
        }

        public void setNewConfig(Config newConfig) {
            this.newConfig = newConfig;
        }

        private void checkLicense() {
            EnterpriseNodeExtension nodeExtension = (EnterpriseNodeExtension)this.nodeEngine.getNode().getNodeExtension();
            nodeExtension.checkLicensePerFeature(Feature.DYNAMIC_CONFIGURATION);
        }

        private void checkLicensedDeviceCapacity(Map<String, Capacity> newDeviceCapacity) {
            EnterpriseNodeExtension nodeExtension = (EnterpriseNodeExtension)this.nodeEngine.getNode().getNodeExtension();
            int licensedTsMemorySizeInGB = nodeExtension.getLicense().getAllowedTieredStoreSize();
            Capacity licensedCapacity = new Capacity(licensedTsMemorySizeInGB, MemoryUnit.GIGABYTES);
            long licensedTsMemorySizeInBytes = licensedCapacity.bytes();
            LicenseMemoryChecker licenseMemoryChecker = nodeExtension.getLicenseMemoryChecker();
            if (licenseMemoryChecker.isUnlimitedTSLicense()) {
                return;
            }
            ClusterService clusterService = (ClusterService)this.nodeEngine.getService("hz:core:clusterService");
            int dataMemberCount = clusterService.getMembers(MemberSelectors.DATA_MEMBER_SELECTOR).size();
            long newTotalTSMemorySize = 0L;
            for (Map.Entry<String, Capacity> entry : newDeviceCapacity.entrySet()) {
                Capacity newCapacity = entry.getValue();
                newTotalTSMemorySize += newCapacity.bytes() * (long)dataMemberCount;
            }
            if (newTotalTSMemorySize > licensedTsMemorySizeInBytes) {
                Capacity newTotalCapacity = new Capacity(newTotalTSMemorySize, MemoryUnit.BYTES);
                licenseMemoryChecker.logLocalDeviceCapacityExceedsLicensedLimit(newTotalCapacity, licensedCapacity);
            }
        }
    }

    public static class ConfigurationValidationException
    extends RuntimeException {
        public ConfigurationValidationException(InvalidConfigurationException cause) {
            super(cause);
        }
    }

    public static class ConfigurationParsingException
    extends IllegalArgumentException {
        public ConfigurationParsingException(IllegalArgumentException cause) {
            super(cause);
        }
    }
}

