/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.bplustree;

import com.hazelcast.internal.bplustree.LockManager;
import com.hazelcast.internal.bplustree.TStoreAllocator;
import com.hazelcast.internal.tstore.hybridlog.PinType;
import com.hazelcast.internal.util.collection.HsaHeapMemoryManager;
import com.hazelcast.internal.util.collection.Long2LongHashMap;
import com.hazelcast.internal.util.collection.LongCursor;
import com.hazelcast.internal.util.collection.LongSet;
import com.hazelcast.internal.util.collection.LongSetHsa;
import com.hazelcast.internal.util.collection.PartitionIdSet;
import java.util.function.LongPredicate;
import java.util.function.ObjLongConsumer;

public final class LockingContext {
    private final LongSet locks = new LongSetHsa(0L, new HsaHeapMemoryManager());
    private final Long2LongHashMap pins = new Long2LongHashMap(0L);
    private long lastUnpinnedAddress = 0L;
    private PartitionIdSet registeredPartitions;
    private int stashedPinCount;
    private long[] stashedPins = new long[0];

    void addLock(long lockAddr) {
        this.locks.add(lockAddr);
    }

    void removeLock(long lockAddr) {
        this.locks.remove(lockAddr);
    }

    void releaseLocks(LockManager lockManager) {
        LongCursor cursor = this.locks.cursor();
        while (cursor.advance()) {
            long lockAddr = cursor.value();
            lockManager.releaseLock(lockAddr);
        }
        this.locks.clear();
    }

    boolean hasNoLocksAndPins() {
        return this.locks.isEmpty() && this.pins.isEmpty() && this.stashedPinCount == 0;
    }

    boolean hasNoUnpinnedAddress() {
        return this.lastUnpinnedAddress == 0L;
    }

    long replaceAddressToPin(long nodeAddr) {
        long addressToPin = this.lastUnpinnedAddress;
        this.lastUnpinnedAddress = nodeAddr;
        return addressToPin;
    }

    long consumeAddressToUnpin(long nodeAddr) {
        assert (nodeAddr > 0L);
        long lastUnpinnedAddress = Math.abs(this.lastUnpinnedAddress);
        assert (lastUnpinnedAddress == nodeAddr || this.pins.containsKey(nodeAddr));
        if (nodeAddr == lastUnpinnedAddress) {
            this.lastUnpinnedAddress = 0L;
            return 0L;
        }
        return nodeAddr;
    }

    boolean isPinned(long nodeAddr) {
        assert (nodeAddr > 0L);
        long lastUnpinnedAddress = Math.abs(this.lastUnpinnedAddress);
        assert (lastUnpinnedAddress == nodeAddr || this.pins.containsKey(nodeAddr));
        return lastUnpinnedAddress != nodeAddr;
    }

    void addPin(long nodeAddr, long logicalAddress) {
        assert (nodeAddr > 0L);
        assert (logicalAddress != 0L);
        long replaced = this.pins.put(nodeAddr, logicalAddress);
        assert (replaced == 0L);
    }

    PinType resolvePinType(long node) {
        long rawValue = this.pins.get(node);
        assert (rawValue != 0L) : "Node " + node + " is not pinned";
        return rawValue < 0L ? PinType.WRITE : PinType.READ;
    }

    long resolvePinned(long node) {
        return Math.abs(this.pins.get(node));
    }

    void removePin(long nodeAddr) {
        assert (nodeAddr > 0L);
        long removed = this.pins.remove(nodeAddr);
        assert (removed != 0L);
    }

    void releasePins(ObjLongConsumer<LockingContext> releaser) {
        this.pins.longForEach((node, logical) -> releaser.accept(this, node));
        this.pins.clear();
        this.stashedPinCount = 0;
    }

    void stashPins(LongPredicate stasher) {
        int stashedPinCountBefore = this.stashedPinCount;
        this.pins.longForEach((stable, logical) -> {
            if (stasher.test(logical)) {
                if (this.stashedPins.length == this.stashedPinCount) {
                    long[] newStashedPins = new long[this.stashedPins.length + 1];
                    System.arraycopy(this.stashedPins, 0, newStashedPins, 0, this.stashedPins.length);
                    this.stashedPins = newStashedPins;
                }
                this.stashedPins[this.stashedPinCount] = stable;
                ++this.stashedPinCount;
            }
        });
        for (int i = stashedPinCountBefore; i < this.stashedPinCount; ++i) {
            this.pins.remove(this.stashedPins[i]);
        }
    }

    void unstashPins(LongPredicate unstasher) {
        while (true) {
            for (int i = this.stashedPinCount - 1; i >= 0; --i) {
                if (unstasher.test(this.stashedPins[i])) {
                    --this.stashedPinCount;
                    continue;
                }
                long failed = this.stashedPins[i];
                this.stashedPins[i] = this.stashedPins[this.stashedPinCount - 1];
                this.stashedPins[this.stashedPinCount - 1] = failed;
            }
            break;
        }
    }

    void addPartition(int partitionId, TStoreAllocator allocator) {
        if (this.registeredPartitions == null) {
            this.registeredPartitions = allocator.newPartitionIdSet();
        }
        this.registeredPartitions.add(partitionId);
    }

    boolean hasPartition(int partitionId) {
        return this.registeredPartitions != null && this.registeredPartitions.contains(partitionId);
    }

    PartitionIdSet getPartitions() {
        return this.registeredPartitions;
    }

    void clearPartitions() {
        this.registeredPartitions.clear();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("LockingContext{ ");
        builder.append(" locks { ");
        LongCursor lockCursor = this.locks.cursor();
        while (lockCursor.advance()) {
            long lockAddr = lockCursor.value();
            builder.append(lockAddr);
            builder.append(" ");
        }
        builder.append(" } ");
        builder.append(" pins { ");
        Long2LongHashMap.LongLongCursor pinCursor = this.pins.cursor();
        while (pinCursor.advance()) {
            long pin = pinCursor.key();
            builder.append(pin);
            builder.append(" ");
        }
        builder.append(" } ");
        builder.append("}");
        return builder.toString();
    }
}

