/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.bplustree;

import com.hazelcast.internal.bplustree.BPlusTreeLimitException;
import com.hazelcast.internal.bplustree.DefaultLockFairnessPolicy;
import com.hazelcast.internal.bplustree.LockFairnessPolicy;
import com.hazelcast.internal.bplustree.LockManager;
import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.util.HashUtil;
import com.hazelcast.internal.util.QuickMath;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public final class HDLockManager
implements LockManager {
    private static final int MAX_USERS_COUNT = Short.MAX_VALUE;
    private static final int MAX_WAITERS_COUNT = 65535;
    private static final long CLEARING_USERS_COUNT_MASK = -65536L;
    private static final long CLEARING_READ_WAITERS_COUNT_MASK = -4294901761L;
    private static final long CLEARING_WRITE_WAITERS_COUNT_MASK = -281470681743361L;
    private static final int SPIN_COUNT = 32;
    private final ReentrantLock[] stripedLocks;
    private final Condition[] stripedReadConditions;
    private final Condition[] stripedWriteConditions;
    private final long stripeMask;
    private final LockFairnessPolicy lockFairnessPolicy;

    HDLockManager(int stripesCount) {
        this(stripesCount, new DefaultLockFairnessPolicy());
    }

    HDLockManager(int stripesCount, LockFairnessPolicy lockFairnessPolicy) {
        if (!QuickMath.isPowerOfTwo(stripesCount)) {
            throw new IllegalArgumentException("Number of stripes " + stripesCount + " must be a power of 2.");
        }
        this.checkFairnessPolicy(lockFairnessPolicy);
        this.stripeMask = stripesCount - 1;
        this.stripedLocks = new ReentrantLock[stripesCount];
        this.stripedReadConditions = new Condition[stripesCount];
        this.stripedWriteConditions = new Condition[stripesCount];
        for (int i = 0; i < stripesCount; ++i) {
            ReentrantLock lock;
            this.stripedLocks[i] = lock = new ReentrantLock();
            this.stripedReadConditions[i] = lock.newCondition();
            this.stripedWriteConditions[i] = lock.newCondition();
        }
        this.lockFairnessPolicy = lockFairnessPolicy;
    }

    private void checkFairnessPolicy(LockFairnessPolicy lockFairnessPolicy) {
        float readLockRequestWinsPercentage = lockFairnessPolicy.readLockRequestWinsPercentage();
        float writeLockRequestWinsPercentage = lockFairnessPolicy.writeLockRequestWinsPercentage();
        float writeWaiterWinsPercentage = lockFairnessPolicy.writeWaiterWinsPercentage();
        if (!(this.checkPercentage(readLockRequestWinsPercentage) && this.checkPercentage(writeLockRequestWinsPercentage) && this.checkPercentage(writeWaiterWinsPercentage))) {
            throw new IllegalArgumentException("Invalid lock fairness policy. Read lock request wins percentage " + readLockRequestWinsPercentage + "Write lock request wins percentage " + writeLockRequestWinsPercentage + "Write waiter wins percentage " + writeWaiterWinsPercentage);
        }
    }

    @Override
    public void readLock(long lockAddr) {
        this.acquireLock(lockAddr, true);
    }

    private boolean tryLock(long lockAddr, boolean sharedAccess) {
        long lockState = this.getLockState(lockAddr);
        return this.isCompatible(lockState, sharedAccess) && this.tryIncrementUsersCount(lockAddr, lockState, sharedAccess);
    }

    @Override
    public boolean tryReadLock(long lockAddr) {
        return this.tryLock(lockAddr, true);
    }

    @Override
    public void instantDurationReadLock(long lockAddr) {
        this.instantDurationLock(lockAddr, true);
    }

    @Override
    public boolean tryInstantDurationReadLock(long lockAddr) {
        return this.tryInstantDurationLock(lockAddr, true);
    }

    @Override
    public void writeLock(long lockAddr) {
        this.acquireLock(lockAddr, false);
    }

    @Override
    public boolean tryUpgradeToWriteLock(long lockAddr) {
        for (int i = 0; i < 32; ++i) {
            long lockState = this.getLockState(lockAddr);
            assert (HDLockManager.getUsersCount(lockState) >= 1);
            if (HDLockManager.getUsersCount(lockState) != 1) continue;
            if (this.tryIncrementUsersCount(lockAddr, lockState, false)) {
                return true;
            }
            --i;
        }
        return false;
    }

    @Override
    public boolean tryWriteLock(long lockAddr) {
        return this.tryLock(lockAddr, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void instantDurationLock(long lockAddr, boolean sharedAccess) {
        int stripeIndex = this.getStripe(lockAddr);
        ReentrantLock stripedLock = this.stripedLocks[stripeIndex];
        boolean interrupted = false;
        stripedLock.lock();
        try {
            long lockState = this.incrementWaitersCount(lockAddr, sharedAccess);
            while (true) {
                if (!this.isCompatible(lockState, sharedAccess)) {
                    Condition condition = sharedAccess ? this.stripedReadConditions[stripeIndex] : this.stripedWriteConditions[stripeIndex];
                    try {
                        condition.await();
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                } else {
                    long newLockState = this.updateWaitersCount0(lockState, sharedAccess, false);
                    if (GlobalMemoryAccessorRegistry.AMEM.compareAndSwapLong(lockAddr, lockState, newLockState)) {
                        this.notifyWaiters(lockAddr, newLockState);
                        break;
                    }
                }
                lockState = this.getLockState(lockAddr);
            }
        }
        finally {
            stripedLock.unlock();
            if (interrupted) {
                HDLockManager.selfInterrupt();
            }
        }
    }

    private boolean tryInstantDurationLock(long lockAddr, boolean sharedAccess) {
        long newLockState;
        long lockState = this.getLockState(lockAddr);
        if (!this.isCompatible(lockState, sharedAccess)) {
            return false;
        }
        if (!this.tryIncrementWaiterCount(lockAddr, lockState, sharedAccess)) {
            return false;
        }
        while (!GlobalMemoryAccessorRegistry.AMEM.compareAndSwapLong(lockAddr, lockState = this.getLockState(lockAddr), newLockState = this.updateWaitersCount0(lockState, sharedAccess, false))) {
        }
        this.notifyWaiters(lockAddr, newLockState);
        return true;
    }

    @Override
    public void instantDurationWriteLock(long lockAddr) {
        this.instantDurationLock(lockAddr, false);
    }

    @Override
    public boolean tryInstantDurationWriteLock(long lockAddr) {
        return this.tryInstantDurationLock(lockAddr, false);
    }

    private void acquireLock(long lockAddr, boolean sharedAccess) {
        int spinResult = this.tryAcquireSpin(lockAddr, sharedAccess);
        if (spinResult < 0) {
            boolean blockRequest = spinResult == -2;
            this.acquireLock0(lockAddr, blockRequest, sharedAccess);
        }
    }

    private int tryAcquireSpin(long lockAddr, boolean sharedAccess) {
        long lockState = this.getLockState(lockAddr);
        if (this.requestShouldBlock(lockState, sharedAccess)) {
            return -2;
        }
        for (int i = 0; i < 32; ++i) {
            if (this.isCompatible(lockState, sharedAccess) && this.tryIncrementUsersCount(lockAddr, lockState, sharedAccess)) {
                return 0;
            }
            lockState = this.getLockState(lockAddr);
        }
        return -1;
    }

    private boolean requestShouldBlock(long lockState, boolean sharedAccess) {
        if (sharedAccess && this.hasWaiters(lockState) && this.readerShouldBlock()) {
            return true;
        }
        return !sharedAccess && this.hasWaiters(lockState) && this.writerShouldBlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquireLock0(long lockAddr, boolean blockRequest, boolean sharedAccess) {
        int stripeIndex = this.getStripe(lockAddr);
        ReentrantLock stripedLock = this.stripedLocks[stripeIndex];
        boolean interrupted = false;
        stripedLock.lock();
        try {
            boolean blockOnFirstAttempt;
            long lockState = this.incrementWaitersCount(lockAddr, sharedAccess);
            boolean bl = blockOnFirstAttempt = blockRequest && this.waitersCount(lockState) > 1;
            while (true) {
                if (!this.isCompatible(lockState, sharedAccess) || blockOnFirstAttempt) {
                    interrupted = false;
                    Condition condition = sharedAccess ? this.stripedReadConditions[stripeIndex] : this.stripedWriteConditions[stripeIndex];
                    try {
                        condition.await();
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                    blockOnFirstAttempt = false;
                } else if (this.tryIncrementUsersCountAndDecrementWaitersCount(lockAddr, lockState, sharedAccess)) {
                    break;
                }
                lockState = this.getLockState(lockAddr);
            }
        }
        finally {
            stripedLock.unlock();
            if (interrupted) {
                HDLockManager.selfInterrupt();
            }
        }
    }

    @Override
    public void releaseLock(long lockAddr) {
        int usersCount;
        boolean sharedAccess;
        long newLockState;
        long oldLockState;
        do {
            oldLockState = this.getLockState(lockAddr);
            usersCount = HDLockManager.getUsersCount(oldLockState);
            assert (usersCount > 0 || usersCount == -1);
        } while (!GlobalMemoryAccessorRegistry.AMEM.compareAndSwapLong(lockAddr, oldLockState, newLockState = this.decrementUsersCount0(oldLockState, sharedAccess = usersCount > 0)));
        this.notifyWaiters(lockAddr, newLockState);
    }

    private long incrementWaitersCount(long lockAddr, boolean sharedAccess) {
        long newLockState;
        long lockState;
        while (!GlobalMemoryAccessorRegistry.AMEM.compareAndSwapLong(lockAddr, lockState = this.getLockState(lockAddr), newLockState = this.updateWaitersCount0(lockState, sharedAccess, true))) {
        }
        return newLockState;
    }

    private long updateWaitersCount0(long lockState, boolean sharedAccess, boolean increment) {
        long newWaitersCount;
        int shiftBits = sharedAccess ? 16 : 32;
        long clearingMask = sharedAccess ? -4294901761L : -281470681743361L;
        int waitersCount = HDLockManager.getWaitersCount(lockState, sharedAccess);
        long l = newWaitersCount = increment ? (long)(waitersCount + 1) : (long)(waitersCount - 1);
        assert (newWaitersCount >= 0L) : newWaitersCount;
        if (newWaitersCount > 65535L) {
            throw new BPlusTreeLimitException("B+tree lock reached the maximum waiters's count limit 65535");
        }
        return lockState & clearingMask | newWaitersCount << shiftBits;
    }

    static int getUsersCount(long lockState) {
        return (short)(lockState & 0xFFFFL);
    }

    private boolean tryIncrementUsersCount(long lockAddr, long oldLockState, boolean sharedAccess) {
        long newLockState = this.incrementUsersCount0(oldLockState, sharedAccess);
        return GlobalMemoryAccessorRegistry.AMEM.compareAndSwapLong(lockAddr, oldLockState, newLockState);
    }

    private boolean tryIncrementWaiterCount(long lockAddr, long oldLockState, boolean sharedAccess) {
        long newLockState = this.updateWaitersCount0(oldLockState, sharedAccess, true);
        return GlobalMemoryAccessorRegistry.AMEM.compareAndSwapLong(lockAddr, oldLockState, newLockState);
    }

    private long decrementUsersCount0(long lockState, boolean sharedAccess) {
        long newUsersCount;
        int usersCount = HDLockManager.getUsersCount(lockState);
        long l = newUsersCount = sharedAccess ? (long)(usersCount - 1) : 0L;
        assert (newUsersCount >= 0L);
        return lockState & 0xFFFFFFFFFFFF0000L | newUsersCount & 0xFFFFL;
    }

    private long incrementUsersCount0(long lockState, boolean sharedAccess) {
        long newUsersCount;
        long l = newUsersCount = sharedAccess ? (long)(HDLockManager.getUsersCount(lockState) + 1) : -1L;
        if (newUsersCount > 32767L) {
            throw new BPlusTreeLimitException("B+tree lock reached the maximum user's count limit 32767");
        }
        return lockState & 0xFFFFFFFFFFFF0000L | newUsersCount & 0xFFFFL;
    }

    private boolean tryIncrementUsersCountAndDecrementWaitersCount(long lockAddr, long oldLockState, boolean sharedAccess) {
        long newLockState = this.updateWaitersCount0(oldLockState, sharedAccess, false);
        newLockState = this.incrementUsersCount0(newLockState, sharedAccess);
        return GlobalMemoryAccessorRegistry.AMEM.compareAndSwapLong(lockAddr, oldLockState, newLockState);
    }

    static int getReadWaitersCount(long lockState) {
        return HDLockManager.getWaitersCount(lockState, true);
    }

    static int getWriteWaitersCount(long lockState) {
        return HDLockManager.getWaitersCount(lockState, false);
    }

    private static int getWaitersCount(long lockState, boolean read) {
        int shiftBits = read ? 16 : 32;
        return (int)(lockState >> shiftBits & 0xFFFFL);
    }

    private long getLockState(long lockAddr) {
        return GlobalMemoryAccessorRegistry.AMEM.getLongVolatile(lockAddr);
    }

    private boolean hasWaiters(long lockState) {
        return HDLockManager.getReadWaitersCount(lockState) > 0 || HDLockManager.getWriteWaitersCount(lockState) > 0;
    }

    private int waitersCount(long lockState) {
        return HDLockManager.getReadWaitersCount(lockState) + HDLockManager.getWriteWaitersCount(lockState);
    }

    private boolean isCompatible(long lockState, boolean sharedAccess) {
        int usersCount = HDLockManager.getUsersCount(lockState);
        return sharedAccess ? usersCount >= 0 : usersCount == 0;
    }

    private void notifyWaiters(long lockAddr, long lockState) {
        int newReadWaitersCount = HDLockManager.getReadWaitersCount(lockState);
        int newWriteWaitersCount = HDLockManager.getWriteWaitersCount(lockState);
        int newUsersCount = HDLockManager.getUsersCount(lockState);
        if (newUsersCount == 0) {
            if (newReadWaitersCount > 0 && newWriteWaitersCount > 0) {
                boolean notifyWriter = this.nextNotifyWriter();
                this.notifyWaiters0(lockAddr, notifyWriter);
            } else if (newWriteWaitersCount > 0) {
                this.notifyWaiters0(lockAddr, true);
            } else if (newReadWaitersCount > 0) {
                this.notifyWaiters0(lockAddr, false);
            }
        }
    }

    boolean readerShouldBlock() {
        float readLockRequestWinsPercentage = this.lockFairnessPolicy.readLockRequestWinsPercentage();
        return !this.fullPercentage(readLockRequestWinsPercentage) && (float)this.nextPercentage() >= readLockRequestWinsPercentage;
    }

    boolean writerShouldBlock() {
        float writeLockRequestWinsPercentage = this.lockFairnessPolicy.writeLockRequestWinsPercentage();
        return !this.fullPercentage(writeLockRequestWinsPercentage) && (float)this.nextPercentage() >= writeLockRequestWinsPercentage;
    }

    boolean nextNotifyWriter() {
        float writeWaiterWinsPercentage = this.lockFairnessPolicy.writeWaiterWinsPercentage();
        return this.fullPercentage(writeWaiterWinsPercentage) || (float)this.nextPercentage() < writeWaiterWinsPercentage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWaiters0(long lockAddr, boolean writers) {
        int stripeIndex = this.getStripe(lockAddr);
        ReentrantLock stripedLock = this.stripedLocks[stripeIndex];
        Condition condition = writers ? this.stripedWriteConditions[stripeIndex] : this.stripedReadConditions[stripeIndex];
        stripedLock.lock();
        try {
            condition.signalAll();
        }
        finally {
            stripedLock.unlock();
        }
    }

    private int getStripe(long lockAddr) {
        return (int)(HashUtil.fastLongMix(lockAddr) & this.stripeMask);
    }

    private static void selfInterrupt() {
        Thread.currentThread().interrupt();
    }

    private int nextPercentage() {
        return ThreadLocalRandom.current().nextInt(100);
    }

    private boolean fullPercentage(float percentage) {
        return percentage == 100.0f;
    }

    private boolean checkPercentage(float percentage) {
        return percentage >= 0.0f && percentage <= 100.0f;
    }
}

