/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.bplustree;

import com.hazelcast.internal.bplustree.BPlusTreeKeyAccessor;
import com.hazelcast.internal.bplustree.BPlusTreeKeyComparator;
import com.hazelcast.internal.bplustree.EntrySlotPayload;
import com.hazelcast.internal.bplustree.HDBTreeNodeBaseAccessor;
import com.hazelcast.internal.bplustree.LockManager;
import com.hazelcast.internal.bplustree.LockingContext;
import com.hazelcast.internal.bplustree.NodeSplitStrategy;
import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;

class HDBTreeInnerNodeAccessor
extends HDBTreeNodeBaseAccessor {
    static final NativeMemoryData EMPTY_INDEX_KEY;
    static final NativeMemoryData EMPTY_ENTRY_KEY;

    HDBTreeInnerNodeAccessor(LockManager lockManager, EnterpriseSerializationService ess, BPlusTreeKeyComparator keyComparator, BPlusTreeKeyAccessor keyAccessor, MemoryAllocator keyAllocator, MemoryAllocator btreeAllocator, int nodeSize, NodeSplitStrategy nodeSplitStrategy, EntrySlotPayload entrySlotPayload) {
        super(lockManager, ess, keyComparator, keyAccessor, keyAllocator, btreeAllocator, nodeSize, nodeSplitStrategy, entrySlotPayload);
    }

    @Override
    int getOffsetEntries() {
        return 20;
    }

    long getChildNode(long nodeAddr, Comparable indexKey, Data entryKey, LockingContext lockingContext) {
        int slot = this.lowerBound(nodeAddr, indexKey, entryKey, lockingContext);
        return this.getValueAddr(nodeAddr, slot, lockingContext);
    }

    @Override
    long split(long nodeAddr, LockingContext lockingContext) {
        int level = this.getNodeLevel(nodeAddr, lockingContext);
        assert (level > 0);
        long newInnerAddr = this.newNodeLocked(lockingContext);
        int keysCount = this.getKeysCount(nodeAddr, lockingContext);
        int newInnerKeysCount = this.nodeSplitStrategy.getNewNodeKeysCount(keysCount);
        int startSlot = keysCount - newInnerKeysCount;
        long memCpyStartAddr = this.getSlotAddr(nodeAddr, startSlot, lockingContext);
        long memCpyEndAddr = this.freeSpaceBeginAddr(nodeAddr, lockingContext);
        assert (memCpyStartAddr <= memCpyEndAddr);
        GlobalMemoryAccessorRegistry.AMEM.copyMemory(memCpyStartAddr, this.translateToPhysical(newInnerAddr, lockingContext) + (long)this.getOffsetEntries(), memCpyEndAddr - memCpyStartAddr);
        this.setKeysCount(newInnerAddr, newInnerKeysCount, lockingContext);
        this.setNodeLevel(newInnerAddr, level, lockingContext);
        long startSlotEntryOffset = this.getSlotEntryOffset(nodeAddr, startSlot, lockingContext);
        for (int slot = 0; slot <= newInnerKeysCount; ++slot) {
            this.setSlotEntryOffset(newInnerAddr, slot, (short)((long)this.getSlotEntryOffset(nodeAddr, startSlot + slot, lockingContext) - startSlotEntryOffset), lockingContext);
        }
        this.removeLastKSlotEntries(nodeAddr, newInnerKeysCount + 1, lockingContext);
        this.incSequenceCounter(nodeAddr, lockingContext);
        this.incSequenceCounter(newInnerAddr, lockingContext);
        return newInnerAddr;
    }

    @Override
    void removeLastKSlotEntries(long nodeAddr, int k, LockingContext lockingContext) {
        int lastSlot = this.getLastSlot(nodeAddr, lockingContext);
        assert (k <= lastSlot + 1);
        if (k <= lastSlot) {
            long zerosSlotEntryOffsetAddr = this.getSlotEntryOffsetAddr(nodeAddr, 0, lockingContext);
            int shift = k * 2;
            GlobalMemoryAccessorRegistry.AMEM.copyMemory(zerosSlotEntryOffsetAddr, zerosSlotEntryOffsetAddr + (long)shift, (long)(lastSlot - k + 1) * 2L);
        }
        this.setKeysCount(nodeAddr, this.getKeysCount(nodeAddr, lockingContext) - k, lockingContext);
    }

    @Override
    int getSeparationSlot(long nodeAddr, LockingContext lockingContext) {
        int keysCount = this.getKeysCount(nodeAddr, lockingContext);
        assert (keysCount >= 2);
        return keysCount - this.nodeSplitStrategy.getNewNodeKeysCount(keysCount) - 1;
    }

    void insertToEmptyNode(long nodeAddr, long childAddr, LockingContext lockingContext) {
        assert (this.getKeysCount(nodeAddr, lockingContext) == 0);
        this.setKeysCount(nodeAddr, -1, lockingContext);
        this.insertSlot(nodeAddr, 0, EMPTY_INDEX_KEY, EMPTY_ENTRY_KEY, childAddr, lockingContext);
        this.incSequenceCounter(nodeAddr, lockingContext);
        assert (this.getKeysCount(nodeAddr, lockingContext) == 0);
    }

    int insert(long nodeAddr, long indexKeyAddr, long entryKeyAddr, long childAddr, LockingContext lockingContext) {
        NativeMemoryData entryKeyData = new NativeMemoryData().reset(entryKeyAddr);
        Comparable indexKey = this.keyAccessor.convertToObject(indexKeyAddr);
        Comparable wrappedIndexKey = this.keyComparator.wrapIndexKey(indexKey);
        int slot = this.lowerBound(nodeAddr, wrappedIndexKey, entryKeyData, lockingContext);
        this.insertSlot(nodeAddr, slot, new NativeMemoryData().reset(indexKeyAddr), entryKeyData, childAddr, lockingContext);
        this.setValueAddr(nodeAddr, slot, this.getValueAddr(nodeAddr, slot + 1, lockingContext), lockingContext);
        this.setValueAddr(nodeAddr, slot + 1, childAddr, lockingContext);
        this.incSequenceCounter(nodeAddr, lockingContext);
        return slot;
    }

    void remove(long nodeAddr, Comparable indexKey, NativeMemoryData entryKey, LockingContext lockingContext) {
        int keysCount = this.getKeysCount(nodeAddr, lockingContext);
        assert (this.getNodeLevel(nodeAddr, lockingContext) >= 1);
        assert (keysCount >= 1);
        int slot = this.lowerBound(nodeAddr, indexKey, entryKey, lockingContext);
        assert (slot <= keysCount) : "slot=" + slot + ", keysCount=" + keysCount;
        int slotToRemove = slot;
        if (slot == keysCount) {
            this.setValueAddr(nodeAddr, slot, this.getValueAddr(nodeAddr, slot - 1, lockingContext), lockingContext);
            slotToRemove = slot - 1;
        }
        this.removeSlot(nodeAddr, slotToRemove, lockingContext);
        this.incSequenceCounter(nodeAddr, lockingContext);
        assert (this.getValueAddr(nodeAddr, 0, lockingContext) != 0L);
    }

    @Override
    long freeSpaceBeginAddr(long nodeAddr, LockingContext lockingContext) {
        assert (this.getNodeLevel(nodeAddr, lockingContext) > 0);
        int lastSlot = this.getLastSlot(nodeAddr, lockingContext);
        if (lastSlot == -1) {
            return this.translateToPhysical(nodeAddr, lockingContext) + (long)this.getOffsetEntries();
        }
        return this.getSlotAddr(nodeAddr, lastSlot, lockingContext) + 8L;
    }

    @Override
    int getLastSlot(long nodeAddr, LockingContext lockingContext) {
        assert (this.getNodeLevel(nodeAddr, lockingContext) > 0);
        return this.getKeysCount(nodeAddr, lockingContext);
    }

    boolean isSplittable(long nodeAddr, LockingContext lockingContext) {
        return this.getKeysCount(nodeAddr, lockingContext) >= 2;
    }

    static {
        EMPTY_ENTRY_KEY = EMPTY_INDEX_KEY = new NativeMemoryData();
    }
}

